;;; def-mac.scm -- Simple-minded macros for SCM4a14 or greater.
;;;
;;; (define-macro (name args)
;;;   ;;; expr returning list to be evaluated in place of (name ...)
;;;  )
;;;
;;; An Example:
;;; (define-macro inc
;;;   (lambda (val)
;;;     `(set! ,val (+ ,val 1))))

(define define-macro
  (procedure->memoizing-macro
   (lambda (exp env)
     (if (symbol? (cadr exp))
	 `(define ,(cadr exp) (procedure->memoizing-macro
			       (lambda (exp env)
				 (apply ,(caddr exp) (cdr exp)))))
	 `(define ,(caadr exp) (procedure->memoizing-macro
				(lambda (exp env)
				  (apply (lambda ,(cdadr exp)
					   ,(caddr exp))
					 (cdr exp)))))))))
