/*
 *****************************************************************************
 *                                                                           *
 *  UNIVERSITY OF LOWELL Motif/C++ Binding				     *	
 *                                                                           *
 *  COPYRIGHT (c) 1990 BY  UNIVERSITY OF LOWELL, DEPARTMENT OF COMPUTER      *
 *  SCIENCE, LOWELL, MA 01854                                                *
 *                                                                           *
 *  LICENSED MATERIAL - PROGRAM PROPERTY OF UNIVERSITY OF LOWELL. ALL RIGHTS *
 *  RESERVED.                                                                *
 *                                                                           *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    *
 *  ONLY  IN  ACCORDANCE  WITH  THE TERMS OF  SUCH  LICENSE  AND WITH THE    *
 *  INCLUSION OF THE  ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER    *
 *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    *
 *  OTHER PERSON.  NO TITLE TO  OR OWNERSHIP OF  THE  SOFTWARE  IS HEREBY    *
 *  TRANSFERRED.                                                             *
 *                                                                           *
 *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    *
 *  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY UNIVERSITY OF LOWELL    *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * File Name      :                                                          *
 * Author         :                                                          *
 * Created        :                                                          *
 * Description    :                                                          *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 * Edit History   :                                                          *
 * date         who                     what                                 *
 *                                                                           *
 *****************************************************************************
 */
/*
//-----------------------------------------------------------------------------
//
// $Source: /usr/proj/grl/motifplb/design_review_1_efforts/lib_1/XMText.hh,v $
// $Revision: 1.5 $
// $State: Exp $
// $Author: bmontagu $
// $Date: 89/11/27 18:57:28 $
// $Locker:  $
//
// $Log:	XMText.hh,v $
Revision 1.5  89/11/27  18:57:28  bmontagu
test

Revision 1.4  89/11/27  11:56:58  grlcr
1st pass

Revision 1.3  89/11/07  10:33:56  grlcr
*** empty log message ***

Revision 1.2  89/11/03  09:46:35  grlcr
*** empty log message ***

Revision 1.1  89/11/02  12:42:32  motifplb
Initial revision

// ***** Created Oct 11, 1989 by BRM *****
// ***** grlcr : add get routines and remove some set routines *****
//-----------------------------------------------------------------------------
*/

#ifndef XMText_hh
#define XMText_hh

#include "XMPrimitive.hh"
#include <Xm/Text.h>

class XMText : public XMPrimitive {
 protected :
     // ****CONSTRUCTORS**** 
     XMText ();

 public :
     // ****CONSTRUCTORS**** 
     XMText (XMObject*, String,Boolean managed=True);
//     XMText ();   //ScrolledText --> XmCreateScrolledText

     XMText (XMObject* parent, String name,
		   Position x,
		   Position y,
		   Dimension width,
		   Dimension height,
		   short columns,
		   short rows,
		   String value,
		   Boolean resize_width,
		   Boolean resize_height,
		   int edit_mode,
		   Boolean scroll_vertical,
		   Boolean scroll_horizontal,
		   Boolean managed = True);

     // ****DESTRUCTOR****
     ~XMText ();

     // ****METHODS TO SET THE Text RESOURCES****
     void set_autoShowCursorPosition     (Boolean);
     void set_cursorPosition             (XmTextPosition);
     void set_editable                   (Boolean);
     void set_editMode                   (int);
     void set_marginHeight               (short);
     void set_marginWidth                (short);
     void set_maxLength                  (int);
     void set_topPosition                (XmTextPosition);
     void set_value                      (String);
     void set_pendingDelete              (Boolean);
     void set_selectionArray             (XmTextScanType*);
     void set_selectThreshold            (int);
     void set_blinkRate                  (int);
     void set_columns                    (short);
     void set_cursorPositionVisible      (Boolean);
     void set_fontList                   (XMFontList*);
     void set_resizeHeight               (Boolean);
     void set_resizeWidth                (Boolean);
     void set_rows                       (short);
     void set_wordWrap                   (Boolean);
     void set_entry_activateCallback     (XtCallbackProc, caddr_t);
     void set_entry_focusCallback        (XtCallbackProc, caddr_t);
     void set_entry_losingFocusCallback  (XtCallbackProc, caddr_t);
     void set_entry_modifyVerifyCallback (XtCallbackProc, caddr_t);
     void set_entry_motionVerifyCallback (XtCallbackProc, caddr_t);
     void set_entry_valueChangedCallback (XtCallbackProc, caddr_t);

     // ****METHODS TO GET THE Text RESOURCES****
     void get_autoShowCursorPosition (Boolean*);
     void get_cursorPosition         (XmTextPosition*);
     void get_editable               (Boolean*);
     void get_editMode               (int*);
     void get_marginHeight           (short*);
     void get_marginWidth            (short*);
     void get_maxLength              (int*);
     void get_topPosition            (XmTextPosition*);
     void get_value                  (String*);
     void get_pendingDelete          (Boolean*);
     void get_selectionArray         (XmTextScanType*);
     void get_selectThreshold        (int*);
     void get_blinkRate              (int*);
     void get_columns                (short*);
     void get_cursorPositionVisible  (Boolean*);
     void get_fontList               (XMFontList*);
     void get_resizeHeight           (Boolean*);
     void get_resizeWidth            (Boolean*);
     void get_rows                   (short*);
     void get_wordWrap               (Boolean*);

     // ****COVER FUNCTION METHODS**** 
    void    ClearSelection           (Time);     
    Boolean GetEditable              ();         
    int     GetMaxLength             ();         
    char*   GetSelection             ();         
    char*   GetString                ();         
    void    Replace                  (XmTextPosition, XmTextPosition, char*);
    void    SetEditable              (Boolean);  
    void    SetMaxLength             (int);    
    void    SetSelection             (XmTextPosition, XmTextPosition, Time);
    void    SetString                (char*);     
};

#endif     // XMText_hh

// dont add stuff after this endif
