//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created:  MBN 06/06/89 -- Initial implementation
// Modified: LGO 09/19/89 -- Split into one file per method
// Modified: LGO 10/23/89 -- Optimize for 80386
//

#include <cool/Generic.h>

#if defined(DOS)
extern "C" {
#include <string.h>				// for strcmp()
}
#else
#include <string.h>				// for strcmp()
#endif

#include <cool/Base_Hash.h>

// sxhash -- Hash function for char*
// Input:	Character string
// Output:	unsigned long hash value

unsigned long sxhash(const char* string) {
  register unsigned long hash = *string++;
  if(*string != END_OF_STRING) {
    hash = (hash << 7) ^ *string++;
    if (*string != END_OF_STRING) {
      hash = (hash << 7) ^ *string++;
      if (*string != END_OF_STRING) {
	hash = (hash << 7) ^ *string++;
	while (*string != END_OF_STRING) {// rotate hash left 7 bits & xor char
	#ifdef DOS
	  hash = _lrotl(hash, 7) ^ *string++;
	#else
	  long rest = hash >> 25;
	  hash = ((hash << 7) | rest) ^ *string++;
	#endif
	}
      }
    }
  }
  hash &= 0x7fffffffL;				// Make sure bit 32 is zero
  return hash;
}

Boolean charP_compare (const charP& s1, const charP& s2) {
  return !strcmp ((charP)s1, (charP)s2);
}
