//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 06/06/89 -- Initial implementation
// Updated: LGO 09/19/89 -- Split into one file per method
// Updated: MBN 10/12/89 -- Changed "current_position" to "curpos" 

#include <cool/Generic.h>
#include <cool/Base_Hash.h>

// Operator= -- Assignment of one hash table to another duplicating size and
//              contents and returning old storage
// Input:       Reference to hash table object
// Output:      Reference to new hash table object

Hash_Table& Hash_Table::operator= (const Hash_Table& h) {
  this->growth_ratio = h.growth_ratio;		// Grow to next prime number
  this->entry_count = h.entry_count;		// No entries in table
  this->current_bucket = h.current_bucket;	// Index to number of buckets
  long prime = hash_primes[this->current_bucket]; // Get prime number
  delete this->items_in_buckets;		// Return old count storage
  this->items_in_buckets = new unsigned char[prime]; // Counts items in buckets
  for (long i = 0; i < prime; i++) 		// For each bucket count
    this->items_in_buckets[i] = h.items_in_buckets[i]; // Copy item count
  this->curpos = INVALID;			       // Invalidate current position
  return *this;					// Return reference
}

