#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
        Subroutine GigiBx (term, NumTic, DXmax, DXmin, DYmax, DYmin)


***********************************************************
*                                                         *
*    Subroutine Gigi_Box_and_Coordinates                  *
*                                                         *
*       This subroutine is called by 'plot', to draw      *
*       the axes, labels, and tic-marks (or grid) that    *
*       are displayed by the window.                      *
*                                                         *
***********************************************************


        Character *10   hix, hiy, lowx, lowy
        Common /winlbl/ hix, hiy, lowx, lowy
        Save   /winlbl/

        Character *7    crv(3)
        Common /Crvlbl/ crv
        Save   /Crvlbl/ 

        Logical        Gridon
        Integer                GType
        Common /grids/ Gridon, GType
        Save   /grids/

        Character       xaxis*20, yaxis*20, title*60
        Common /Labels/ xaxis, yaxis, title
        Save   /Labels/

        Real    tic
        Integer NumTic(2), DXmax, DXmin, DYmax, DYmin
        Integer intvX, intvY, I, max, min, Gx, Gy, term
        Integer typln(5)

*       (* Set up "typln" for correct terminal *)
        typln(1) = 1
        typln(2) = 4
        typln(3) = 3
        IF (term .EQ. 1) THEN
          typln(4) = 2
          typln(5) = 5
        ELSE IF (term .EQ. 2) THEN
          typln(4) = 8
          typln(5) = 9
        ENDIF

*       (* Draw the viewport box for the window. *)
          Write (*,10) DXmin, DYmin
   10     Format ('P[',i3,',',i3,']')

          Write (*,20) DXmax, DYmin
   20     Format ('V[',i3,',',i3,']')

          Write (*,20) DXmax, DYmax

          Write (*,20) DXmin, DYmax

          Write (*,20) DXmin, DYmin

*       (* Make sure that the user didn't input a (') in there
*          label character strings. If they did, this would have
*          an adverse effect on regis, since it uses this sequence
*          as the end of the text command. *)

*       (* Scan the title. *)
        I = Index(title,'''')
  100   IF (I .NE. 0) THEN
          title(I:I) = '`'
          I = Index(title(I:),'''')
          GOTO 100
        ENDIF

*       (* Scan the yaxis. *)
        I = Index(yaxis,'''')
  200   IF (I .NE. 0) THEN
          yaxis(I:I) = '`'
          I = Index(yaxis(I:),'''')
          GOTO 200
        ENDIF

*       (* Scan the xaxis. *)
        I = Index(xaxis,'''')
  300   IF (I .NE. 0) THEN
          xaxis(I:I) = '`'
          I = Index(xaxis(I:),'''')
          GOTO 300
        ENDIF

*       (* Scan the curve names. *)
        I = Index(crv(1),'''')
  302   IF (I .NE. 0) THEN
          crv(1)(I:I) = '`'
          I = Index(crv(1)(I:),'''')
          GOTO 302
        ENDIF

        I = Index(crv(2),'''')
  304   IF (I .NE. 0) THEN
          crv(2)(I:I) = '`'
          I = Index(crv(2)(I:),'''')
          GOTO 304
        ENDIF

        I = Index(crv(3),'''')
  306   IF (I .NE. 0) THEN
          crv(3)(I:I) = '`'
          I = Index(crv(3)(I:),'''')
          GOTO 306
        ENDIF

*       (* Print the labels and XY axis. *)
          Gx = DXmin +30
          Gy = DYmin -25
          Write (*,30) Gx, Gy, title
   30     Format('P[',i3,',',i3,']T''',a60,'''')

          Gx = (DXmax -DXmin)/3 + DXmin +25
          Gy = DYmax +20
          Write (*,38) Gx, Gy, xaxis
   38     Format('P[',i3,',',i3,']T''',a20,'''')

          Gx = 0
          Gy = (DYmax -DYmin)/2 + DYmin -10
          Write (*,40) Gx, Gy, yaxis(1:10)
   40     Format('P[',i3,',',i3,']T''',a10,'''')
          Gy = Gy +24
          Write (*,40) Gx, Gy, yaxis(11:20)

*       (* TICK MARKS *)
*       (* First, set up correct line type the grid *)
        Write (*,45) typln(GType)
   45   Format ('W(I7P',I1,')')
*
        Write (*,50)
   50   Format ('L''+''08080808FF0808080808')

        tic = (DXmax - DXmin)/(NumTic(1)  +1.0)
        intvX = DXmin 
        max = DYmax -8
        IF (term .EQ. 1) THEN
          min = DYmin -9
        ELSE
          min = DYmin -8
        ENDIF
        DO 400 I = 1, NumTic(1)
*         (*  Draw either the grid or tick marks.  *) 
          If (Gridon) Then
            intvX = intvX + tic 
            Write (*,10) intvX, DYmin
            Write (*,20) intvX, DYmax
          Else
            intvX = intvX + tic -.5
            Write (*,70) intvX, min, intvX, max
   70       Format ('P[',i3,',',i3,']T''+''')
          Endif
  400   CONTINUE

        tic = (DYmax - DYmin)/(NumTic(2) +1.0)
        intvY = DYmin
        max = DXmax -5
        min = DXmin -5
        DO 500 I = 1, NumTic(2)
*         (*  Draw either the grid or tick marks.  *) 
          If (Gridon) Then
            intvY = intvY + tic 
            Write (*,10) DXmin, intvY
            Write (*,20) DXmax, intvY
          Else
            intvY = intvY + tic +.5
            Write (*,70) min, intvY, max, intvY
          Endif
  500   CONTINUE

*       (* Write out the window's max and min points. *)
*         (* Print the minimum X point. *)
          Gx = DXmin -10
          Gy = DYmax +8
          Write (*,90) Gx, Gy, lowx
   90     Format('P[',i3,',',i3,']T''',a10,'''')

*         (* Print the maximum X point. *)
          Gx = DXmax -85
          Write (*,90) Gx, Gy, hix

*         (* Print the minimum Y point. *)
          Gx = DXmin -110
          Gy = DYmax -15
          Write (*,90) Gx, Gy, lowy

*         (* Print the maximum Y point. *)
          Gy = DYmin
          Write (*,90) Gx, Gy, hiy
*
*  NO LONGER PRINTS OUT "LEGEND:"
*
*       (* Place the Curve Legend. *)
*       Write (*,110) 
* 110   Format ('P[0,442] T(S1)''Legend:''')
*
        RETURN
        END
