#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine File (X, Y, Numpt, NumCrv, term)


****************************************************************
*                                                              *
*  Subroutine File_Input_Device                                *
*                                                              *
*     This routine gets the XY points, for the curve.          *
*     The user is prompted for the number of simultaneous      *
*     curves. The routine then asks the user the name of       *
*     the file, opens it, and reads the points into the        *
*     respective X & Y array. The process is repeated for      *
*     the number of curves requested.                          *
*                                                              *
*     If the user has all data for the given curves in the     *
*     same file, control is passed to "filesn".                *
*                                                              *
*     Minor error checking is done by this routine; mainly     *
*     to make sure the user enters a reasonable amount of      *
*     simultaneous curves, and that the data files to be       *
*     opened exist.                                            *
*                                                              *
*     The subroutine also finds the max and min points for     *
*     the X & Y curves. The max and min points are depen-      *
*     dent on the maximum and minimum points of all the        *
*     curves. The window is also initialized to these          *
*     points, which the user has the option of later           *
*     changing.                                                *
*                                                              *
****************************************************************


        Logical         cldrun
        Common /strtup/ cldrun
        Save   /strtup/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Character    ans
        Character*35 files
        Real         X(max,num), Y(max,num), Xtemp, Ytemp
        Integer      NumCrv, Numpt(num), I, IOerr, term


*       (* Find out how curves are to be plotted at once, or
*          how many simultaneous curves are desired. *)
        Call clear(term)
        Write (*,10)
   10   Format (/15x,'File Input',///5x,'Please enter the ',
     +          'number of simultaneous curves ',/5x,
     +          'desired (1 - 3) ...')
        Read (*,'(i5)',err=100) NumCrv

*       (* Make sure a legal amount of curves were selected. *)
  100   IF (NumCrv .LT. 1 .OR. NumCrv .GT. num) THEN
    2     Call clear(term)
          Write (*,'(a1)') Char(7)
          Write (*,10)
          Read (*,'(i5)',err=2) NumCrv
          GOTO 100
        ENDIF
*
*  Does the user have the data stored in separate files or not?
*  (Automatically set the answer to "n" if there is only one
*   curve.)
*
        IF (NumCrv .GT. 1) THEN 
   22     Call clear(term)
          Write (*,20) NumCrv
   20     Format (/15x,'File Input',///5x,'Is the data for these ',
     +            I1,' curves in the same file? (y,n)'/)     

          Read (*,'(a1)',err=22) ans
        ELSE
          ans = 'n'
        ENDIF
        IF ((ans .EQ. 'Y') .OR. (ans .EQ. 'y')) THEN
*
*      It's all stored in the same file.
*
          Call FileSn (X, Y, Numpt, NumCrv, term)
        ELSE

*       (* Get the data for the different curves. *)
          I = 1
  200     IF (I .LE. NumCrv) THEN
    3       Call clear(term)
            Write (*,30) I
   30       Format(/15x,'File Input',///5x,'Please enter the ',
     +                'name of the data file for curve ',i1,' ...')
            Read (*,'(a35)',err=3) files
            IF (files .EQ. ' ') THEN
              Write(*,'(a1)') Char(7)
              GOTO 3
            ENDIF
            Open (unit = 1, file = files, status = 'old',
     +            iostat = IOerr)

*         (* Check to see if the file was successfully opened. *)
            IF (IOerr .NE. 0) THEN
*           (* Disaster!! The file wasn't found. Allow the user to 
*              either quit or retry to enter the filename. *)
    4         Call clear(term)
              Write (*,40) files
   40         Format (/15x,'File Input',///5x,'Sorry, but file: ',
     +                 a,/5x,'wasn''t found.',//
     +               5x,'Do you wish to stop the program? (Y/N) ... ')
              Read (*,'(a1)',err=4) ans
              IF ((ans .EQ. 'Y') .OR. (ans .EQ. 'y')) THEN
                Write (*,50)
   50           Format (//,5x,'Goodbye!',//)
                STOP
              ENDIF
            ELSE
*           (* The file was successfully opened. *)
              Rewind 1

*             (* Get the data points. *)
              Numpt(I) = 0
  400         IF (Numpt(I) .LT. max) THEN
                Read (1,*,err=500,end=600) Xtemp, Ytemp
                Numpt(I) = Numpt(i) +1
                X(Numpt(I), I) = Xtemp
                Y(Numpt(I), I) = Ytemp
                GOTO 400
  500           print *,'error: in input of file ',files
                print *,'       on line ',Numpt(I)
                GOTO 400
              ELSE
                Read (1,*,err=600,end=600) Xtemp, Ytemp
*             (* Convey to the user that the file contains more
*                than the maximum number of allowed points. *)
    5           Call clear(term)
                Write (*,60) files, max
   60           Format (/15x,'File Input',//5x,'Sorry, but file ''',
     +                a,''' has more than'/,
     +                5x,'the maximum ',i5,' points allowed!'//,
     +                5x,'Do you wish to stop the program? (Y/N)... ')
                Read (*,'(a1)',err=5) ans
                IF (ans .EQ. 'Y' .OR. ans .EQ. 'y') THEN
                  Write (*,70)
   70             Format (/15x,'Goodbye!'//)
                  STOP
                ENDIF
              ENDIF

  600         IF (Numpt(I) .LE. 1) THEN
*             (* Convey to the user that the file doesn't contain
*                enough points. They then have the option of 
*                stopping or re-entering a new filename. *)
    6           Call clear(term)
                Write (*,80) files
   80           Format (/15x,'File Input',//5x,'Sorry, but file ''',
     +                 a,''' doesn''t contain'
     +                ,'enough ',/5x,'points!',//5x,'Do you wish',
     +                  ' to stop the program? (Y/N)... ')
                Read (*,'(a1)',err=6) ans
                IF ((ans .EQ. 'Y') .OR. (ans .EQ. 'y')) THEN
                  Write (*,90)
   90             Format (/15x,'Goodbye!')
                  STOP
                ENDIF
              ELSE
*              (* Increment I, the curve indicator, to the next curve. *)
               I = I +1
              ENDIF
            ENDIF

            GOTO 200
          ENDIF
        ENDIF         

*       (* Find the max and min points for the curves. *)
 450    IF (.NOT. cldrun) THEN
          Call Clear (term)
          Write (*,478)
 478      Format(5x,'Do you want the window edges set automatically?',
     +           /5x,'default = (yes)'/)
          Read (*,'(a1)',err=450) ans
        ELSE
          ans = 'y'
        ENDIF

        IF (ans .NE. 'n' .AND. ans .NE. 'N') THEN
          Call MaxMin (X, Y, NumCrv, NumPt)
        ENDIF

        RETURN
        END
