/*****************************************************************************/
/* 				   main.c				     */
/*===========================================================================*/
/* 									     */
/*	main.c	takes care of binding cpp, the parser, and the		     */
/*	execution unit.							     */
/*									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/*****************************************************************************/

#include <stdio.h>
#include <strings.h>

extern	FILE	*yyin ;
extern	char	*mach_names[] ;
extern	int	mach_names_size ;

short int	doframe[1000] ;
void
  main ( argc , argv )
int	argc ;
char	*argv[] ;
{
	register int	loop, argidx ;
	register int	retcode ;
	register char	*end ;
	register int	first,last ;
	int		sequent, cmdlen ;
	char		*xname ;

	cmdlen=strlen(argv[0]) ;
	if( cmdlen>4 ) argv[0] += cmdlen-4 ;
	xname=rindex(argv[0],'/') ;
	if( xname==NULL )
	    xname = argv[0] ;
	else
	    ++xname ;
	sequent = strcmp(xname,"comb")==0 ? 1 : 0 ;
	if( argc>2 ) {
	    /*........... convert arguments into frame booleans .............*/
	    for( loop=0 ; loop<1000 ; loop++ )
		doframe[loop] = 0 ;
	    for( argidx=2 ; argidx<argc ; argidx++ ) {
		first=atoi(argv[argidx]) ;
		end=argv[argidx] ;
		while( *end!='\0' && *end!='-' )
		    end++ ;
		if( *end=='-' ) {
		    end++ ;
		    if( *end=='\0' )
			last=999 ;
		    else
			last = atoi(end) ;
		    for( loop=first ; loop<=last ; loop++ )
			doframe[loop] = 1 ;
		} else
		    doframe[first] = 1 ;
	    }
	} else {
	    /*................. default is use all frames ...................*/
	    for( loop=0 ; loop<999 ; loop++ )
		doframe[loop] = 1 ;
	}
	if( argc<2 ) {
	    fprintf(stderr,"%s: must have one source file argument\n",*argv) ;
	    exit(1) ;
	}
	if( !sequent )
	    init_mach(stdin) ;
	else
	    printf("sequential output going to file a1.remote\n") ;

	if( freopen(argv[1],"r",stdin)==0 ) {
	    fprintf(stderr,"%s: could not open %s\n",argv[0],argv[1]) ;
	    exit(1) ;
	}
	yyin = popen("/lib/cpp","r") ;
	if( yyin==0 ) {
	    fprintf(stderr,"%s: could not open /lib/cpp\n",argv[0]) ;
	    exit(1) ;
	}
	retcode = yyparse() ;
	if( retcode==0 )
	    exec_unit( sequent ) ;
	exit(retcode) ;
}

int
  init_mach ( fp )
FILE	*fp ;
{
	char	buff[256] ;
	int	idx ;

	idx = 0 ;
	while( fgets(buff,256,fp) ) {
	    mach_names[idx] = (char *)malloc(strlen(buff)) ;
	    strcpy(mach_names[idx],buff) ;
	    mach_names[idx][strlen(mach_names[idx])-1] = '\0' ;
	    idx++ ;
	}
	if( idx!=0 )	mach_names_size = idx ;
	printf("Using the following machines:\n") ;
	for( idx=0 ; idx<(mach_names_size-1) ; idx+=2 )
	    printf("%-35s\t%-35s\n",mach_names[idx],mach_names[idx+1]) ;
	if( idx==mach_names_size )
	    printf("\n") ;
	else
	    printf("%-35s\n",mach_names[idx]) ;
}
