/*======================================================================
                    I N T E R S E C T . M 
                    doc: Tue Sep 10 08:56:31 1991
                    dlm: Wed Nov 20 14:49:44 1991
                    (c) 1991 A.M.J. Thurnherr
                    uE-Info: 136 16 FALSE 0 0 72 2 2 ofnI
======================================================================*/

/* MPL */
#include	<stdio.h>
#include	<mpl.h>
#include	"types.h"
#include	"world.h"
#include	"utilities.h"

#define 	UVEPS		1e-6

Bool rayBoxP(r,b,min,max)				/* intersect Ray with BBox */
Ray r; Box b; Fp min,max;
{
	Fp	t1,t2,tnear,tfar,tmp;
	
	tnear = -INF; tfar = INF;
	
	if (r.dir[VX] == 0.0) {				/* parallel */
		if ((r.ori[VX] < b.min[VX]) ||
		    (r.ori[VX] > b.max[VX]))
		    	return FALSE;
	} else {
		tnear = (b.min[VX] - r.ori[VX]) / r.dir[VX];
		tfar  = (b.max[VX] - r.ori[VX]) / r.dir[VX];
		if (tnear > tfar) Swap(tnear,tfar,tmp); 
		if (tfar < 0) return FALSE;
	}
	if (r.dir[VY] == 0.0) {				/* parallel */
		if ((r.ori[VY] < b.min[VY]) ||
		    (r.ori[VY] > b.max[VY]))
		    	return FALSE;
	} else {
		t1 = (b.min[VY] - r.ori[VY]) / r.dir[VY];
		t2 = (b.max[VY] - r.ori[VY]) / r.dir[VY];
		if (t1 > t2) Swap(t1,t2,tmp); 
		if (t1 > tnear) tnear = t1;
		if (t2 < tfar)  tfar = t2;
		if ((tnear > tfar) || (tfar < 0)) return FALSE;
	}
	if (r.dir[VZ] == 0.0) {				/* parallel */
		if ((r.ori[VZ] < b.min[VZ]) ||
		    (r.ori[VZ] > b.max[VZ]))
		    	return FALSE;
	} else {
		t1 = (b.min[VZ] - r.ori[VZ]) / r.dir[VZ];
		t2 = (b.max[VZ] - r.ori[VZ]) / r.dir[VZ];
		if (t1 > t2) Swap(t1,t2,tmp); 
		if (t1 > tnear) tnear = t1;
		if (t2 < tfar)  tfar = t2;
		if ((tnear > tfar) || (tfar < 0)) return FALSE;
	}
	return TRUE;
}

PIsect * plural rayTri(r,t,min,max)			/* intersect Ray with Triangle */
Ray r; plural Tri *t; Fp min,max;
{
    plural  Fp     newDist,v0,vd = vec3Vec3(t->planeN,r.dir);
    static 	PIsect result;
	   
    if (pWorld.triSet > 0) {
	if (world.oriSurf && (vd >= 0)) return NULL;	/* Facing away */

	v0 = -vec3Vec3(t->planeN,r.ori)-t->planeD;
	result.dist = v0/vd;				/* distance from origin */
	if ((result.dist < min) || (result.dist > max))	/* out of raybounds */
		return NULL;
	setPpnt3(result.pnt,r.ori[VX]+result.dist*r.dir[VX],	/* Intersection pnt */
			   r.ori[VY]+result.dist*r.dir[VY],
			   r.ori[VZ]+result.dist*r.dir[VZ]);/* Calc u,v */

	if (!t->bounded) {				/* Plane */
		result.v = 0;
		result.u = 0;
		result.tri = t;
		printf("UNBOUNDED INTERSECTION\n");
		return &result;
	}
	
	result.v = (result.pnt[t->projC2]-t->v[PA][t->projC2]-
			t->ABydivABx*(result.pnt[t->projC1]-t->v[PA][t->projC1])) /
		 (t->ACy - t->ABydivABx*t->ACx);
	if (result.v < -UVEPS) return NULL;
	result.u = (result.pnt[t->projC1]-t->v[PA][t->projC1]-result.v*t->ACx) / t->ABx;
	if (result.u < -UVEPS) return NULL;
	if (result.u+result.v > 1.0+UVEPS) return NULL;
	result.tri = t;
	return &result;
    }
}

plural Bool sRayTriP(r,t,min,max)			/* intersect ShadowRay with Triangle */
Ray r; plural Tri *t; Fp min,max;
{
    plural Fp 	newDist,v0,vd = vec3Vec3(t->planeN,r.dir);
    PIsect 		result;
	   
    if (pWorld.triSet > 0) {
	if (world.oriSurf && (vd < 0)) return NULL;	/* Facing towards it */

	v0 = -vec3Vec3(t->planeN,r.ori)-t->planeD;
	result.dist = v0/vd;				/* distance from origin */
	if ((result.dist < min) || (result.dist > max)) /* out of raybounds */
		return FALSE;
	setPpnt3(result.pnt,r.ori[VX]+result.dist*r.dir[VX],	/* Intersection pnt */
			   r.ori[VY]+result.dist*r.dir[VY],
			   r.ori[VZ]+result.dist*r.dir[VZ]);/* Calc u,v */

	if (!t->bounded) {				/* Plane */
		printf("UNBOUNDED INTERSECTION\n");
		return TRUE;
	}
	
	result.v = (result.pnt[t->projC2]-t->v[PA][t->projC2]-
			t->ABydivABx*(result.pnt[t->projC1]-t->v[PA][t->projC1])) /
		   (t->ACy - t->ABydivABx*t->ACx);
	if (result.v < -UVEPS) return FALSE;
	result.u = (result.pnt[t->projC1]-t->v[PA][t->projC1]-result.v*t->ACx) / t->ABx;
	if (result.u < -UVEPS) return FALSE;
	if (result.u+result.v > 1.0+UVEPS) return FALSE;
	return TRUE;
    }
}

#define	IPOLuv(na,du,dv,dim) 				/* Interpolate */\
	(na[dim]+pis->u*du[dim]+pis->v*dv[dim])
	
void calcNorm(pis,is)					/* Calc Norm of Isect */
PIsect * plural pis; Isect *is;
{
	Fp 	dummy;
	if (world.flatShade) {
		copyVec3(pis->tri->planeN,is->nrm);
	} else {
		is->nrm[VX] = IPOLuv(pis->tri->n[PA],pis->tri->dNu,pis->tri->dNv,VX);
		is->nrm[VY] = IPOLuv(pis->tri->n[PA],pis->tri->dNu,pis->tri->dNv,VY);
		is->nrm[VZ] = IPOLuv(pis->tri->n[PA],pis->tri->dNu,pis->tri->dNv,VZ);
	}
	nrmVec3(is->nrm,dummy);
}

Isect *rayWorld(r,min,max)				/* intersect ray with world */
Ray r; Fp min,max;
{
	PIsect 	* plural is;
	static Isect res;
	Bool	found = FALSE;

    	is = rayTri(r,&pWorld.t,min,max);
    	if (is != NULL) {
    		found = TRUE;
    		if (is->dist == reduceMind(is->dist)) {
			copyVec3(is->pnt,res.pnt);
			copyVec3(is->tri->planeN,res.planeN);
			res.matId = is->tri->matId;
    			calcNorm(is,&res);
    		}
    	}
	if (found) return &res;
	else       return NULL;
}
	
Bool rayWorldP(r,min,max)				/* intersect ray with world */
Ray r; Fp min,max;					/* for shadow purposes */
{
	return reduceOr8(sRayTriP(r,&pWorld.t,min,max));
}
