/*
 * plane.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: plane.c,v 3.0.1.2 90/04/04 19:02:42 craig Exp $
 *
 * $Log:	plane.c,v $
 * Revision 3.0.1.2  90/04/04  19:02:42  craig
 * patch5: Test for edge-on intersection more robust.
 * 
 * Revision 3.0.1.1  89/12/06  16:34:03  craig
 * patch2: Added calls to new error/warning routines.
 * 
 * Revision 3.0  89/10/27  02:05:59  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#include "constants.h"
#include "typedefs.h"
#include "funcdefs.h"

/*
 * create plane Primitive
 */
Object *
makplane(surf, norm, pos)
char *surf;
Vector *norm, *pos;
{
	Plane	*plane;
	Vector tmpnrm;
	Object *newobj;
	Primitive *prim;

	tmpnrm = *norm;
	if (normalize(&tmpnrm) == 0.) {
		yywarning("Degenerate plane normal.");
		return (Object *)0;
	}
	prim = mallocprim();
	prim->surf = find_surface(surf);
	prim->type = PLANE;
	newobj = new_object(NULL, PLANE, (char *)prim, (Trans *)NULL);
	plane = (Plane *)Malloc(sizeof(Plane));
	prim->objpnt.p_plane = plane;
	plane->norm = tmpnrm;
	plane->d = dotp(&plane->norm, pos);

	return newobj;
}

double
intplane(pos, ray, obj)
Vector *pos;
Vector *ray;
Primitive *obj;
{
	Plane *plane;
	double denom, dist;
	extern unsigned long primtests[];

	primtests[PLANE]++;
	plane = obj->objpnt.p_plane;

	denom = dotp(&plane->norm, ray);
	if (equal(denom, 0.))
		return 0.;
	dist = (plane->d - dotp(&plane->norm, pos)) / denom;
	return (dist > FAR_AWAY ? 0. : dist);
}

/*ARGSUSED*/
nrmplane(pos, obj, nrm)
Vector *pos, *nrm;
Primitive *obj;
{
	*nrm = obj->objpnt.p_plane->norm;
}

/*ARGSUSED*/
planeextent(o, bounds)
Primitive *o;
double bounds[2][3];
{
	/*
	 * Planes are unbounded by nature.  minx > maxx signifies
	 * this.
	 */
	bounds[LOW][X] = 1.0;
	bounds[HIGH][X] = -1.0;
}
