'\"et
.if t .TH IMSPLIT 1IM "October 13, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMSPLIT 1IM "October 13, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imsplit  -  Splits a multi-image file into separate files
.SH SYNOPSIS
\fBimsplit\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimsplit\fR reads in the multi-image input file and splits its contents
into multiple single-image output files.
The input and output image file formats may be different.
.SH OPTIONS
\fBimsplit\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.LP
.SS "Output File Names"
Output file names are generated automatically based upon a given
output file name template.  The file name template must
include the special character code "\fB%d\fR",
like the C language \fBprintf\fR(3)
print format directive.  This template will be used to generate a
series of output image file names by replacing the "\fB%d\fR" with integer
frame numbers, one after another.  The template \fBmyimage.%d.rgb\fR,
for instance, could generate the file names \fBmyimage.0.rgb\fR,
\fBmyimage.1.rgb\fR, \fBmyimage.2.rgb\fR, and so on.
.LP
By default, all images in the input file are split out and written to
separate image files.  File name frame numbers will range from 0 (for the
first image) to \fIn-1\fR (for the last image), where \fIn\fR
is the number of images in the input file.
.LP
The \fB-frames \fIlist...\fR option may be given one or more times
to explicitly list the
input file frames that are to be extracted.  The \fB-frames\fR option
takes a list of one or more \fIranges\fR, each of which is a single value,
or a range of values taking one of the following forms:
.RS 0.5i
.LP
.TS
l l.
\fIrange\fR	\fBExtract Frames\fR
_
\fIn\fR	\fIn\fR only.
\fIn-\fR	\fIn\fR through the end of the input file.
\fIn-m\fR	\fIn\fR through \fIm\fR.
.TE
.RE
.LP
There is no space between \fIn\fR, the dash, and \fIm\fR.  \fIn\fR need not
be a value less than \fIm\fR.
.LP
Frame numbers listed in \fB-frames\fR options will be the same as those
used for generating output file names.
.LP
The following are typical invocations of \fBimsplit\fR using \fB-frames\fR
lists:
.RS 0.5i
.LP
.nf
\fBimsplit many.hdf -frames 0 1 2 image.%d.tiff\fR
\fBimsplit many.hdf -frames 0-5 6 7 9-12 image.%d.rgb\fR
\fBimsplit many.hdf -frames 9-12 6 0-3 image.%02d.ras\fR
\fBimsplit many.hdf -frame 0 -frame 1 -frame 32 -frame 8-10 5 image.%d.gif\fR
.fi
.RE
.LP
.SH NOTES
All of the output files will be written using the same image file format.
This need not be the same as the file format used by the input file.
.LP
Multi-image files handled by \fBimsplit\fR may be created using
\fBimcat\fR(1IM).
.LP
Most image file formats cannot support the storage of multiple images in the
same file.  This is a limitation of the file format design, not \fBimsplit\fR.
.LP
\fBimsplit\fR uses the C language \fBsprintf\fR(3) routine to replace
the file name template's "\fB%d\fP" with image frame numbers.  The
use of \fBsprintf\fR(3) means the full range of "\fB%d\fP" format 
directive syntax is available in generating output file names.  
While the \fBsprintf\fR(3) \fBman\fR page has full details on the 
"\fB%d\fP" print directive, the following is a summary as it 
applies to output file naming:
.RS 0.5i
.LP
The "%d" directive has the following general syntax:
.RS 0.5i
.LP
 "\fB%\fR" [\fIflags\fR] [\fIdigit\fR] ["\fB.\fR" \fIprecision\fR] "\fBd\fR"
.RE
.LP
The directive always starts with a "\fB%\fR" character and ends with a "\fBd\fR"
character.
Field names between the [ ]s in the syntax above are optional.  With no
optional field value, the simplest form of the directive is just "\fB%d\fR".
.IP \fIflags\fR
Following the "\fB%\fR" is an optional set of \fIflags\fR characters:
.RS 0.5i
.RS 0.5i
.LP
.TS
l l.
\fIflag\fR	\fBMeaning\fR
_
\fB-\fR	Left-justify the frame number.  Default is right justified.
\fB+\fR	Begin with the sign (+ or -) of the frame number.  Default is just -.
\fB(blank)\fR	Use a blank instead of a + for positive frame numbers.
.TE
.RE
.LP
Except for peculiar file naming, users of \fBimsplit\fR can omit the optional
\fIflags\fR portion of a print directive.
.RE
.IP \fIdigit\fR
Following the \fIflags\fR is an optional \fIdigit\fR field that gives the
field width of the number, in characters.  If the number requires fewer
than this minimum, it will be padded on the right or left with blanks
(padding is controlled by the \fB-\fR \fIflag\fR mentioned above).  
If the number requires more than this minimum, it will be taken. 
.RS 0.5i
.LP
The \fIdigit\fR field can be preceded by a 0 (zero) to cause padding to
be done with leading zeros instead of blanks.  This is useful
when referring to frame numbers of the form "001," "002," "003," and so on.
.RE
.IP \fIprecision\fR
The \fIdigit\fR field may be optionally followed by a "\fB.\fR" (period)
and a \fIprecision\fR number that gives the minimum number of digits for
the frame number.  This isn't particularly useful for users of \fBimsplit\fR
and can be skipped.
.LP
The following are a few typical "\fB%d\fR" directives for use in \fBimsplit\fR:
.RS 0.5i
.IP "\fB%d\fR"
No leading zeros or blanks.  Generates numbers like "0," "1," "2," "3," etc.
.IP "\fB%03d\fR"
Leading zeros to fill 3 characters, including the number.  Generates
numbers like "000," "001," "002," "003," etc.
.IP "\fB%.3d\fR"
Same effect as "\fB%03d\fR".
.RE
.RE
.LP
In order to split apart multi-image files, \fBimsplit\fR must first read
in the entire file's image data.  This can take up quite a bit of memory,
as well as take a long time.  If the host does not have enough memory and
swap space, \fBimsplit\fR will fail with a memory allocation error.
.LP
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page for \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
Extract all the images in a multi-image HDF file and save them as Sun
raster files:
.RS 0.5i
.LP
\fBimsplit many.hdf single%02d.ras\fR
.RE
.LP
Extract the images 0, 1, 2, 3, and 18 from a multi-image TIFF file:
.RS 0.5i
.LP
\fBimsplit movie.tiff -frames 0-3 18 image.%02d.tiff\fR
.RE
.LP
.SH "SEE ALSO"
\fBimcat\fR (1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH AUTHORS
Chris Groening and Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im," followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
