'\"t
.if t .TH IMVFBRESIZE 3IM "September 24, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMVFBRESIZE 3IM "September 24, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
ImVfbResize - Change the resolution of a virtual frame buffer
.SH SYNOPSIS
\fB
.nf
#include "im.h"

ImVfb *ImVfbResize( srcVfb, algorithm, dstVfb, width, height )
	ImVfb *srcVfb ;
	int algorithm ;
	ImVfb *dstVfb ;
	int width, height ;
.fi
\fR
.SH DESCRIPTION
\fBImVfbResize\fR changes the resolution of a virtual frame buffer
and returns a pointer to the resized destination Vfb.
.LP
\fIsrcVfb\fR is the Vfb to be copied and resized.  \fIsrcVfb\fR
is unaltered by the operation.
.LP
\fIwidth\fR and \fIheight\fR are the dimensions of the destination
resized Vfb.
.LP
\fIalgorithm\fR is what algorithm to use to change the resolution.
Legal values of \fIalgorithm\fR are:
.LP
.if t .in +0.5i
.if n .in +5
.ne 1i
.TS
c c
l l.
Value	Meaning
_
\fBIMVFBBILINEAR\fR	Perform bilinear interpolation
\fBIMVFBPIXELREP\fR	Perform pixel replication
.TE
.if t .in -0.5i
.if n .in -5
.LP
\fIdstVfb\fR is the Vfb to contain the resized image.  If \fIdstVfb\fR is
the constant \fBIMVFBNEW\fR, a new Vfb is allocated as \fIwidth x height\fR
pixels with the same fields as the \fIsrcVfb\fR.  The new Vfb is returned.
.LP
If \fIdstVfb\fR is not \fBIMVFBNEW\fR, it must be \fIwidth x height\fR
in size and have the same fields as \fIsrcVfb\fR. 
.SH NOTES
The new Vfb contains the same picture as did the original,
but it is represented with more or fewer pixels than the original.
.SH RETURNS
Upon success, \fBImVfbResize\fR returns a pointer to the destination Vfb.
Upon failure, \fBIMVFBNULL\fR is returned, and \fBImErrNo\fR set
to one of the following:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory for the new Vfb
IMEBADALGORITHM	A legal algorithm was not specified
.TE
.if t .in -0.5i
.if n .in -5
.SH SEE ALSO
\fBImVfbFlip\fR (3IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br

