'\"t
.if t .TH IMVFBQCLT 3IM "September 24, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY" 
.if n .TH IMVFBQCLT 3IM "September 24, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
ImVfbQClt - Query the CLT (color lookup table) that is attached to a virtual frame buffer
.br
ImVfbSClt - Set the CLT attached to a virtual frame buffer
.SH SYNOPSIS
\fB
.nf
#include "im.h"

ImClt *ImVfbQClt( srcVfb )
	ImVfb *srcVfb ;

void ImVfbSClt( srcVfb, clt )
	ImVfb *srcVfb ;
	ImClt *clt ;
.fi
\fR
.SH DESCRIPTION
\fBImVfbSClt\fR attaches the color lookup table \fIclt\fR to the
virtual frame buffer \fIsrcVfb\fR.  Thereafter, color index information
in the virtual frame buffer is looked up in \fIclt\fR to obtain RGB
color triplets.
.LP
\fBImVfbQClt\fR returns a pointer to the color lookup table 
attached to the \fIsrcVfb\fR.  A return value of \fBIMCLTNULL\fR indicates
the Vfb currently has no color lookup table.
.SH NOTES
Setting a Vfb's CLT to \fBIMCLTNULL\fR unattaches any CLT from the Vfb.
.LP
Both \fBImVfbSClt\fR and \fBImVfbQClt\fR are macros.
.SH RETURNS
\fBImVfbQClt\fR returns the \fIsrcVfb\fR's CLT.
.LP
\fBImVfbSClt\fR returns nothing.
.SH SEE ALSO
\fBImCltAlloc\fR (3IM)
.SH AUTHOR
Mike Bailey
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br

