'\"et
.if t .TH IMTIFF 3IM "September 24, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY" 
.if n .TH IMTIFF 3IM "September 24, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imtiff \- SDSC TIFF (Tagged Image File Format) translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "tiff", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "tiff", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "tiff", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "tiff", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBtiff\fR is a generic Tagged Image File Format
developed by Aldus and Microsoft in conjunction 
with leading scanner and printer manufacturers.
\fBtiff\fR files may contain images and 
miscellaneous other image-related items.
Such files may be created and manipulated by a variety of 
Tagged Image File Format tools.  See the Tagged Image File Format
documentation for details on how to use these tools.
.LP
\fBtiff\fR support within the SDSC image library is limited to images 
of certain depths and storage methods.
.SH "FILE RECOGNITION"
\fBtiff\fR files are recognized by the following filename
suffixes: .tiff and .tif.
.SH NOTES
SDSC image library support of the \fBtiff\fR format adheres to \fBtiff\fR
Specification 5.0 and \fBtiff\fR Software Release 2.3.  In particular 
\fBtiff\fR Classes B, G, P, R, are all supported for read and write with
the following exceptions:
.RS
.LP
\fBtiff\fP directories that are written do not include NewSubfileType
tags.  NewSubfileType indicates how one image within a \fBtiff\fP file is
related to other images in the file.
.LP
\fBtiff\fP directories that are written do not include ResolutionUnit
tags.  ResolutionUnit indicates whether the unit of pixel measure is
\fBnone, inch, \fPor \fBcentimeter\fP.
.LP
\fBtiff\fP R image files that are written do not include the new 5.0
colorimetric information tags. 
.RE
.LP
Tags not recognized on reading are ignored unless the calling
program has requested verbosity.
.LP
SDSC image library support of the \fBtiff\fR format does not require
use of the Tagged Image File Format's \fBtiff\fR library 
\fBlibtiff.a\fR and contains no proprietary code.
\fBtiff\fR format handling
is available on any machine for which the SDSC image library is
available.
.SS "Reading TIFF image files"
The SDSC image library can read \fBtiff\fR image files with one or more
images and map them to VFBs as follows:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
\fBDepth/color	Types of compression	Mapped to VFB\fR	
1-bit monochrome	Uncompressed, LZW,	IMVFBMONO
	Mac PackBits

4-bit color index	Uncompressed, LZW,	IMVFBINDEX8
	Mac PackBits

8-bit color index	Uncompressed, LZW,	IMVFBINDEX8
	Mac PackBits

16-bit color index	Uncompressed, LZW,	IMVFBINDEX16
	Mac PackBits
	
24-bit RGB	Uncompressed, LZW,	IMVFBRGB
	Mac PackBits

32-bit RGB+Alpha	Uncompressed, LZW,	(IMVFBRGB | IMVFBALPHA) 
	Mac PackBits
.TE
.if t .in -0.5i
.if n .in -5
.LP
8-bit and 16-bit images may have associated color lookup tables.
.LP
RGB images may be scanline-interlaced or plane-interlaced.
(In \fBtiff\fR terminology, this is called
"contiguous" or "separate" planar configuration.)
.LP
Lempel-Ziv Welch compression (LZW) and Macintosh PackBit compression
schemes are supported.
CCITT, NEXT, THUNDERSCAN, SGIRLE, and PICIO image compression
are \fInot\fR supported.
.LP
\fBtiff\fR files may be in 
MBF (most-significant byte first) 
or LBF (least-significant byte first) byte order.
\fINote:\fR  \fBtiff\fR documentation refers to MBF as 
\fBTIFF_BIGENDIAN\fR and LBF as \fBTIFF_LITTLEENDIAN\fR.
\fBTIFF_VERSION\fR is 42.  
.LP
Bottom right and top right image orientations are not supported.
.LP
If the file's image has a color map, the image library VFB includes
a color lookup table.
.LP
Note that 24-bit and 32-bit color indexes are truncated to the lower 16 bits
when the file is stored as an \fBIMVFBINDEX16\fR VFB.
.SS "Writing TIFF image files"
Images to be written out are mapped from image library VFBs as follows:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
\fBMapped from VFB	Depth/color	Types of compression\fR
IMVFBMONO	1-bit color index	Uncompressed, LZW,
		Mac PackBits
IMVFBINDEX8	8-bit color index	Uncompressed, LZW,
		Mac PackBits
IMVFBINDEX16	16-bit color index	Uncompressed, LZW,
		Mac PackBits
IMVFBRGB	24-bit RGB	Uncompressed, LZW,
		Mac PackBits
(IMVFBRGB|IMVFBALPHA)	32-bit RGB+Alpha	Uncompressed, LZW,
		Mac PackBits
.TE
.if t .in -0.5i
.if n .in -5
.LP
If the incoming VFB has a color lookup table, the image written to the
\fBtiff\fR file contains one.
.LP
RGB images may be stored in scanline-interlaced and plane-interlaced
modes.  The \fBtiff\fP format does not supprt noninterlaced RGB image
storage.
.LP
Other image library VFB types are converted to one of the above types prior
to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP page for
details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
\fBtiff\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMECONFLICT	Conflicting information in image header
IMEDEPTH	Unknown image depth
IMEHEIGHT	Zero or negative image height
IMEMAGIC	Bad magic number in image file
IMEMALLOC	Cannot allocate enough memory
IMEORIENTATION	Unsupported image orientation
IMEOUTOFRANGE	Header value out of legal range
IMEPLANES	Unknown image plane configuration
IMESYNTAX	Syntax error in \fBtiff\fR file
IMESYS	System call error in read operation
IMEUNSUPPORTED	Unsupported VFB type
IMEVERSION	Bad version number
IMEWIDTH	Zero or negative image width
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
\fBtiff\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fITag Image File Format Rev 5.0\fR,
August 8, 1988,
Tim Davenport, Aldus Corporation, 
and Manny Vellon, Microsoft Corporation.
.sp
See also the \fBman\fP pages with the \fBtiff\fR standard distribution.
.SH SEE ALSO
\fBimconv\fR(1IM), \fBimfile\fR(1IM), \fBimformats\fR(1IM)
.SH AUTHOR
T. Todd Elvins
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
