'\"et
.if t .TH IMCOPY 1IM "September 25, 1991" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMCOPY 1IM "September 25, 1991" "SDSC" "IMAGE TOOLS"
.SH NAME
imcopy  -  Copy a portion of an image to a new file
.SH SYNOPSIS
\fBimcopy\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimcopy\fR copies a portion of an input image to a new file.  If the
input file contains multiple images, a portion of each input image is
copied and written to the output file.
The input and output image file formats may be different.
.SH OPTIONS
\fBimcopy\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
Manipulation	How the image can be manipulated
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.LP
.SS "Manipulation Options"
The region of the input image to be copied to a new file is defined
by four arguments:
.LP
.RS +0.5i
.TS
l l.
\fB-xposition\fI x\fR	Left edge of region
\fB-yposition\fI y\fR	Top edge of region
\fB-xsize\fI w\fR	Width of region
\fB-ysize\fI h\fR	Height of region
.TE
.RE
.LP
\fB-xposition\fR and \fB-yposition\fR specify the copy region position and
are constrained to be within the bounds of the input
image.  (0,0) is the upper left corner of the image.  If these options
are not given, the copy region position defaults to a position that
centers  the region within the input image.
.LP
\fB-xsize\fR and \fB-ysize\fR give the size of the copy region and are
constrained to fit within the bounds of the input
image.  If these options are not given, the copy region defaults to a
rectangle whose upper
left corner is at the given copy region position, and which extends to
the right and bottom edges of the input image.
.SH NOTES
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
To copy from an Alias PIX file
a 100x100 pixel region whose upper left corner is at (10,20) and
store it to a Wavefront RLA file, use the following:
.RS 0.5i
.LP
\fBimcopy picture.pix -xpos 10 -ypos 20 -xsize 100 -ysize 100 clipart.rla\fR
.RE
.LP
To copy a 500x500 pixel region from the center of an HDF file and write it
to a TIFF file, use the following:
.RS 0.5i
.LP
\fBimcopy picture.hdf -xsize 500 -ysize 500 newpic.tiff\fR
.RE
.LP
To copy the top 20 scanlines from an XWD file and store it to a new XWD file,
use the following:
.RS 0.5i
.LP
\fBimcopy window.xwd -ypos 0 -ysize 20 border.xwd\fR
.RE
.LP
To copy an entire input GIF image to a PCX file, use the following:
.RS 0.5i
.LP
\fBimcopy incoming.gif outgoing.pcx\fR
.RE
.LP
With no copy region specified, the actions of \fBimcopy\fR default to the
same as the SDSC image format conversion tool \fBimconv\fR(1IM), but they
take a little longer.
.SH "SEE ALSO"
\fBimconv\fR(1IM), \fBimfile\fR(1IM), \fBimflip\fR(1IM),
\fBimformats\fR(1IM), \fBimgray\fR(1IM),
\fBimmono\fR(1IM), \fBimpaste\fR(1IM), \fBimscale\fR(1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimeps\fR(3IM),
\fBimgif\fR(3IM),
\fBimhdf\fR(3IM),
\fBimicon\fR(3IM),
\fBimiff\fR(3IM),
\fBimmpnt\fR(3IM),
\fBimpbm\fR(3IM),
\fBimpcx\fR(3IM),
\fBimpgm\fR(3IM),
\fBimpic\fR(3IM),
\fBimpict\fR(3IM),
\fBimpix\fR(3IM),
\fBimpnm\fR(3IM),
\fBimppm\fR(3IM),
\fBimps\fR(3IM),
\fBimras\fR(3IM),
\fBimrgb\fR(3IM),
\fBimrla\fR(3IM),
\fBimrle\fR(3IM),
\fBimrpbm\fR(3IM),
\fBimrpgm\fR(3IM),
\fBimrpnm\fR(3IM),
\fBimrppm\fR(3IM),
\fBimsynu\fR(3IM),
\fBimtiff\fR(3IM),
\fBimx\fR(3IM),
\fBimxbm\fR(3IM),
\fBimxwd\fR(3IM).
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
