/*
** Copyright 1989, 1993 by Matthias Boldt, Joerge Boenigk
**			   and several students at the 
**			   Institute for Computergraphics
**			   University Rostock (Germany)
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#define boolean		unsigned int
#define true		1
#define false		0


#include  <stdio.h>
#include  <stdlib.h>
#include  <math.h>
#include  <X11/Xlib.h>
#include  <X11/Xutil.h>

#define EV_MASK         KeyPressMask|ButtonReleaseMask|ExposureMask|ButtonPressMask

static char		*displaystring;
static Display		*display;
static Visual		*visual;
static int		theScreen, depth;
static Colormap		cmap,def_cmap;
static Window		winder, rootw;
static GC		theGC;
static Pixmap		pm;
static XImage		*ximage;
static unsigned int	xdim,ydim;
static XEvent		event;
static XVisualInfo     	visualinfo;
static XColor		color_x[256];  
   


typedef struct Color
{
  long r,g,b;
} Color ;

int oldvmode;
char *filename;
unsigned short rgb_tab[256][3];
boolean comments,Filter;
char *mem,*data;

/* octree types */
/*=============================== */

struct  strucTree
{
   int             	leaf;         /* Kennzeichnung Blatt */
   Color           	RGB;          /* Farbe */
   unsigned long    	color_count;  /* Anzahl einsortierter Farben */
   unsigned int    	color_index;  /* Index Farbtabelle   */
   struct strucTree     *next[8];     /* Zeiger fuer 8 Unterbaeume */
   unsigned int    	level;        /* Stufe im Baum */
   struct strucTree     *nextnode;    /* naechster Baum in derselben Stufe */
};

typedef struct strucTree *octree;

/* octree routines */
/*=================================*/
unsigned short init_color_table(octree,unsigned short);
unsigned short find_index(octree,Color);
octree         insert_in_tree(octree,Color,unsigned short);
void           reduce_tree(void);
octree         ini_octree(octree,unsigned short,unsigned short);

/* octree variables  */
/*===================================*/
unsigned short  maxdepth=8;
unsigned short  index_count=255;
octree		reduce_list[9];
octree		Tree;
octree	        foundleaf;
Color	        oldf;
unsigned short	OctreeDepth, size, sizemax;

/*============================================================*/
unsigned short init_color_table(octree Tree,unsigned short index)
/* Faellt die Farbtabelle mit den Mittelwerten der Farben, die durch
   die Blaetter des Octree repraesentiert werden */
{
short		i;

  if (Tree!=NULL)
    if (Tree->leaf==1)
    {
      rgb_tab[index][0] =(unsigned short) (Tree->RGB.r / Tree->color_count);
      rgb_tab[index][1] =(unsigned short) (Tree->RGB.g / Tree->color_count);
      rgb_tab[index][2] =(unsigned short) (Tree->RGB.b / Tree->color_count);
      Tree->color_index =index;
      index++;
    }
    else
      for (i=0; i<8; i++)
	if(Tree->next[i]!=NULL)
	  index=init_color_table(Tree->next[i],index);
  return(index);
} /* init_color_table*/
/*============================================================*/

unsigned short find_index(octree baum,Color farb)
/* Die aktuelle RGB-Kombination farb wird in den vorher aufgebauten
   Octree einsortiert. Der entsprechende Index in der ebenfalls schon
   belegten Farbtabelle wird ans rufende Programm Uebergeben. */
{
short		hilf;
static unsigned long	B[8]={ 128, 64, 32, 16, 8, 4, 2, 1 };
static unsigned long	S[8]={ 7, 6, 5, 4, 3, 2, 1, 0 };

if (baum == NULL)
  {
    printf(" Aarrrgh! An error occured!\n");
    return(0);
  };
	if((baum->leaf)==1)
	  return(baum->color_index);
	else
	{
	  hilf=(short)
               ((long)(((farb.r&B[baum->level]) << 2)+
		((farb.g&B[baum->level]) << 1)+
		 (farb.b&B[baum->level])) >> S[baum->level]);
	  return(find_index(baum->next[hilf],farb));
	}
} /* find_index*/

/*================================================================*/
/* Einsortieren der Farbe f in den Unterbaum Tree der Tiefe Depth */

octree insert_in_tree(octree Tree,Color f,unsigned short Depth)

{
short	 	hilf,i;
static unsigned short	B[8]={ 128, 64, 32, 16, 8, 4, 2, 1 };
static unsigned short	S[8]={ 7, 6, 5, 4, 3, 2, 1, 0 };

     /* falls gleiche Farbe, dann nur Aufsummieren der Werte in das vorher be-
        stimmte Blatt (foundleaf) */
     if ((oldf.r==f.r) && (oldf.g==f.g) && (oldf.b==f.b)
	  && (foundleaf!=NULL) )
     {
       foundleaf->color_count++;
       foundleaf->RGB.r += f.r;
       foundleaf->RGB.g += f.g;
       foundleaf->RGB.b += f.b;
     }
     else
     {
       if (Tree==NULL)		/* Falls Baum leer, erzeuge neuen */
       {
	 if((Tree = malloc(sizeof(struct strucTree)))!=NULL)
         {
	   for(i=0; i<8; i++)
	     Tree->next[i]=NULL;
	   Tree->level = Depth;
	   if( Depth == OctreeDepth )
	   {
	     size++;        /* neues Blatt */
	     Tree->leaf=1;
	     Tree->color_count=0;
	     Tree->RGB.r=0;
	     Tree->RGB.g=0;
	     Tree->RGB.b=0;
	   }
	   else
	   {                /* verketten Knoten */
	     Tree->leaf = 0;
	     Tree->nextnode = reduce_list[Tree->level];
	     reduce_list[Tree->level] = Tree;
	   }
         } /* if malloc */
         else printf("\nmore memory needed!!!!");
       }	/* Klammern von else und if(Tree==NULL) */
       if (Tree->leaf==1)
       {
         /* Farbe einsortieren in das neue */
         /* bzw. reduzierte Blatt          */
	 Tree->color_count ++;
	 Tree->RGB.r += f.r;
	 Tree->RGB.g += f.g;
	 Tree->RGB.b += f.b;
	 foundleaf = Tree;
	 oldf = f;
       }
       else
       {      /* Nachfolgeknoten bestimmen */
	 hilf=(4*(f.r&B[Depth])+2*(f.g&B[Depth])+(f.b&B[Depth])) >> S[Depth];
	 if (hilf>7)
	   printf("Fehler!");
	 else
	   Tree->next[hilf]=insert_in_tree(Tree->next[hilf],f,Depth+1);
       }
     }
     return(Tree);
} /* insert_in_tree*/


/*================================================================*/
void reduce_tree()
/* kombiniert die Nachfolger des zuletzt erzeugten Knotens zu einem Blatt */
{
octree		tree,h;
short		i;
long	        count;
Color 		sum;
short	        level;

     level= OctreeDepth;
     while (size>sizemax)
     {
       level--;
       tree=reduce_list[level];

       while ( tree != NULL )
       {
	 reduce_list[ level ] = tree->nextnode;
	 count=0;
	 sum.r=0; sum.g=0; sum.b=0;
	 if (tree->leaf==1)
	      printf("\nerror: reducing a leaf");

	 for (i=0; i<8; i++)
	 {
	   if( tree->next[i]!=NULL)
	   {
	     h = tree->next[i];
	     if (h->leaf!=1)
	      printf("\nerror: reducing a node");
	     size--;
	     sum.r += h->RGB.r;
	     sum.g += h->RGB.g;
	     sum.b += h->RGB.b;
	     count += h->color_count;
	     free(tree->next[i]);
	     tree->next[i]=NULL;
	   }
	 }
	 tree->leaf        = 1;
	 tree->RGB         = sum;
	 tree->nextnode    = NULL;
	 if(count>0)
	   tree->color_count = count;
	 else
	   printf("\nerror color_count");
	 size++;
	 tree = reduce_list[ level ];
       }
     }
} /* reduce_tree*/


/*==========================================================*/
octree ini_octree(octree Tree,unsigned short maxdepth,unsigned short index_count)
/* Initialisiert einen Octree */

{
int i;

     OctreeDepth = maxdepth;
     sizemax     = index_count;
     Tree        = NULL;
     size        = 0;
     for (i=0;i<=OctreeDepth;i++)
     {
       reduce_list[i]=NULL;
     }
     return(Tree);
}  /* ini_octree  */

/***************************************************************/
void octree_quant(char *filename)
/****** Eigentliche Quantifizierungsroutine ***********/

{
    int            i,x,y;
    octree	   root_of_Tree = NULL;
    Color          col,oldf;
    int            colindex;
    FILE           *fp,*hfp;
    int		   xdim2;


    if (comments) printf("\n octree-algorithm started");
    /* Bild einlesen und octree aufstellen */
    if (Filter)
      {
        fp = stdin;
        hfp = fopen("show.hlp", "wb");
      }
    else
      {
        fp = fopen(filename, "rb");
        if (fp == NULL)
         {
           printf("\nAarrgh! Error reading file '%s': doesn't exist!\n",filename);
           exit(1);
         };
      };
    xdim=10*fgetc(fp);
    ydim=10*fgetc(fp);
    fgetc(fp);
    if (Filter)
      {
        fputc((unsigned char)(xdim / 10),hfp);
        fputc((unsigned char)(ydim / 10),hfp);
        fputc(0xff,hfp);
      }; 
    root_of_Tree=ini_octree(root_of_Tree,maxdepth,index_count);

    /* Aufbauen Octree */
    for (y=0; y<ydim; y++)
      {
      for (x=0; x<xdim; x++)
	{
	col.r= (unsigned char)fgetc(fp);
	col.g= (unsigned char)fgetc(fp);
	col.b= (unsigned char)fgetc(fp);
        if (Filter)
          {
            fputc((unsigned char)col.r, hfp);
            fputc((unsigned char)col.g, hfp);
            fputc((unsigned char)col.b, hfp);
          };
	root_of_Tree=insert_in_tree(root_of_Tree,col,0);
	if ( size > sizemax )
	  reduce_tree();
      }
    }
    if (comments) printf("\n %d colors used",size);
    if (!Filter) 
      fclose(fp);
    else
      fclose(hfp);
    if (comments) printf("\n building colour-table");
    if (comments) 
       printf("\n%d indexes used",init_color_table(root_of_Tree,0));
    else
       init_color_table(root_of_Tree,0);

    /* Ausgabe ********************/
    /* 32 bit alignment garantieren */
    if ((i = xdim % 4) != 0) 
       xdim2 = (xdim / 4 + 1) * 4;
    else
       xdim2 = xdim;
    mem = data = (char *)malloc((unsigned)(xdim2 * ydim));    
    ximage = XCreateImage(display,
			visual,
			depth,
			ZPixmap,
			0,
			data,
			xdim2, (unsigned int)ydim,
			8, 0
    );
    if (comments) printf("\n mapping picture to table");
    if (Filter)
      fp = fopen("show.hlp", "rb");
    else
      fp = fopen(filename, "rb");
    fgetc(fp);
    fgetc(fp);
    fgetc(fp); 

    for (y=0; y<ydim; y++) 
      {
      for (x=0; x<xdim; x++)
	{
	  if (x < xdim)
	    {
	      col.r= fgetc(fp) ;
	      col.g= fgetc(fp) ;
	      col.b= fgetc(fp) ;
              if ((oldf.r!=col.r) || (oldf.g!=col.g) || (oldf.b!=col.b)
                  || (colindex==-1))
                {
	          colindex=find_index(root_of_Tree,col);
                  oldf.r=col.r; oldf.g=col.g; oldf.b=col.b;
                }
	      *mem=(unsigned char)colindex;
	    }
	  else *mem=0;
	  mem++;    
      }
    }
  fclose(fp);
  if (Filter) system("rm show.hlp");
} /* octree_quant  */
/******************************************************/

void mybcopy(unsigned char *from, unsigned char *to, int size)
{
        while (size--)
                *to++ = *from++;

}



void install_colour_table()
  {
	int		i;
	XColor		*cols;


        /* die alte Farbtabelle holen */
        def_cmap = DefaultColormap(display, theScreen);
        for(i=0;i<256;i++)
          {
            color_x[i].pixel = i;
            color_x[i].flags = DoRed | DoGreen | DoBlue;
          } 
        XQueryColors(display,def_cmap,color_x,256);

        /* neue Farbtabelle erstellen */
	cmap = XCreateColormap(display, winder, visual, AllocAll);
	
	cols = (XColor *)malloc(256 * sizeof(XColor));
	for (i = 0; i < 256; i++) 
	   {
		cols[i].pixel = (unsigned long)i;
		cols[i].red   = (unsigned short)(rgb_tab[i][0] << 8);
		cols[i].green = (unsigned short)(rgb_tab[i][1] << 8);
		cols[i].blue  = (unsigned short)(rgb_tab[i][2] << 8);
		cols[i].flags = DoRed | DoGreen | DoBlue;
	   };
	XStoreColors(display, cmap, cols, 256);
	XSetWindowColormap(display, winder, cmap);
	free(cols);
  }
  
  
void make_window()
  {
	unsigned int		wattrmask;
	XSetWindowAttributes	wattr;
	XSizeHints		sizehints;
	XWMHints		wmhints;
	unsigned int		bw, mask, wid, hi;


	
	bw = 3;
	mask = 0;
	sizehints.flags = 0;
	sizehints.x = 0;
	sizehints.y = 0;
	sizehints.width = xdim;
	sizehints.height = ydim;
	sizehints.flags = PPosition | PSize;
        wattr.background_pixel = BlackPixel(display, theScreen);
        wattr.border_pixel = WhitePixel(display, theScreen);
	wattrmask = CWBackPixel | CWBorderPixel;

	winder = XCreateWindow(display,
			rootw,
			sizehints.x, sizehints.y,
			sizehints.width, sizehints.height,
			bw,
			depth,
			CopyFromParent,
			visual,
			wattrmask,
			&wattr
		);

	XSetWindowColormap(display, winder, cmap);

	XSetStandardProperties(display,
			winder,
			"graphED - show-command", 
			(char *)NULL,
			None,
			(char **)NULL, 0,
			&sizehints
	);
        wmhints.initial_state = NormalState;
        wmhints.input = True;
        wmhints.flags = StateHint | InputHint;
        XSetWMHints(display, winder, &wmhints);

	XSetForeground(display, theGC, WhitePixel(display, theScreen));
	XSetBackground(display, theGC, BlackPixel(display, theScreen));

        XSelectInput(display, winder, EV_MASK);
  }
  
  
void show_picture()
  {
   XMapWindow(display, winder);

   /* Warten auf ein exposure-event */
   do 
     {
       XNextEvent(display, &event);
     } 
   while (event.type != Expose);
 
   /* Bild auf Schirm ausgeben */
   XPutImage(display, 
	     winder,
	     theGC, 
	     ximage,
	     0, 0, 
             0, 0,
             xdim, ydim
   );
   XSetInputFocus(display, winder, RevertToParent, CurrentTime);
   XFlush(display);
  }
  
  
void wait_for_event()
  {
   XEvent	event;
   
   
   do 
     {
       XNextEvent(display, &event);
       if (event.type == Expose) 
         {
	   XPutImage(display, 
	   	     winder,
		     theGC, 
		     ximage,
		     0, 0, 
		     0, 0,
		     xdim, ydim
	   );
           XFlush(display);
	 };
      } 
    while (event.type != KeyPress && event.type != ButtonPress);
  }
  
  
void destroy_window()
  {
    XStoreColors(display, cmap, color_x, 256);
    XSetWindowColormap(display, winder, cmap);
    XFlush(display);
    XFreeColormap(display, cmap);
    XUnmapWindow(display, winder);
    XDestroyImage(ximage);
    XCloseDisplay(display);
  }
  

/******************************************************/
int	main(int argc,char *argv[])
  {       
   extern char 	*optarg;
   extern int 	 optind;
   extern int	 opterr;
   int		 opt;
   char		*infile;
    
    
   if (argc < 2)
     {
       printf("usage: show [<infile>] [-z] [-c]\n\n");
       printf("            <infile>  ---> '*.pic'-type\n");
       printf("            -z ---> reading from stdin\n");
       printf("            -c ---> enable comments\n\n");            
       exit(1);
     };  
   infile = (char *)argv[1];
   /* get arguments */
   comments = false;
   Filter = false;
   optind = 1;
   /* scanning for the first "-" */
   while ((optind < argc) && (strncmp(argv[optind],"-",1) != 0)) optind++;
   opterr = 0;
   while ((opt = getopt(argc,argv,"cz")) != EOF) 
     {
       switch (opt)
         {
           case 'c': 
               comments = true;
           break;
           case 'z' :
               Filter = true;
           break;
	   case '?':
               printf("usage: show [<infile>] [-z] [-c]\n\n");
	       printf("            <infile>  ---> '*.pic'-type\n");
               printf("            -z ---> reading from stdin\n");
	       printf("            -c ---> enable comments\n\n");            
	       exit(1);
	   break;
         };
     };    

   if (Filter) comments = false;

   /* initialisieren von X */
   displaystring = XDisplayName((char *)NULL);
   display = XOpenDisplay(displaystring);
   theScreen = DefaultScreen(display);
   if ((depth = XDisplayPlanes(display, theScreen)) < 8)
     {
       printf("\nneeding a colour-display");
       exit(1);
     };
   if (depth == 8)
     XMatchVisualInfo(display, theScreen, depth, PseudoColor, &visualinfo);
   else;
   visual = visualinfo.visual;	
   rootw = RootWindow(display, theScreen);
   theGC = DefaultGC(display, theScreen);
   
   /* Verarbeitung des Bildfiles */
   octree_quant(infile);
    
   if (comments) printf("\n opening window");
   make_window();
   if (comments) printf("\n initializing colour-table");
   install_colour_table();
   if (comments) printf("\n showing picture");
   show_picture();
   if (comments) printf("\n waiting for an event\n");
   wait_for_event();
   destroy_window(); 
    
   exit(0);        
  }
