/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: std.c[1.15] Mon Apr  6 22:04:31 1992 axel@cs.tu-berlin.de accessed $";
#endif

/* reearrangement of suffixes ??? */
/* implicit predefined rules with more than one target ??? */

#include "std.h"
#include "shape.h"
struct rules *stdruletab[STDRULETABSIZE];
int lastrule;
static struct cmds *newcmds();

/* char *stdsuff = ".o .c .c~ .mod .mod~ .sym .def .def~ .p .p~ .f .f~ .F .F~ .r .r~ .y .y~ .l .l~ .s .s~ .sh .sh~ .h .h~ "; */

/* .x~ suffixes are not supportet */

char *stdsuff = ".o .c .mod .sym .def .a .p .f .F .r .y .l .s .sh .h";

char *shaperules = "%.o:%.c %.o:%.l %.o:%.y %.o:%.s %.o:%.r %.o:%.F %.o:%.f %.o:%.mod %.o:%.p %.c:%.l %.c:%.y %.sym:%.def %.a:%.c %:%.sh %:%.r %:%.F %:%.f %:%.p %:%.mod %:%.c ";

int implicit_suffs[MAXIMPLICIT] = {12, /*  0   .c.o     */ 
				    3, /*  1   .l.o     */ 
				    4, /*  2   .y.o     */ 
				    5, /*  3   .s.o     */ 
				    6, /*  4   .r.o     */ 
				    7, /*  5   .F.o     */ 
				    8, /*  6   .f.o     */ 
				   10, /*  7   .mod.o   */ 
				   11, /*  8   .p.o     */ 
				    1, /*  9   .l.c     */ 
				    2, /* 10   .y.c     */ 
				    9, /* 11   .def.sym */ 
				    0, /* 12   .c.a     */ 
				   13, /* 13   .sh      */ 
				   14, /* 14   .r       */ 
				   15, /* 15   .F       */ 
				   16, /* 16   .f       */ 
				   17, /* 17   .p       */ 
				   18, /* 18   .mod     */ 
				   19, /* 19   .c       */ 
				   -1 };


char *stdrules[] = {

/* ".c.a",
"\t$(CC) -c $(CFLAGS) $(vflags) $<",
"\tar rv $@ $*.o",
"\trm -f $*.o", */

  "%.a",  /* 0 */
  "%.c",
  "+(CC)",
  "+(CFLAGS)",
  "+(vflags)",
  "\t$(CC) -c $(CFLAGS) $(vflags) %.c",
  "\tar rv %.a %.o",
  "\trm -f %.o",

/* ".l.c",
"\t$(LEX) $(LFLAGS) $<",
"\tmv lex.yy.c $@", */

  "%.c",  /* 1 */
  "%.l",
  "+(LEX)",
  "+(LFLAGS)",
  "\t$(LEX) $(LFLAGS) %.l",
  "\tmv lex.yy.c %.c",

/* ".y.c",
"\t$(YACC) $(YFLAGS) $<",
"\tmv y.tab.c $@", */

  "%.c",  /* 2 */
  "%.y",
  "+(YACC)",
  "+(YFLAGS)",
  "\t$(YACC) $(YFLAGS) %.y",
  "\tmv y.tab.c %.c",

/* ".l.o",
"\t$(LEX) $(LFLAGS) $<",
"\t$(CC) $(CFLAGS) $(vflags) -c lex.yy.c",
"\trm lex.yy.c",
"\tmv lex.yy.o $@", */

  "%.o",  /* 3 */
  "%.l",
  "+(LEX)",
  "+(LFLAGS)",
  "+(CC)",
  "+(CFLAGS)",
  "+(vflags)",
  "\t$(LEX) $(LFLAGS) %.l",
  "\t$(CC) $(CFLAGS) $(vflags) -c lex.yy.c",
  "\trm lex.yy.c",
  "\tmv lex.yy.o %.o",

/* ".y.o",
"\t$(YACC) $(YFLAGS) $<",
"\t$(CC) $(CFLAGS) $(vflags) -c y.tab.c",
"\trm y.tab.c",
"\tmv y.tab.o $@", */

  "%.o",  /* 4 */
  "%.y",
  "+(YACC)",
  "+(YFLAGS)",
  "+(CC)",
  "+(CFLAGS)",
  "+(vflags)",
  "\t$(YACC) $(YFLAGS) %.y",
  "\t$(CC) $(CFLAGS) $(vflags) -c y.tab.c",
  "\trm y.tab.c",
  "\tmv y.tab.o %.o",

/* ".s.o",
"\t$(AS) $(ASFLAGS) -o $@ $<", */

  "%.o",  /* 5 */
  "%.s",
  "+(AS)",
  "+(ASFLAGS)",
  "\t$(AS) $(ASFLAGS) -o %.o %.s",

/* ".r.o",
"\t$(FC) $(RFLAGS) $(FFLAGS) -c $<", */

  "%.o",  /* 6 */
  "%.r",
  "+(FC)",
  "+(RFLAGS)",
  "+(FFLAGS)",
  "\t$(FC) $(RFLAGS) $(FFLAGS) -c %.r",

/* ".F.o",
"\t$(FC) $(FFLAGS) -c $<", */

  "%.o",  /* 7 */
  "%.F",
  "+(FC)",
  "+(FFLAGS)",
  "\t$(FC) $(FFLAGS) -c %.F",

/* ".f.o",
"\t$(FC) $(FFLAGS) -c $<", */

  "%.o",  /* 8 * */
  "%.f",
  "+(FC)",
  "+(FFLAGS)",
  "\t$(FC) $(FFLAGS) -c %.f",

/* ".def.sym",
"\t$(M2C) $(M2FLAGS) $<", */

  "%.sym",  /* 9 */
  "%.def",
  "+(M2C)",
  "+(M2FLAGS)",
  "\t$(M2C) $(M2FLAGS) %.def",

/* ".mod.o",
"\t$(M2C) $(M2FLAGS) $<", */

  "%.o",  /* 10 */
  "%.mod",
  "+(M2C)",
  "+(M2FLAGS)",
  "\t$(M2C) $(M2FLAGS) %.o",

/* ".p.o",
"\t$(PC) $(PFLAGS) -c $<", */

  "%.o",  /* 11 */
  "%.p",
  "+(PC)",
  "+(PFLAGS)",
  "\t$(PC) $(PFLAGS) -c %.o",

/* ".c.o",
"\t$(CC) $(CFLAGS) $(vflags) -c $<", */

  "%.o",  /* 12 */
  "%.c",
  "+(CC)",
  "+(CFLAGS)",
  "+(vflags)",
  "\t$(CC) $(CFLAGS) $(vflags) -c %.c",

/* ".sh",
"\tcat $< >$@; chmod +x $@", */

  "%",  /* 13 */
  "%.sh",
  "\tcat %.sh >%; chmod +x %",

/* ".r",
"\t$(FC) $(RFLAGS) $(FFLAGS) $(LDFLAGS) $< -o $@", */

  "%",  /* 14 */
  "%.r",
  "+(FC)",
  "+(RFLAGS)",
  "+(FFLAGS)",
  "+(LDFLAGS)",
  "\t$(FC) $(RFLAGS) $(FFLAGS) $(LDFLAGS) %.r -o %",

/* ".F",
"\t$(FC) $(FFLAGS) $(LDFLAGS) $< -o $@", */

  "%",  /* 15 */
  "%.F",
  "+(FC)",
  "+(FFLAGS)",
  "+(LDFLAGS)",
  "\t$(FC) $(FFLAGS) $(LDFLAGS) %.F -o %",

/* ".f",
"\t$(FC) $(FFLAGS) $(LDFLAGS) $< -o $@", */

  "%",  /* 16 */
  "%.f",
  "+(FC)",
  "+(FFLAGS)",
  "+(LDFLAGS)",
  "\t$(FC) $(FFLAGS) $(LDFLAGS) %.f -o %",

/* ".p",
"\t$(PC) $(PFLAGS) $(LDFLAGS) $< -o $@", */

  "%",  /* 17 */
  "%.p",
  "+(PC)",
  "+(PFLAGS)",
  "+(LDFLAGS)",
  "\t$(PC) $(PFLAGS) $(LDFLAGS) %.p -o %",

/* ".mod",
"\t$(M2C) $(M2FLAGS) $(LDFLAGS) $< -e $@ -o $@", */

  "%",  /* 18 */
  "%.mod",
  "+(M2C)",
  "+(M2FLAGS)",
  "+(LDFLAGS)",
  "\t$(M2C) $(M2FLAGS) $(LDFLAGS) %.mod -e % -o %",

/* ".c",
"\t$(CC) $(CFLAGS) $(LDFLAGS) $< -o $@", */

  "%",  /* 19 */
  "%.c",
  "+(CC)",
  "+(CFLAGS)",
  "+(LDFLAGS)",
  "+(vflags)",
  "\t$(CC) $(CFLAGS) $(vflags) $(LDFLAGS) %.c -o %",

/* ".SUFFIXES:",
".o",".c",".c~",".mod",".mod~",".sym",".def",".def~",".p",".p~",".f",".f~",".F",".F~",".r",".r~",".y",".y~",".l",".l~",".s",".s~",".sh",".sh~",".h",".h~",
*/

"0"

};


add_stdrules()
{
  register int i = 0, j = 0, k = 0;
  register struct cmds *comm;

  while(strcmp(stdrules[i],"0") != 0)
      {
	if (is_pattern (stdrules[i]))
	  {
	    if((stdruletab[k] = 
		(struct rules *) malloc( sizeof(struct rules))) == 
	       (struct rules *) NIL)
	      errexit(10,"malloc");
	    bzero ((char *)stdruletab[k], sizeof (struct rules));
	    stdruletab[k]->name = stdrules[i];
	    stdruletab[k]->next = (struct rules *)NIL;
	    i++;
	  }
	if(stdrules[i][0] != '\t')
	  {
	    while ((stdrules[i][0] != '\t') &&
		   (stdrules[i][0] != '+') &&
		   (strcmp(stdrules[i],"0") != 0))
	      {
		stdruletab[k]->deplist = stdrules[i];
		stdruletab[k]->firstdep = stdrules[i];
		i++;
	      }
	  }
	if (stdrules[i][0] == '+')
	  {
	    j = 0;
	    while (stdrules[i][0] == '+')
	      {
		stdruletab[k]->heritage[j] = stdrules[i];
		i++;
		j++;
	      }
	    stdruletab[k]->heritage[j] = NIL;
	  }
	else
	  stdruletab[k]->heritage[0] = NIL;

	if (stdrules[i][0] == '\t')
	  {
	    comm = stdruletab[k]->cmdlist = newcmds();
	    if (stdrules[i][0] == '\t')
	      do
		{
		comm->command = stdrules[i];
		comm->nextcmd = newcmds();
 		comm = comm->nextcmd;
		i++;
	      }  while (stdrules[i][0] == '\t');

	    stdruletab[k]->targetlist[0] = stdruletab[k]->name;
	    stdruletab[k]->targetlist[1] = NIL;
	  }
	k++;
      }
  stdruletab[k] = (struct rules *) NIL;
  lastrule = k - 1;
}


static struct cmds *newcmds()
{
  register struct cmds *reval;
  
  reval = (struct cmds *) malloc( 10 + sizeof (struct cmds));
  if (!reval)
    errexit(10,"malloc");
  reval->nextcmd = (struct cmds *) 0;
  reval->command = (char *)0;
  return reval;
}
