/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: shapeopt.c[1.23] Thu Apr 23 20:47:25 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include "shape.h"
#include "ParseArgs.h"
char *version(), *af_version();
char cfname[MYMAXNAMLEN], echomac[32];
char *forcelist[10];
FILE *cid;

extern int main_gen, main_rev;

Bool debugflg;
Bool D_flag;
Bool selectflg;
Bool notfoundflg;
Bool noretrvflg;
Bool instflg;
Bool restflg;
Bool envflg;
Bool fileflg;
Bool nostdfile;
Bool ignoreflg;
Bool goflg;
Bool noexflg;
Bool printflg;
Bool questflg;
Bool ruleflg;
Bool silentflg;
Bool touchflg;
Bool stdinflg;
Bool confid;
Bool rebuildflg;
Bool stopflg;
Bool tunixflg;
Bool logflg;
Bool expflg;
Bool noexpflg;
Bool echoflg;
Bool nomsgflg;

Bool bpoolflg;
Bool nobpoolflg;
Bool forceflg;

extern int init_confid();
extern struct linked_list *shapefiles;
extern char ruleset[], rbtarg[], shapeflags[];
extern int implicit_suffs[];

extern int h_d_option();
extern int h_D_option();
extern int h_select_option();
extern int h_notfound_option();
extern int h_noretrv_option();
extern int h_inst_option();
extern int h_rest_option();
extern int h_e_option();
extern int h_f_option();
extern int h_force_option();
extern int h_h_option();
extern int h_i_option();
extern int h_k_option();
extern int h_log_option();
extern int h_m_option();
extern int h_n_option();
extern int h_nomsg_option();
extern int h_p_option();
extern int h_q_option();
extern int h_r_option();
extern int h_R_option();
extern int h_s_option();
extern int h_S_option();
extern int h_t_option();
extern int h_v_option();
extern int h_b_option();
extern int h_V_option();
extern int h_confid_option();
extern int h_version_option();
extern int h_rebuild_option();
extern int h_expandall_option();
extern int h_expandnothing_option();
extern int h_echo_option();
extern FILE *cmfopen();

OptDesc odesc[] = {
  { "d", PSWITCH, h_d_option, NULL, NULL },
  { "D", PSWITCH, h_D_option, NULL, NULL },
  { "select", PSWITCH, h_select_option, NULL, NULL},
  { "notfound", PSWITCH, h_notfound_option, NULL, NULL},
  { "noretrv", PSWITCH, h_noretrv_option, NULL, NULL},
  { "inst", PSWITCH, h_inst_option, NULL, NULL},
  { "restore", PSWITCH, h_rest_option, NULL, NULL},
  { "e", PSWITCH, h_e_option, NULL, NULL },
  { "f", PARG, h_f_option, NULL, NULL },
  { "force", PARG, h_force_option, NULL, NULL },
  { "h", PSWITCH, h_h_option, NULL, NULL },
  { "i", PSWITCH, h_i_option, NULL, NULL },
  { "k", PSWITCH, h_k_option, NULL, NULL },
  { "log", PSWITCH, h_log_option, NULL, NULL },
  { "m", PSWITCH, h_m_option, NULL, NULL },
  { "n", PSWITCH, h_n_option, NULL, NULL },
  { "nomsg", PSWITCH, h_nomsg_option, NULL, NULL },
  { "p", PSWITCH, h_p_option, NULL, NULL },
  { "q", PSWITCH, h_q_option, NULL, NULL },
  { "r", PSWITCH, h_r_option, NULL, NULL },
  { "R", PARG, h_R_option, NULL, NULL },
  { "s", PSWITCH, h_s_option, NULL, NULL },
  { "S", PSWITCH, h_S_option, NULL, NULL },
  { "t", PSWITCH, h_t_option, NULL, NULL }, 
  { "v", PARG, h_v_option, NULL, NULL },
  { "V", PARG, h_V_option, NULL, NULL },
  { "version", PSWITCH, h_version_option, NULL, NULL },
  { "confid", PARG, h_confid_option, NULL, NULL },
  { "rebuild", PARG, h_rebuild_option, NULL, NULL },
  { "expandall", PSWITCH, h_expandall_option, NULL, NULL },
  { "expandnothing", PSWITCH, h_expandnothing_option, NULL, NULL },
  { "echo", PARG, h_echo_option, NULL, NULL },
  { "b", PSWITCH, h_b_option, NULL, NULL },
  { (char *) NULL, 0, NULL, NULL, NULL }
};

int h_d_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  debugflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_D_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  D_flag = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}


int h_e_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  envflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_f_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{

struct linked_list *shfiles;
if (!strcmp(arg,""))
  return(1);
fileflg = TRUE;
if (strcmp(arg,"-") == 0)
  stdinflg = TRUE;
else
  {
    if (shapefiles == (struct linked_list *) NIL)
      {
	if ((shapefiles = (struct linked_list *) malloc(sizeof(struct linked_list))) == (struct linked_list *) NIL)
	  errexit(10,"malloc");
	if ((shapefiles->string = malloc((unsigned) strlen(arg) + sizeof(char))) == NIL)
	  errexit(10,"malloc");
	(void) strcpy(shapefiles->string,arg);
	shapefiles->nextstring = (struct linked_list *) NIL;
      }
    else
      {
	shfiles = shapefiles;
	while( shfiles->nextstring != (struct linked_list *) NIL)
	  shfiles = shfiles->nextstring;
	
	if((shfiles->nextstring  = (struct linked_list *) malloc(sizeof(struct linked_list))) == (struct linked_list *) NIL)
	  errexit(10,"malloc");
	shfiles = shfiles->nextstring;
	if ((shfiles->string = malloc((unsigned) strlen(arg) + sizeof(char))) == NIL)
	  errexit(10,"malloc");
	(void) strcpy(shfiles->string, arg);
	shfiles->nextstring = (struct linked_list *) NIL;
      }
  }
  return(0);
}


int h_force_option(opt,arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  int i = 0;
  forceflg = TRUE;
  while(forcelist[i] != NIL)
    {
      if (i == 10)
	errexit(36, NIL);
      i++;
    }
  if ((forcelist[i] = malloc((unsigned) (strlen(arg) + sizeof(char)))) == NIL)
    errexit(10,"malloc");
  (void) strcpy(forcelist[i],arg);
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  (void) strcat (shapeflags, arg);
  (void) strcat (shapeflags, " ");
  return (0);
}

int h_h_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  return(1);
}

int h_i_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  ignoreflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_k_option(opt, arg)
     /*ARGSUSED*/
     char *opt; 
     char *arg;
{
  goflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_log_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  logflg = TRUE;
  return(0);
}

int h_m_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  /* weiss ich nich */
  return(0);
}

int h_n_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  noexflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}
int h_nomsg_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  nomsgflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_p_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  printflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_q_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  questflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_r_option(opt,arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  implicit_suffs[0] = -1;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}


int h_R_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  ruleflg = TRUE;
  (void) strcpy(ruleset,arg);
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  (void) strcat (shapeflags, arg);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_s_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  silentflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_S_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  goflg = FALSE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_t_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  touchflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_v_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
/*  variant = arg  ???? */;
  return(0);
}

int h_version_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  printf("shape - Version %s\n", version());
  printf("AtFS version %s\n", af_version());
  printf("AtFS toolkit lib %s\n", at_version());
  exit(0);
}

int h_expandall_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  if (noexpflg)
    errexit(34,NIL);
  expflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_expandnothing_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  if(expflg)
    errexit(34,NIL);
  noexpflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_echo_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  echoflg = TRUE;
  (void) strcpy(echomac,arg);
  return(0);
}

int h_b_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
; /* because of compatibility; does nothing (i hope so ...) */
  return(0);
}

int h_V_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  /* set generation and revision (for shapefile) */
  char *ccc;
  if ((ccc = index(arg,'.')) == 0)
    errexit(9, arg);
  else
    {
      ccc[0] = '\0';
      main_gen = atoi(arg);
      *ccc++;
      main_rev = atoi(ccc);
    }
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  (void) strcat (shapeflags, arg);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_confid_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  if (!strcmp(arg,""))
    return(1);

  confid = TRUE;
  (void) strcpy(cfname,arg);
  (void) strcat(cfname,".cid");
  if ((cid = cmfopen(cfname,"w",AF_BUSYVERS, AF_BUSYVERS)) == (FILE *) NIL)
    errexit(12, cfname);
  init_confid(arg);
  (void) strcpy(cfname,arg);
  return(0);
}

int h_rebuild_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
char *p;
char fname[MYMAXNAMLEN];
(void) strcpy(fname,arg);

if((rindex(fname,'[') == NIL))
  {
    (void) strcpy(rbrule,"@");
    (void) strcat(rbrule,fname);
    (void) strcpy(rbtarg,fname);
    (void) strcat(fname,".cid");
    (void) strcpy(rbfile,fname);
  }
else
  {
    (void) strcpy(rbfile,fname);
    (void) strcpy(rbtarg,fname);
    if((p = index(rbtarg,'.')) != NIL)
      *p = '\0';
    (void) strcpy(rbrule,"@");
    (void) strcat(rbrule,rbtarg);
  }

rebuildflg = TRUE;

return(0);

}

int h_select_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  selectflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_notfound_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  notfoundflg = TRUE;
  noexflg = TRUE;
  silentflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}

int h_noretrv_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  noretrvflg = TRUE;
  (void) strcat (shapeflags, "-");
  (void) strcat (shapeflags, opt);
  (void) strcat (shapeflags, " ");
  return(0);
}


int h_inst_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  instflg = TRUE;
  return(0);
}

int h_rest_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  restflg = TRUE;
  return(0);
}

