/* $__copyright$ */


typedef int Bool;

#define TRUE 1
#define FALSE 0

#define TEST_ONLY 0
#define BIND_IT 1

#define VOID int
#define EOL '\n'
#define EOS '\0'
#define NIL ((char *) 0)
#define MYMAXNAMLEN 256
#include "atfs.h"
#include "atfsapp.h"

#include <ctype.h>

typedef struct { 
  Bool bk_isdefined;
  Af_key bk_key;
} BKey;

#define MAXATTRLEN 1024

typedef struct {
  int dependent_queue_initialized;
  Af_key *dependent_queue, *head, *tail;
  char keybuffer[MAXATTRLEN];
  int queued_dependents, current_max_dependents;
  int queue_changed;
} DepQ;

#define suffix(s) (rindex (s, '.') ? rindex (s, '.') : s)

#define SMILEY -1
#define GRIMMY -2
#define STD_ATTRS 10

extern int af_errno;

extern char *rindex();
extern char *index();
extern char *malloc();
extern char *realloc();

extern int errexit();

extern Bool pattern();
extern Bool attr();
extern Bool attrnot();
extern Bool attrvar();
extern Bool attrnotvar();
extern Bool attrlt();
extern Bool attrgt();
extern Bool attrle();
extern Bool attrge();
extern Bool attrmin();
extern Bool attrmax();
extern Bool getfromcid();
extern Bool msg();
extern Bool confirm();
extern Bool stopit();
extern Bool tunix();

extern Bool bound_key_defined ();
extern Af_key *bound_key ();

#define ATTRNAME "__DerivationKey__"
#define DRV_TIME "__DTime__"

#define MAXATTRLENGTH 20000
#define MAXDEPTH 64

#define MAXPATHLIST 256
extern char *pathlist[MAXPATHLIST][2];
extern int lastpath;

extern int rec_do_depth;


#define MAXVPATH 16
extern char *curvpath[];
extern char prev_dir[];
extern char rbrule[];
extern char rbfile[];

extern char *environment_vars;

extern Bool debugflg;
extern Bool D_flag;
extern Bool selectflg;
extern Bool notfoundflg;
extern Bool noretrvflg;
extern Bool instflg;
extern Bool restflg;
extern Bool envflg;
extern Bool fileflg;
extern Bool nostdfile;
extern Bool ignoreflg;
extern Bool goflg;
extern Bool noexflg;
extern Bool printflg;
extern Bool questflg;
extern Bool ruleflg;
extern Bool silentflg;
extern Bool touchflg;
extern Bool stdinflg;
extern Bool confid;
extern Bool rebuildflg;
extern Bool stopflg;
extern Bool tunixflg;
extern Bool logflg;
extern Bool expflg;
extern Bool noexpflg;
extern Bool echoflg;
extern Bool nomsgflg;

extern Bool bpoolflg;
extern Bool nobpoolflg;
extern Bool forceflg;

extern char echomac[];

extern FILE *cid;

Bool doublecolon;
extern Bool suffs_deleted;

struct linked_list {
  char *string;
  struct linked_list *nextstring;
};

struct cmds
{
  char *command;
  struct cmds *nextcmd;
};

#define MAXTARGS 128
#define MAXHERIT 32
#define MAXDEPS 256
#define MAXCMDS 32

struct rules
{
  char *name;
  struct rules *next;
  Af_set date;
  int done;
  Bool doublecolon;
  Bool saved;
  char *firstdep;                 /* possibly selection rule name */
  char *deplist;
  char *heritage[MAXHERIT];
  char *targetlist[MAXHERIT];
  struct cmds *cmdlist;
  struct rules *nextrule;
};

extern struct rules *ruletab[];
extern struct rules *stdruletab[];
extern int lastrule;    /* index of last std rule */

struct list
{
  int (*selfunc)();
  char *parn;
  char *parv;
  int i;
  struct list *cont;
};

extern struct selection_rules *sels[];


struct linkreg {
  char *fn;
  char *newfn;
  Bool busy_exist;
  struct linkreg *next;
};

#define MAXVARIANTS 32
#define MAXVMACROS 32 
#define MAXVCLASS 64
#define MAXVARDEFS 64
#define MAXFLGLENGTH 256
#define MAXVNAMELENGTH 64
#define MAXACTVAR 32

struct vardef {
  char *name;
  char *vmacros[MAXVMACROS];
  char *vflags;
  char *vpath;
};

struct varclass {
  char *name;
  int active;
  char *variants[MAXVARIANTS];
};

#define MAXPREDS 256

struct selection_rules
{
  char *name;
  struct list *predlist[MAXPREDS];
  struct selection_rules *next;
};

