/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: selrule.c[1.21] Fri Apr 24 18:01:28 1992 axel@cs.tu-berlin.de accessed $";
#endif


#include "shape.h"
#include "selrule.h"

static char *stdattr[]  = { "attr",
		       "attrnot",
		       "attrlt",
		       "attrgt",
		       "attrle",
		       "attrge",
		       "attrmin",
		       "attrmax",
		       "getfromcid",
		       "attrvar",
		       "msg",
		       "confirm",
		       "0"
		       };

extern char *expandmacro();
extern int hashval(), errexit();
extern Bool smiley_or_grimmy();
void selruledef_preds();
extern struct selection_rules *currule;
struct selection_rules *current_selrule;
struct list *current_list;
int current_list_index = 0;

void selruledef_name(string)
     char *string;
{
  char rulename[MAXNAMELENGTH];
  register struct selection_rules *cursec;
  register int i = 0;
  int hashr;
  char string2[2048];
  
  if(index(string,'$') != NIL)
    {
      (void) strcpy(string2,expandmacro(string));
      string = &string2[0];
    }

  while((string[i] != ':') && (string[i] != ' ') && (string[i] != '\t'))
    {
      rulename[i] = string[i];
      i++;
    }
  rulename[i] = '\0';
  hashr = hashval(rulename);
  if(sels[hashr] == (struct selection_rules *) NIL)
    {
      if((cursec = sels[hashr] = (struct selection_rules *)
	  malloc( sizeof( struct selection_rules))) ==
	 (struct selection_rules *) NIL)
	errexit(10,"malloc");
    }
  else
    {
      cursec = sels[hashr];
      while((strcmp(cursec->name,rulename)) &&
	    (cursec->next != (struct selection_rules *) NIL))
	cursec = cursec->next;
      if(!strcmp(cursec->name,rulename))
	errexit(5,rulename);
      else
	{
	  if((cursec = cursec->next = (struct selection_rules *)
	     malloc(sizeof(struct selection_rules))) ==
	     (struct selection_rules *) NIL)
	    errexit(10,"malloc");
	}
    }
  cursec->next = (struct selection_rules *) NIL;
  if ((cursec->name = malloc((unsigned) (strlen(rulename) + 1 ))) == NIL)
    errexit(10,"malloc");
  (void) strcpy(cursec->name, rulename);
  current_selrule = cursec;
  current_list_index = 0;
  while(string[i] != '\0')
    {
      if((string[i] == ' ') || (string[i] == '\t') ||
	 (string[i] == ':') || (string[i] == '\n'))
	i++;
      else
	{
	  if(string[i] != '\0')
	     {
	       selruledef_preds(&string[i]);
	       break;
	     }
	}
    }
}

void selruledef_preds(string)
     char *string;
{
  struct selection_rules *cursec;
  struct list *curlist;
  register int i = 0, j = 0;
  int ind, what = 0;
  char *predptr;
  static int k;
  static Bool first_pred=TRUE;
  char pred[MAXPREDLENGTH], name[MAXNAMELENGTH], value[MAXVALLENGTH];
  char string2[256];
  extern int (*get_selfunc())();
  curlist = current_list;
  cursec = current_selrule;
  k = current_list_index;

  if(index(string,'$') != NIL)
    {
      (void) strcpy(string2,expandmacro(string));
      string = &string2[0];
    }

  while((string[i] == ' ') || (string[i] == '\t') || (string[i] == '\n'))
    i++;

  while(string[i] != '\0')
    {
      /* make predicate name */
      j = 0;
      while((string[i] != ' ') && (string[i] != '\t') && (string[i] != '\n')
	    && (string[i] != '(') && (string[i] != ',') && (string[i] != ';')
	    && (first_pred || (string[i] != '.'))) 
	/*
	 * whitespace and syntax delimits; 
	 *  "." allowed in first-pred (pattern) 
	 */
	{
	  pred[j++] = string[i++];
	}
      pred[j] = '\0';

      if(smiley_or_grimmy(pred)) {
	while((string[i] != ',') && (string[i] != ';') && 
	      (string[i] != '.') && string[i++]); 
	/* skip forward to next predicate ?! */
	/* first_pred = TRUE; */
      }

      if(!first_pred)
	{
	  /*
	   * build "name" argument for predicate 
	   */

	  /* skip leading open-parenthesis and whitespace */
	  while(string[i] && ((string[i] == '(') || (string[i] == ' ') ||
		(string[i] == '\t')))
	    i++;
	  j = 0;

	  if (!strcmp (pred, "confirm"))
	    {
	      /* build message */
	      while(string[i] && (string[i] != ',') && (string[i] != ')'))
		name[j++] = string[i++];
	    }
	  else
	    {
	      if (!strcmp (pred, "msg"))
		{
		  /* build message */
		  while(string[i] && (string[i] != ')'))
		    name[j++] = string[i++];
		}
	      else
		{
		  /* build name -- whitespace and syntax delimits */
		  while(string[i] && (string[i] != ',') && (string[i] != ';') &&
			(string[i] != '.') && (string[i] != ')'))
		    name[j++] = string[i++];
		}
	    }

	  /* remove trailing whitepsace */
	  while ((name[j-1] == ' ') || (name[j-1] == '\t')) j--;
	  name[j] = '\0';

	  /*
	   * try to build "value" for predicate
	   */

	  /* skip leading whitespace and commas */
	  while(string[i] && ((string[i] == ' ') || (string[i] == ',') ||
		(string[i] == '\t')))
	    i++;

	  /* value is delimited by closing paren. or syntax */
	  j = 0;
	  if((string[i] != ')') && (string[i] != ';') && (string[i] != '.'))
	    {
	      while(string[i] && string[i] != ')')
		value[j++] = string[i++];
	    }
	  value[j] = '\0';
	}

      if(first_pred)
	{
	  first_pred = FALSE;
	  if((curlist = cursec->predlist[k] = (struct list *)
	      malloc(sizeof (struct list))) == (struct list *) NIL)
	    errexit(10,"malloc");
	  cursec->predlist[k+1] = (struct list *) NIL;
	  curlist->selfunc = pattern;
	  curlist->parn = NIL;
	  curlist->cont = (struct list *) NIL;
	  predptr = &pred[0];
	  predptr = predptr + specials(predptr, &what);
	  if ((curlist->parv = malloc ((unsigned) (strlen(pred)
						   + sizeof(char)))) == NIL)
	    errexit(10,"malloc");
	  (void) strcpy(curlist->parv, pred);
	  curlist->i = what;
	  what = 0;
	  current_list = curlist;
	}
      else
	{
	  if((curlist = curlist->cont = (struct list *)
	      malloc(sizeof (struct list))) == (struct list *) NIL)
	    errexit(10,"malloc");
	  /*
	   * check for smiley or grimmy here ....
	   */
	  /* ... or should "specials" be called here ?? */
	  if (smiley_or_grimmy (pred))
	    (void) specials (pred, &ind);
	  else
	    curlist->selfunc = get_selfunc(pred,&ind);
	  curlist->i = ind;
	  curlist->cont = (struct list *) NIL;
	  if((curlist->parn = malloc((unsigned) (strlen(name) +
						 sizeof(char)))) == NIL)
	    errexit(10,"malloc");
	  (void) strcpy(curlist->parn,name);
	  if((curlist->parv = malloc((unsigned) (strlen(value) +
						 sizeof(char)))) == NIL)
	    errexit(10,"malloc");
	  (void) strcpy(curlist->parv,value);
	  current_list = curlist;
	}
      while((string[i] == ' ') || (string[i] == '\t') || (string[i] == ')'))
	i++;
      if(string[i] == ';')
	{
	  first_pred = TRUE;
	  current_list_index++;
	  k++;
	}
      else
	{
	  if((string[i] != ',') && (string[i] != '.'))
	    errexit(38,string);
	  if(string[i] == '.')
	    first_pred = TRUE;
	}
      i++;
      while((string[i] == ' ') || (string[i] == '\t') ||
	    (string[i] == '\n'))
	i++;
    }
}

Bool is_selrule_name(name)
     char *name;
{
  int hash;
  register struct selection_rules *current;

  hash = hashval(name);
  
  if (sels[hash] == (struct selection_rules *) NIL)
    return (FALSE);
  else
    current = sels[hash];

  while (current != (struct selection_rules *) NIL)
    {
      if ((strcmp(current->name, name)) == 0)
	{
	  currule = current;
	  return(TRUE);
	}
      else
	current = current->next;
    }
  
  if ( current == (struct selection_rules *) NIL)
    return(FALSE);

  /*NOTREACHED*/
  return (FALSE);
}
struct selection_rules *sel_name_to_rule (name)
     char *name;
{
  int hash;
  register struct selection_rules *current;

  hash = hashval(name);
  
  if (sels[hash] == (struct selection_rules *) NIL)
    return (struct selection_rules *)NIL;
  else
    current = sels[hash];

  while (current != (struct selection_rules *) NIL)
    {
      if ((strcmp(current->name, name)) == 0)
	{
	  return current;
	}
      else
	current = current->next;
    }
  
  if ( current == (struct selection_rules *) NIL)
    return  (struct selection_rules *)NIL;

  /*NOTREACHED*/
  return  (struct selection_rules *)NIL;
}


int specials(ptr, what)
     char *ptr;
     int *what;
{
  if(*ptr == '+')
    {
      *what = SMILEY;
      return(1);
    }

  if(*ptr == '-')
    {
      *what = GRIMMY;
      return(1);
    }
  what = 0;
  return(0);
}
  
init_selruletab()
{
  bzero((char *) sels, SELTABSIZE * sizeof(struct rules *));
}


int (*get_selfunc(pred,ind))()
     char *pred;
     int *ind;
{
  register int j;
  j = get_stdattr_no(pred);
  switch (j)
    {
    case 0:
      *ind = 1;
      return(attr);
    case 1:
      *ind = 2;
      return(attrnot);
    case 2:
      *ind = 2;
      return(attrlt);
    case 3:
      *ind = 2;
      return(attrgt);
    case 4:
      *ind = 2;
      return(attrle);
    case 5:
      *ind = 2;
      return(attrge);
    case 6:
      *ind = 2;
      return(attrmin);
    case 7:
      *ind = 2;
      return(attrmax);
    case 8:
      *ind = 1;
      return(getfromcid);
    case 9:
      *ind = 0;
      return(attrvar);
    case 10:
      *ind = 0;
      return(msg);
    case 11:
      *ind = 3;
      return (confirm);
    }
/*NOTREACHED*/
  return(0);
}


int get_stdattr_no(pred)
     char *pred;
{
  register int j = 0;
  while ((strcmp(pred, stdattr[j]) != 0) && (strcmp(stdattr[j],"0")!= 0))
    j++;
  if (strcmp(pred,stdattr[j]) != 0 )
    errexit(6, pred);
  else
    return(j);
/*NOTREACHED*/
  return(0);
}


Bool smiley_or_grimmy(str)
     char *str;
{
  if((!strcmp(str,":-)")) || (!strcmp(str,":-(")) ||
     (!strcmp(str,"+")) || (!strcmp(str,"-")))
    return(TRUE);
  else
    return(FALSE);
}
      
