/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: produce.c[1.46] Fri Apr 24 18:01:18 1992 axel@cs.tu-berlin.de accessed $";
#endif


#include "shape.h"
#include "files.h"

#define MAXCMDLENGTH 10240
extern char *get_dep();
extern char *rindex();

Bool error_happened = FALSE;
Bool error_occ = FALSE, simple_done = FALSE;
Bool no_comm_subst = FALSE;
extern Bool already_in_done_list();

extern int cleanup_links(), errexit(), hashval(), free_linklist(), D_debug();
extern int save_targets(), restore_all_vers();
extern struct linkreg *link_reg;

extern void warning(), reset_pathlist(), cl_variants(), de_activate();
extern void mark_all_done(), drop_restorelist ();

extern char *expandmacro(), *get_src_name();

extern Bool compare_attrstring(), locate_object(), Sselect(), try_to_bind_version();
extern Bool is_varname(), attrvar();
extern struct selection_rules *sel_name_to_rule();

extern char cfname[];

extern struct rules *ruletab[];

extern int implicit_suffs[], variants_active, lastrule;

extern char *cmdtargets[], *firsttarget, actpath[], cursr[], *curvar[];

extern Bool shape_command;

typedef enum { Ok, Fail, Abort } TargetCode;
/* used by make_target */

char rbrule[64], rbtarg[64], ruleset[32], lastcurdep[MYMAXNAMLEN];
char current_dep[MYMAXNAMLEN];
Bool busy_done = FALSE, reallydone = FALSE;
int depth;
char *default_targets = ".DEFAULT";


static char *expand_command (cmd, cur, rel_dep)
     char *cmd;
     struct rules *cur;
     char *rel_dep;
{
  char curdep[512], hhh[64], hhh2[64], path1[MYMAXNAMLEN];
  char comm[MAXCMDLENGTH], *common_prefix, *p, *hhhp, *hhh2p;
  register int i = 0, j = 0, k = 0;
  Bool ttt = FALSE;

  while(cmd[i] != '\0')
    {
      if((cmd[i] == '\\') && (cmd[i+1] == '`'))
	i++;
      if ((cmd[i] == '\\') && (cmd[i+1] == '%'))
	comm[j++] = cmd[++i];
      if((cmd[i] != '$') && (cmd[i] != '%'))
	{
	  comm[j] =  cmd[i];
	  i++;
	  j++;
	}
      else
	{
	  switch (cmd[i+1])
	    {
	    case '@':
	      if (!is_pattern (cur->name))
		{
		  comm[j] = '\0';
		  (void) strcat(comm, cur->name);
		  /* (void) strcat(comm," "); */
		  j = j + strlen(cur->name);
		  i = i + 2;
		}
	      else
		{
		  comm[j] = '\0';
		  (void) strcpy(hhh,rel_dep);
		  hhhp = rindex(hhh,'.');
		  if (hhhp != NIL)
		    {
		      hhhp[0] = '\0';
		    }
		  (void) strcpy(hhh2, cur->name);
		  hhh2p = rindex(hhh2,'.');
		  (void) strcat(hhh,hhh2p);
		  (void) strcat(comm, hhh);
		  (void) strcat(comm, " ");
		  j = j + strlen(hhh) + 1;
		  i = i + 2;
		}
	      
	      break;
	    case '?':
	      if (get_dep(cur,0,1) != NIL)
		{
		  k = 1;
		  (void) strcpy(curdep,get_dep(cur,0,0));
		  ttt = locate_object (cur->name, SOURCE);
		  (void) strcpy (path1,actpath);

		  while (strcmp (curdep, ""))
		    {
		      if (Sselect(cur->name, path1, ttt, get_dep(cur,0,1), curdep))
			/* if (cur->date < curdep->date)  ????? */
			{
			  comm[j] = '\0';
			  if((curdep[0] != '+') && (!is_selrule_name(curdep)))
			    {
			      (void) strcat(comm, curdep);
			      (void) strcat(comm," ");
			      j = j + strlen(curdep) + 1;
			    }
			}
		      if(get_dep(cur,k,1) != NIL)
			(void) strcpy(curdep,get_dep(cur,k,1));
		      else
			(void) strcpy(curdep,"");
		      k++;
		    }
		}
	      i = i + 2;
	      break;
	    case '<':
	      comm[j] = '\0';
	      if (strcmp(actpath,"") != 0)
		{
		  (void) strcat(comm,actpath);
		  (void) strcat(comm,"/");
		  j = j + strlen(actpath) + 1;
		}
	      (void) strcat(comm, rel_dep);
	      (void) strcat(comm, " ");
	      j = j + strlen(rel_dep) + 1;
	      i = i + 2;
	      break;
	    case '*':
	    case '.':
	    case ' ':
	      if (!is_pattern (cur->name))
		{
		  if ((common_prefix = malloc((unsigned) (strlen(cur->name) + 1))) == NIL)
		    errexit(10,"malloc");
		  (void) strcpy(common_prefix, cur->name);
		  if ((p = rindex(common_prefix,'.')) != NIL)
		    {
		      p[0] = '\0';
		    }
		  comm[j] = '\0';
		  (void) strcat(comm, common_prefix);
		  j = j + strlen(common_prefix);
		  if (cmd[i+1] == '*')
		    i = i + 2;
		  else
		    i++;
		}
	      else
		{
		  comm[j] = '\0';
		  (void) strcpy(hhh,rel_dep);
		  hhhp = rindex(hhh,'.');
		  if(hhhp != NIL)
		    {
		      hhhp[0] = '\0';
		    }
		  (void) strcat(comm, hhh);
		  j = j + strlen(hhh);
		  i = i+1;
		}
	      
	      break;
	    case '(':
	      errexit(99,"output translation $(name:str1=str2)");
	      /* ???? output translation, not yet implemented */
	      break;
	    case '$':
	      comm[j] = '$';
	      j++;
	      i = i+2;
	      break;
	    default:
	      if(cmd[i] == '%')
		/* single suffix rule */
		{
		  comm[j] = '\0';
		  (void) strcpy(hhh,rel_dep);
		  hhhp = rindex(hhh,'.');
		  if(hhhp != NIL)
		    {
		      hhhp[0] = '\0';
		    }
		  (void) strcat(comm, hhh);
		  j = j + strlen(hhh);
		  i = i+1;
		}
	      else
		{
		  comm[j] = cmd[i];
		  j++;
		  i++;
		}
	      break;
	    }
	}
    }
  comm[j] = '\0';
  if (comm[0] == '\0')
    (void) strcpy(comm,cmd);
  return(comm);
}

struct rules *get_target (targ) char *targ; {
  int hasht;
  register struct rules *current = (struct rules *) NIL;
  char *p = NIL;
  char fname[MYMAXNAMLEN], fnames[10][MYMAXNAMLEN], targrulename[MYMAXNAMLEN];
  char path1[MYMAXNAMLEN];
  register int i, j;
  Bool targ_in_src_rkive = FALSE, prerequisites_available = TRUE;
  BKey bkey;

  /*
   * Find and return the production rule for the specified target.
   * Before a rule is returned as applicable, "get_target" makes
   * sure that we know rules to produce all dependents of "targ".
   */

  if (!*targ)
    return((struct rules *) NIL);
  
  hasht = hashval(targ);
  
  if (ruletab[hasht] != (struct rules *) NIL) {
    current = ruletab[hasht];
    while ((current != (struct rules *) NIL ) && 
	   (strcmp (targ, current->name) != 0)) {
      /* look through hash chain */
      current = current->nextrule;
    }
  }

  if ((current) && (strcmp(targ, current->name) == 0))
    return current;

  /*
   * Either there is no rule for hashval(targ), or the rule 
   * doesn't match, i.e. hashval(targ) is accidentally the same as
   * for some explicit target. We have to look for std rule .
   */
  
  (void) strcpy (path1, actpath);
  (void) strcpy (actpath, "");
  
  for(i = 0; i <= lastrule; i++) {
    if (implicit_suffs[i] == -1)
      continue;
    (void) strcpy (fname, targ);
    p = rindex (fname, '.');
    
    prerequisites_available = TRUE;
    /* build source name */
    if (p != NIL)
      *p = '\0';   /* p = suffix of target */
    if (p != NIL)
      (void) strcpy (targrulename, "%.");
    else
      (void) strcpy (targrulename, "%");
    if (p != NIL)
      (void) strcat (targrulename, p + 1);
    
    if (strcmp (targrulename, stdruletab[implicit_suffs[i]]->name) == 0) {
      /*
       * We have found an implicit rule that matches our target.
       * Now, construct the implicit dependent object(s) name(s)
       * by substituting the '%' character with the filename-stem
       * of targ. Then, see if a corresponding object can be located
       * or derived.
       */
      for (j = 0; get_dep (stdruletab[implicit_suffs[i]], j); j++) {
	Bool object_derivable, object_exists;
	(void) strcat (fname, 
		       suffix (get_dep (stdruletab[implicit_suffs[i]], j)));
	object_derivable = (Bool) get_target (fname);
	object_exists = locate_object (fname, SOURCE);
	prerequisites_available = 
	  prerequisites_available && ( object_derivable || object_exists);
	
	/* reset the filename prefix */
	if (p != NIL)
	  *p = '\0';
	else
	  (void) strcpy (fname, targ);
      } /* end for */

      if (prerequisites_available)
	return stdruletab[implicit_suffs[i]];
    } /* end if (strcmp (targrulename, stdruletab[implicit_suffs[i]].. */
  } /* end for (i <= lastrule ) */ 

  return (struct rules *) NIL;
}

struct rules *implicit_target (targ) char *targ; {
  int hasht;
  register struct rules *current = (struct rules *) NIL;
  char *p = NIL;
  char fname[MYMAXNAMLEN], fnames[10][MYMAXNAMLEN], targrulename[MYMAXNAMLEN];
  char path1[MYMAXNAMLEN];
  register int i, j;
  Bool targ_in_src_rkive = FALSE, prerequisites_available = TRUE;
  BKey bkey;

  /*
   * Find and return the applicable implicit production rule for 
   * the specified target.
   * Before a rule is returned as applicable, "get_target" makes
   * sure that we know rules to produce all dependents of "targ".
   */

  if (!*targ)
    return((struct rules *) NIL);

  (void) strcpy (path1, actpath);
  (void) strcpy (actpath, "");
  
  for(i = 0; i <= lastrule; i++) {
    if (implicit_suffs[i] == -1)
      continue;
    (void) strcpy (fname, targ);
    p = rindex (fname, '.');
    
    prerequisites_available = TRUE;
    /* build source name */
    if (p != NIL)
      *p = '\0';   /* p = suffix of target */
    if (p != NIL)
      (void) strcpy (targrulename, "%.");
    else
      (void) strcpy (targrulename, "%");
    if (p != NIL)
      (void) strcat (targrulename, p + 1);
    
    if (strcmp (targrulename, stdruletab[implicit_suffs[i]]->name) == 0) {
      /*
       * We have found an implicit rule that matches our target.
       * Now, construct the implicit dependent object(s) name(s)
       * by substituting the '%' character with the filename-stem
       * of targ. Then, see if a corresponding object can be located
       * or derived.
       */
      for (j = 0; get_dep (stdruletab[implicit_suffs[i]], j); j++) {
	Bool object_derivable, object_exists;
	(void) strcat (fname, 
		       suffix (get_dep (stdruletab[implicit_suffs[i]], j)));
	object_derivable = (Bool) get_target (fname);
	object_exists = locate_object (fname, SOURCE);
	prerequisites_available = 
	  prerequisites_available && ( object_derivable || object_exists);
	
	/* reset the filename prefix */
	if (p != NIL)
	  *p = '\0';
	else
	  (void) strcpy (fname, targ);
      } /* end for */

      if (prerequisites_available)
	return stdruletab[implicit_suffs[i]];
    } /* end if (strcmp (targrulename, stdruletab[implicit_suffs[i]].. */
  } /* end for (i <= lastrule ) */ 

  return (struct rules *) NIL;
}

static struct cmds *implicit_command (targ)
     char *targ;
{
  register struct rules *current = (struct rules *) NIL;
  char *p = NIL;
  char fname[MYMAXNAMLEN], targrulename[MYMAXNAMLEN];
  register int i;
  Bool prerequisites_available = TRUE;

  /*
   * Find and return the command script of the applicable 
   * implicit dependency for "target".
   */

  if (!*targ)
    return ((struct cmds*) NIL);

  for(i = 0; i <= lastrule; i++) {
    if (implicit_suffs[i] == -1)
      continue;
    (void) strcpy (fname, targ);
    p = rindex (fname, '.');
    
    prerequisites_available = TRUE;
    /* build source name */
    if (p != NIL)
      *p = '\0';   /* p = suffix of target */
    if (p != NIL)
      (void) strcpy (targrulename, "%.");
    else
      (void) strcpy (targrulename, "%");
    if (p != NIL)
      (void) strcat (targrulename, p + 1);
    
    if (strcmp (targrulename, stdruletab[implicit_suffs[i]]->name) == 0) {
      /*
       * We have found an implicit rule that matches our target.
       * Now, construct the implicit dependent object(s) name(s)
       * by substituting the '%' character with the filename-stem
       * of targ. Then, see if a corresponding object can be located
       * or derived.
       */
      int j;
      for (j = 0; get_dep (stdruletab[implicit_suffs[i]], j); j++) {
	Bool object_derivable, object_exists;
	(void) strcat (fname, 
		       suffix (get_dep (stdruletab[implicit_suffs[i]], j)));
	object_derivable = (Bool) get_target (fname);
	object_exists = locate_object (fname, SOURCE);
	prerequisites_available = 
	  prerequisites_available && ( object_derivable || object_exists);
	
	/* reset the filename prefix */
	if (p != NIL)
	  *p = '\0';
	else
	  (void) strcpy (fname, targ);
      } /* end for */
      if (prerequisites_available)
	return stdruletab[implicit_suffs[i]]->cmdlist;
    } /* end if (strcmp (targrulename, stdruletab[implicit_suffs[i]].. */
  } /* end for (i <= lastrule ) */ 

  return (struct cmds *) NIL;
}

produce()
{
  register int k = 0;
  char *comm;
  BKey produced_object;
  struct selection_rules *initial_selection = sel_name_to_rule ("-STD-");

  shape_command = FALSE;
  if(confid) {
    if (!get_target (cfname))
      errexit(35,cfname);
  }
  if (cmdtargets[0] == NIL) {
    /* no targets on commandline */
    if (get_target (".DEFAULT"))
      comm = default_targets;
    else
      comm = firsttarget;
  }
  else
    comm = cmdtargets[k++];

  if ((nostdfile == TRUE) && (fileflg == FALSE) && (cmdtargets[0] == NIL))
    errexit(11,NIL);

  if(confid)
    comm = cfname;
  
  if (!rebuildflg) {
    if (ruleflg) {
      if (sel_name_to_rule (ruleset))
	initial_selection = sel_name_to_rule (ruleset);
      else
	errexit(32,ruleset);
    }
  }
  else
    initial_selection = sel_name_to_rule (rbrule);
  
  if (!rebuildflg) {
    Bool build_success = TRUE;
    while (comm != NIL)	{
      Bool spin_success;
      depth = 0;
      spin_success = try_to_make_target (comm, initial_selection, 
					 TRUE, &produced_object);
      if (spin_success && !reallydone && !selectflg && !notfoundflg)
	printf("shape - `%s' is up to date\n", comm);
      else if (!spin_success)
	warning (2, comm);
      
      build_success = build_success && spin_success;
      if (comm != firsttarget)
	comm = cmdtargets[k++];
      else
	comm = NIL;
    }
  }
  else {
    Bool build_success;
    depth = 0;
    build_success = try_to_make_target (rbtarg, initial_selection, TRUE,
			       &produced_object);
      
    if (build_success && !reallydone && !rebuildflg && 
	!selectflg && !notfoundflg)
      printf("shape - `%s' is up to date\n", rbtarg);
    else if (reallydone)
	printf("shape - `%s' rebuilt from confid\n", rbtarg);
    else if (!build_success)
      warning (2, rbtarg);
  }
}

static Bool try_to_make_target (targ, sr, force, made_object_key) 
     char *targ;
     struct selection_rules *sr;
     Bool force;
     BKey *made_object_key;
{
  TargetCode make_target();
  char messg[80];

  switch (make_target (targ, sr, made_object_key)) {
  case Ok:
    return TRUE;
  case Fail:
    return FALSE;
  case Abort:
    if (force) {
      if (goflg) {
	(void) sprintf (messg, "shape - don't know how to shape %s",
			targ);
	warning (0, messg);
	return FALSE;
      }
      errexit (3, targ);
    }
    else
      return FALSE;
  }
  return FALSE;
}

#define IMPLICIT 0
#define EXPLICIT 1

static char *cooked_dep (current, base, nth, depkind)
     struct rules *current;
     char *base;
     int nth, depkind;
{
  static char curdep[MYMAXNAMLEN];
  char *this_dependent, *point;

  if (this_dependent = get_dep (current, nth)) {
    if (depkind == IMPLICIT) {
      (void) strcpy (curdep, base);
      point = rindex (curdep, '.');
      if (point != NIL)
	*point = '\0';
      (void) strcat(curdep, suffix (this_dependent));
    }
    else 
      (void) strcpy (curdep, this_dependent);
  }
  else
    *curdep = '\0';
  return curdep;
}

static TargetCode make_target (targ, sr, made_object_key)
     char *targ;
     struct selection_rules *sr;
     BKey *made_object_key;
{
  register struct rules *current;
  struct rules *implicit_dep;
  static char lastcurdep[MYMAXNAMLEN];
  char curdep[MAXNAMLEN], lselrule[64], 
  lvar[64], lvarname[64];
  char path1[MYMAXNAMLEN];
  char *point = NIL, *srcname, *xxx, *this_dependent;
  char *prim_deps[MAXDEPS];
  Bool err_happ = FALSE, todo = FALSE, test = FALSE, t1 = FALSE;
  Bool lbusy_done = FALSE, var_already_active = FALSE, targ_exists;
  Bool mind_primary_dependent;
  BKey bkey;
  DepQ *new_DepQ(), *deriv_key_deps = new_DepQ();
  int dep = 0, curi = 0, len = 0, var_depth = -1, pdi;

  made_object_key->bk_isdefined = FALSE;
  if (already_in_done_list (targ)) {
    drop_dependent_queue (deriv_key_deps);
    return Ok;
  }

  if (depth > MAXDEPTH)  {
    drop_dependent_queue (deriv_key_deps);
    warning (7, targ);
    return Fail;
  }

  depth++;
  if (!(current = get_target (targ))) {
    /* 
     * We don't have a rule to produce "targ", so it must be
     * a source object. If not - give up !
     */
    if (!locate_object (targ, SOURCE)) {
      depth--;
      drop_dependent_queue (deriv_key_deps);
      return Abort;
    }
    else {
      if (strcmp (targ, lastcurdep)) {
	if (try_to_bind_version (targ, sr, BIND_IT, &bkey)) {
	  (void) strcpy (lastcurdep, targ);
	  depth--;
	  drop_dependent_queue (deriv_key_deps);
	  return Ok;
	}
	else {
	  if (D_flag)
	    (void) D_debug (targ, NIL, NIL);
	  depth--;
	  drop_dependent_queue (deriv_key_deps);
	  return Fail;
	}
      }
      else {
	depth--;
	drop_dependent_queue (deriv_key_deps);
	return Fail;
      }
    }
  }
  
  /**/
  /* ASSERT: current != NIL ; "targ" is name of a derived object */
  /**/

  dep = 0;
  
  lbusy_done = busy_done;
  
  /*
   * Now, all the dependents of the current target are examined and 
   * requested.
   */
  if (this_dependent = get_dep (current, dep)) {
    if (sel_name_to_rule (this_dependent)) {
      if((!ruleflg) || (depth > 1)) {
	sr = sel_name_to_rule (this_dependent);
	dep++;
      }
      else
	dep++;
    }

    while (is_varname (this_dependent = get_dep (current, dep))) {
      (void) strcpy (lvarname, this_dependent);
      if (strcmp (lvarname, "+")) {
	if ((xxx = index (lvarname, '+')) != NIL) {
	  xxx++;
	  (void) strcpy (lvarname, xxx);
	}
	(void) strcpy (lvar, lvarname);
	curi = 0;
	while (strcmp (curvar[curi], "")) {
	  if (!strcmp (curvar[curi], lvarname))
	    var_already_active = TRUE;
	  curi++;
	  if (curi == MAXACTVAR)
	    errexit (37,NIL);
	}
	if (!var_already_active) {
	  if ((curvar[curi] = 
	       malloc ((unsigned) (strlen (lvarname) + sizeof (char)))) == NIL)
	    errexit (10,"malloc");
	  variants_active = curi;
	  var_depth++;
	  (void) strcpy (curvar[curi], lvarname);
	  (void) attrvar (lvar, NIL, (Af_set *) NIL);
	}
	else
	  var_already_active = FALSE;
      }
      dep++;
    }
  }
  
  (void) strcpy (curdep, get_dep (current, dep) ? 
		 get_dep (current, dep++) : "" );
    
  /*
   * skip bogus variant activations (coming from empty expanding var macros)
   */
  while (!strcmp (curdep, "+"))
    if (get_dep (current, dep))
      (void) strcpy (curdep, get_dep (current, dep++));
    else
      *curdep = '\0';

  if (is_pattern (current->name)) {
    dep--;
    (void) strcpy (curdep, cooked_dep (current, targ, dep++, IMPLICIT));
  }
  else if ((current->cmdlist == (struct cmds *)NIL) ||
	   (current->cmdlist->command == (char *)NIL))
    add_defaults (targ, current);

  while (*curdep) {
    struct rules *dep_is_derivable = get_target (curdep);
    Bool dep_exists = locate_object (curdep, ALL), 
    current_target_exists;
    
    if (!strcmp (curdep, lastcurdep))
      goto next_dep;
      
    if (!dep_is_derivable && dep_exists && (strcmp (curdep, lastcurdep))) {
      (void) strcpy (lastcurdep, curdep);
      (void) try_to_bind_version (curdep, sr, BIND_IT, &bkey);
      if (bkey.bk_isdefined)
	append_dependent (&bkey.bk_key, deriv_key_deps);
      else {
	depth--;
	return Abort;
      }
    }
    else {
      if (try_to_make_target (curdep, sr, TRUE, &bkey)) {
	if (error_happened) {
	  err_happ = TRUE;
	  error_happened = FALSE;
	}
	if (bkey.bk_isdefined)
	  append_dependent (&bkey.bk_key, deriv_key_deps);
      }
      else {
	depth--;
	cl_variants (var_depth, curi);
	drop_dependent_queue (deriv_key_deps);
	return Fail;
      }
    }

  next_dep:
    (void) strcpy (curdep, cooked_dep (current, targ, dep++,
				       is_pattern (current->name) ?
				       IMPLICIT : EXPLICIT));
  } /* end while (*curdep) */

  /*
   * At this point all dependents of "targ" are either bound to 
   * an appropriate source version or have been derived. Now we
   * can see whether "targ" needs to be made.
   */

  mark_all_done (current);
    
  if (err_happ) {
    drop_dependent_queue (deriv_key_deps);
    cl_variants (var_depth, curi);
    depth--;
    return Fail;
  }

  if (locate_object (targ, ALL) &&
      try_recache (targ, make_derivation_key (current, deriv_key_deps), 
		   current, made_object_key)) {
    drop_dependent_queue (deriv_key_deps);
    drop_restorelist ();
    cl_variants (var_depth, curi);
    depth--;
    return Ok;
  }
  else if (execute_commands (current, targ, deriv_key_deps,
			     made_object_key)) {
    drop_dependent_queue (deriv_key_deps);
    drop_restorelist ();
    cl_variants (var_depth, curi);
    depth--;
    return Ok;
  }
  else {
    drop_dependent_queue (deriv_key_deps);
    cl_variants (var_depth, curi);
    depth--;
    return Fail;
  }
}

static Bool try_recache (do_name, do_key, dep_rule, key_from_cache)
     char *do_name, *do_key;
     struct rules *dep_rule;
     BKey *key_from_cache;
{
  Af_set bset;
  Af_attrs buf;
  Af_key bkey, key1, restorekey;
  int object_is_cached, busy_version_exists;
  char type[MYMAXNAMLEN], sysp[MYMAXNAMLEN], *retrv_attr;
  Bool object_exists;

  key_from_cache->bk_isdefined = FALSE;
  if (!locate_object (do_name, ALL))
    return FALSE;

  if (touchflg)
    return FALSE;
  
  /*
   * This is handling of the special case, when a target (pseudo
   * or real) depends on nothing but a commandlist. In this case
   * reproduction of the target must be performed unconditionally.
   * The resulting target (in case it is a file) is stored in the 
   * BPOOL (should be avoided) with an empty attribute. We have to
   * avoid restoration from BPOOL and have to set the existing 
   * file to non-current.
   */
  if ((do_key == NIL) || (*do_key == '\0')) {
    if ((dep_rule->deplist == (char *)NIL) && 
	(dep_rule->cmdlist != (struct cmds *)NIL))
      return FALSE;
  }

  af_initattrs(&buf);
  
  buf.af_gen = AF_BUSYVERS;
  buf.af_rev = AF_BUSYVERS;

  (void) strcpy (type, af_aftype (do_name));
  (void) strcpy (sysp, af_afpath (do_name));
  if(sysp[0] != '\0')
    (void) strcpy (buf.af_syspath, sysp);
  else
    (void) strcpy (buf.af_syspath, curvpath[0]);

  (void) strcpy (buf.af_name, af_afname (do_name));
  (void) strcpy (buf.af_type, af_aftype (do_name));

  if (forceflg) {
    if (is_in_forcelist (do_name, type)) {
      if (D_flag)
	printf ("shape - must reshape %s (caused by -force)\n", do_name);
      return FALSE;
    }
  }

  busy_version_exists = (af_getkey (buf.af_syspath, af_afname (do_name),
				    af_aftype (do_name), AF_BUSYVERS, 
				    AF_BUSYVERS, &key1) > -1);

  if (busy_version_exists && (retrv_attr = af_rudattr (&key1, ATTRNAME))) {
    if (strcmp (retrv_attr, do_key) == NULL) {
      /*
       * Double-check, if this is really the busy version we need !
       * If the derived object has been rederived with other tools
       * than shape (e.g. make), the derived object's contents may 
       * have changed but the derivation key is still the same...
       * To make things sure we check the busy version's mtime against
       * the mtime that was stored in the cachekey when the object was 
       * created..
       */
      char *ap = at_rcachekey (&key1);
      Af_attrs busy_attrs;
      if (af_gattrs (&key1, &busy_attrs) > -1) {
	char *auxp = index (ap, '.');
	if (ap && auxp) *auxp = '\0';
	if (busy_attrs.af_mtime == atol (ap)) {
	  key_from_cache->bk_key = key1;
	  key_from_cache->bk_isdefined = TRUE;
	  udafree (&busy_attrs);
	  free (retrv_attr);
	  free (ap);
	  return TRUE;
	}
      }
      if (ap) free (ap);
    }
  }
  
  /* 
   * ASSERT: Either there is no un-cached busyversion, or it has not
   *         the attributes we're looking for.
   */

  buf.af_gen = AF_NOVNUM;
  buf.af_rev = AF_NOVNUM;

  if ((retrv_attr = malloc ((unsigned)(strlen (do_key) + 
				       strlen (ATTRNAME) + 1))) == NIL)
    errexit(10,"malloc");

  (void) strcpy (retrv_attr, ATTRNAME);
  (void) strcat (retrv_attr, "=");
  (void) strcat (retrv_attr, do_key);

  buf.af_udattrs[0] = retrv_attr;
  buf.af_udattrs[1] = NIL;

  if ((object_is_cached = af_bpfind (&buf, &bset)) == -1) 
    errexit (10, "af_bpfind");
  
  if (!object_is_cached) {
    if (af_dropset (&bset) == -1)
      errexit (10, "af_dropset");
      free (retrv_attr);
      if (D_flag)
	(void) D_debug (do_name, type, do_key);
      if (busy_version_exists && (af_dropkey (&key1) == -1))
	af_perror ("try_recache");
      return FALSE;
  }
  else {
    if (af_setgkey (&bset, 0, &bkey) == -1)
      errexit (10,"af_setgkey");
    if (!noexflg) {
      if (af_restore (&bkey, &restorekey) == -1)
	errexit (10,"af_restore");
      printf ("... %s%s%s[%s] restored from derived object cache\n",
		  buf.af_name, (buf.af_type && buf.af_type[0]) ? "." : "", 
		  buf.af_type ? buf.af_type : "", at_rcachekey (&bkey));
    }
    else
      printf ("... %s%s%s[%s] found in derived object cache (not restored)\n",
	      buf.af_name, (buf.af_type && buf.af_type[0]) ? "." : "",
	      buf.af_type ? buf.af_type : "", at_rcachekey (&bkey));

    key_from_cache->bk_key = bkey;
    key_from_cache->bk_isdefined = TRUE;
    if (af_dropset (&bset) == -1)
      errexit (10, "af_dropset");
    if (buf.af_udattrs[0])
      free (buf.af_udattrs[0]);
    free (retrv_attr);
      return TRUE;
    }
}

static Bool execute_commands (current, rel_dep, q, made_key)
     struct rules *current;
     char *rel_dep;
     DepQ *q;
     BKey *made_key;
{
  register struct cmds *curcmd;
  char *expcmd, x_command[MAXCMDLENGTH], fname[MYMAXNAMLEN],
       attr[MAXATTRLEN], command_processor[MAXNAMLEN];
  struct timeval touch_time;
  struct timezone tz;

  attr[0] = '\0';
  if (rel_dep) 
    (void) strcpy (fname, rel_dep);

  if (current)
    curcmd = current->cmdlist;

  if (curcmd) {
    (void) gettimeofday (&touch_time, &tz);
    (void) strcpy (command_processor, expandmacro ("$(SHELL)"));
    while (curcmd) {
      if (curcmd->command) {
	no_comm_subst = TRUE;
	(void) strcpy (x_command, expandmacro (curcmd->command));
	no_comm_subst = FALSE;
	if ((expcmd = malloc (MAXCMDLENGTH)) == NIL)
	  errexit(10,"malloc");
	(void) strcpy (expcmd, expand_command (x_command, current, fname));
	execute (expcmd, command_processor);
	free (expcmd);
      }
      else
	break;
      curcmd = curcmd->nextcmd;
    }

    if (simple_done) {
      mark_all_done (current);
      strcpy (attr, make_derivation_key (current, q));
      simple_done = FALSE;
    }
    save_targets (current, fname, attr, made_key, &touch_time);
  }

  cleanup_links (link_reg);
  free_linklist ();
  link_reg = (struct linkreg *) NIL;

  return TRUE;
}

int execute(cmd, itp) char *cmd, *itp; {
  int retcode = 0;
  Bool ignflg = FALSE, silflg;
  char *rc, *free_cmd, *old_cmd;

  old_cmd = cmd;
  if (!noretrvflg)
    (void) restore_all_vers ();
  silflg = silentflg;
  free_cmd = cmd;
  while (isspace(*cmd)) cmd++;
  
  if (noexflg && !shape_command && !notfoundflg) {
    if(*cmd == '@')
      cmd++;
    if(*cmd == '-')
      cmd++;
    printf("%s\n", cmd);
    (void) fflush(stdout);
    reallydone = TRUE;
  }
  else {
    if (*cmd == '@') {
      *cmd = ' ';
      silflg = TRUE;
      if (*(cmd+1) == '-') {
	*(cmd+1) = ' ';
	ignflg = TRUE;
      }
    }
    if (*cmd == '-') {
      *cmd = ' ';
      ignflg = TRUE;
    }
    else
      ignflg = FALSE;

    /*    printf("malloc_verify: %d\n", malloc_verify()); */

    if (!silflg || ((noexflg) && (!notfoundflg))) {
      printf("%s%s\n", noexflg ? "" : "shape - executing: ", cmd);
      (void) fflush(stdout);
    }

    if (!(touchflg || noexflg) || shape_command) {
      reallydone = TRUE;
      retcode = at_callcmd (itp, cmd);
      if (retcode < 0) {
	switch (retcode) {
	case CMDPROC_EMPTY:
	  logerr ("No Shell");
	  break;
	case NO_MORE_CORE:
	  logerr ("Not enough memory");
	  break;
	case FORK_FAILED:
	  logerr ("Couldn't fork");
	  break;
	case PIPE_FAILED:
	  logerr ("Couldn't open pipe to command interpreter");
	  break;
	case WAIT_ERROR:
	  logerr ("Couldn't wait for command");
	  break;
	case EXEC_FAILED:
	  logerr ("Unable to load command interpreter");
	  break;
	case CHILD_KILLED:
	  logerr ("Child process died from an accident");
	  break;
	case WRITE_FAILED:
	  logerr ("Command interpreter doesn't read");
	  break;
	case NO_PROGRAM:
	  logerr ("Couldn't find command interpreter");
	  break;
	}
      }
      simple_done = TRUE;
      if (retcode != 0) {
	if(ignflg == FALSE) {
	  error_happened = TRUE;
	  error_occ = TRUE;
	}
	if ((rc = malloc (10 * sizeof(char))) == NIL)
	  errexit(10,"malloc");
	(void) sprintf (rc, "%d\0", wretcode(&retcode)); 
	if ((ignflg == FALSE) && (goflg == FALSE))
	  errexit(13,rc);
      }
    }
  }
  if (old_cmd != free_cmd)
    free(free_cmd);
  shape_command = FALSE;
}


char *get_src_name(name)
     char *name;
{
  register int i;
  static char fname[MYMAXNAMLEN];
  register char *p;

  (void) strcpy(fname,name);
  if ((p = rindex(fname,'.')) != NIL)
    {
      for (i = 0; implicit_suffs[i] != -1; i++)
	{
	  *p = '\0';
	  if (!strcmp(stdruletab[implicit_suffs[i]]->name+2,p+1))
	    {
	      (void) strcat(fname,stdruletab[implicit_suffs[i]]->firstdep+1);
	      if (locate_object(fname,1))
		return(fname);
	    }
	}
      if(implicit_suffs[i] == -1)
	return(NIL);
    }
  /*NOTREACHED*/
  return(NIL);
}
       
void cl_variants(vdepth,vcuri)
     int vdepth,vcuri;
{
  register int vardepi;
  for(vardepi = vdepth; vardepi >= 0; vardepi--)
    {
      de_activate(curvar[vcuri-vardepi]);
      (void) strcpy(curvar[vcuri-vardepi],"");
      (void) reset_pathlist();
    }
}

void de_activate(c_var_name)
     char *c_var_name;
{
  register int i = 0, j;
  extern struct varclass variantClasses[];
  extern struct vardef variantDefs[];

  while(variantClasses[i].name)
    {
      if((variantClasses[i].active != -1) &&
	 (!strcmp(variantClasses[i].variants[variantClasses[i].active],c_var_name)))
	variantClasses[i].active = -1;
      j = 0;
      while (variantDefs[j].name)
	{
	  if(!strcmp(variantDefs[j].name,c_var_name))
	    {
	      if(variantDefs[j].vpath != NIL)
		{
		  /*
		   * The following block (kind of) fixes a bug
		   * that leads to eventual corruption of the curvpath
		   * variable. However, the fix introduces a new bug:
		   * the vpath element of a de_activated variant is
		   * completely wiped out, even if another, still
		   * active variant has the same vpath. We hope that
		   * this case is unlikely.
		   */
		  register int yucc, urgh; /* yes, YUCC! URGH! */

		  for (yucc = 0; curvpath[yucc] && (yucc < MAXVPATH); yucc++) {
		    if (strcmp (variantDefs[j].vpath, curvpath[yucc]))
		      continue;
		    if (yucc == MAXVPATH-1) {
		      curvpath[yucc] = NIL;
		    }
		    else {
		      for (urgh = yucc+1; curvpath[urgh-1]; urgh++)
			curvpath[urgh-1] = curvpath[urgh];
		      yucc--;
		    }
		  }
		}
	    }
	  j++;
	}
      i++;
    }
}
      
void reset_pathlist()
{
  extern char *pathlist[][2];
  extern int lastpath;
  register int i;
  for (i = 1; pathlist[i][0] != NIL; i++)
    {
      pathlist[i][0] = NIL;
      pathlist[i][1] = NIL;
      lastpath = 1;
    }
  if (pathlist[0][1] != NIL)
    {
      if (!strcmp(pathlist[0][1],"&$"))
	{
	  pathlist[0][0] = NIL;
	  pathlist[0][1] = NIL;
	  lastpath = 0;
	}
    }
}

void mark_all_done(cur)
     struct rules *cur;
{
  struct rules *c;
  int i;
  if (is_pattern (cur->name))
    return;
  if(cur->done == rec_do_depth)
    return;
  cur->done++;
  i = cur->done;
  c = cur->next;
  while((c != (struct rules *) NIL) &&
	(c->done < i))
    {
      if(simple_done)
	c->done++;
      else
	{
	  if(locate_object (c->name, SOURCE))
	    c->done++;
	}
      c = c->next;
    }
}
