/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * util.c
 *
 * $Header: util.c[3.25] Tue Mar 10 18:54:12 1992 axel@cs.tu-berlin.de accessed $
 */
#ifndef lint
static char *ATFSid = "$Header: util.c[3.25] Tue Mar 10 18:54:12 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

/*LINTLIBRARY*/
#include <stdio.h>
#include <atfs.h>
#include "atfsapp.h"
/* #include "project.h" now in atfsapp.h */
/* #include "locks.h" now in atfsapp.h */
#ifndef W_OK			/* W_OK is defined in unistd.h on SYSV */
				/* machines (including TPIX) */
#include <sys/file.h>
#endif

extern unsigned int options;

jmp_buf here;

ask_confirm (s, def) char *s, *def; {
  /*
   *  returns true if the answer is equivalent to 'def' (assumption)
   */
  char strbuf[MSGLEN], answer[MSGLEN], *cp;

  if (s == (char *)NULL) return TRUE;
  if (!isatty (fileno (stdin))) return TRUE;
  (void)setjmp (here);
#ifdef SIGCONT
  CatchCont ();
#endif
  (void)fflush (stdin);
  printf ("%s [%s] ", s, def);
  strbuf[0] = '\0';
  answer[0] = '\0';
  (void)gets (strbuf);
#ifdef SIGCONT  
  UnCatchCont ();
#endif
  (void)sscanf (strbuf, "%s", answer);
  if (answer[0] == '\0') return TRUE; /* assumption acknowledged */
  cp = answer;
  while (*cp ? (*cp++ |= ' ') : 0); /* make sure answer is lowercase */
  return !strncmp (def, answer, min(strlen(def), strlen(answer)));
}

/*ARGSUSED*/
getsyspath (path, proj, syspath, opath, name) 
     char *path, *syspath, *opath, *name; 
     Project *proj;
/*
 * Normally splits path-prefix and filename-part. If the project structure
 * specifies an explicit syspath (which could be different from the 
 * actual path-prefix) it will be returned in syspath. The path-prefix
 * will be returned in opath.
 */
{
  char *cpt;

  if (cpt = rindex (path, '/')) {
    (void)strncpy (opath, path, cpt - path);
    opath[cpt-path] = '\0';
    (void)strcpy (name, cpt+1);
  }
  else {
    opath[0] = '\0';
    (void)strcpy (name, path);
  }
  (void)strcpy (syspath, opath); /* this is going to be more complex */
}

#define nxt(s) (s = (*(s+strlen(s)+1) != '\0') ? s+strlen(s)+1 : NULL)

/*ARGSUSED*/
char *getattr (attrfile, proj, type, op) 
     char *attrfile, *type ; Project *proj; int op; {
       /* 
	* in initial state, getattr parses all available attribute
	* information, i.e. a user supplied attribute file and the
	* common project specific attribute specifications. The information
	* is kept in static memory. Subsequent calls to getattr with
	* op = NEXT yields the next attribute for the specified document
	* type. If op is REWIND, the first attribute for the given type
	* is delivered. If no (more) attribute is found, getattr returns
	* a NULL pointer.
	*/
       static int isparsed = FALSE;
       static char *currattr, *attrbuf;
       char messg[MSGLEN], *malloc();
       struct stat statbuf;
       register int i;
       FILE *atfil;
       
       if (isparsed) {
	 if (op == NEXT)
	   return (currattr) ? nxt(currattr) : currattr;
	 else if (op == REWIND) {
	   currattr = attrbuf;
	   return currattr;
	 }
       }
       else { /* we've to read the stuff first */
	 if ((atfil = fopen (attrfile, "r")) == NULL) {
	   (void)sprintf (messg, "No attribute file %s.", attrfile);
	   logerr (messg);
	   attrbuf = NULL;
	 }
	 else {
	   if (fstat (fileno(atfil), &statbuf) < 0) {
	     perror ("couldn't stat.");
	     return (char *)NULL;
	   }
	   attrbuf = malloc ((unsigned)statbuf.st_size+1); 
	   /* leave space for terminating nullbyte */
	   if (!attrbuf) {
	     logerr ("Not enough memory for attribute table");
	   }
	   else {
	     bzero(attrbuf, (int) (statbuf.st_size+1));
	     (void)fread (attrbuf, sizeof (char), 
			  (Size_t)statbuf.st_size, atfil);
	     for (i=0; i < statbuf.st_size; i++)
	       if (attrbuf[i] == '\n')
		 attrbuf[i] = '\0';
	     attrbuf[statbuf.st_size + 1] = '\0';
	   }
	 }
	 currattr = attrbuf;
	 isparsed = TRUE;
	 return currattr;
       }
       return FALSE;
     }

     int at_setuda (key, attrdef) Af_key *key; char *attrdef; {
       char *eq, *index(), *attrbuf;
       int add = FALSE;

       if ((attrbuf = (char *)malloc (strlen (attrdef) + 1)) == 
	   (char *)NULL)
	 return 0;
       strcpy (attrbuf, attrdef);
       eq = index (attrbuf, '=');
       if (eq) {
	 if (*(eq-1) == '+') {
	   (void)strcpy (eq-1, eq);
	   add = TRUE;
	 }
       }
       else {
	 logerr ("WARNING: setattr -- illegal attribute format");
	 goto failout;
       }
       if (add) {
	 if (af_sudattr (key, AF_ADD, attrbuf) == -1) {
	   af_perror ("at_setuda: af_sudattr (ADD)");
	   goto failout;
	 }
       }
       else { /* reset attribute value */
	 if (af_sudattr (key, AF_REPLACE, attrbuf) == -1) {
	   if (af_sudattr (key, AF_ADD, attrbuf) == -1) {
	     af_perror ("at_setuda: af_sudattr (REPLACE, ADD)");
	     goto failout;
	   }
	 }
       }
       free (attrbuf);
       return 1;
     failout:
       free (attrbuf);
       return 0;
     }


static  char *AtfsNames[] = { "AtFS", "AFS", (char *)0 };

checkForAtfsDirs (ac, av) char **av; {
  /*
   * This function is a hack. It's used to find out if AtFS-related 
   * actions will succeed by checking for the mere existence of an
   * "AtFS" entry in each of the pathnames in av. All this is much 
   * too "low-level" here but... 
   * Much more could be checked here: is AtFS writable ? Does - in case
   * "AtFS" is a (possibly faked) symbolic link - "AtFS" point at
   * something existing, writable ? This could be checked recursively.
   * For now it's a rather crude function that shall be portable among
   * all supported architectures.
   */

  register int i, j, rc;
  int hit = 0;
  struct stat statbuf;
  char *c, checkfn[MAXPATHLEN], messg[MAXPATHLEN + 32];

  rc = 0;
  for (i = 0; i < ac; i++) {
    strcpy (checkfn, av[i]);
    for (j = 0, hit = 0; AtfsNames[j]; j++) {
      c = rindex (checkfn, '/');
      if (c)
	(void)sprintf (++c, AtfsNames[j]);
      else {
	strcpy (checkfn, "./"); 
	strcat (checkfn, AtfsNames[j]);
      }
      if (fail (stat (checkfn, &statbuf))) 
	continue;
      else {
	hit = 1;
	break;
      }
    }
    if (hit)
      continue;
    c = rindex (checkfn, '/');
    *(c+1) = '\0';
    (void) strcat (checkfn, AtfsNames[0]);
    (void)sprintf (messg, "Couldn't find database %s.", checkfn);
    logerr (messg);
    rc++;
  }
  return rc;
}


mylock (key, proj) Af_key *key; Project *proj; {
  Af_user *locker;
  Uid_t myuid;
  char messg[MSGLEN], *lockerid();
  extern char *at_keygetbndvers();
  
  myuid = (Uid_t)geteuid();
  if (!locked(locker = vc_testlock(key))) {
    if (firmlocking (proj)) {
      (void)sprintf (messg, 
		     "You must lock %s before saving (firm locking required).",
		     at_keygetbndvers(key, 1));
      logerr (messg);
      return FALSE;
    }
    else { /* no firm locking */
      if (lockeruid (vc_lock(key, myuid)) != myuid) {
	af_perror ("cannot lock archive");
	return FALSE;
      }
      return TRUE;
    }
  }
  else { /* there was some lock set */
    if (lockeruid(locker) != myuid) {
      (void)sprintf (messg, "%s already locked by %s.",
		     at_keygetbndvers(key,1),
		     lockerid (locker));
      logerr (messg);
      return FALSE;
    }
    return TRUE;
  }
}

firmlocking (proj) Project *proj; {
  if (proj) {
    return TRUE;
  }
  else {
    return FALSE;
  }
}

#define owner(p) (0100 * p)
#define group(p) (010 * p)
#define world(p) (p)

afaccess (fkey, perm) Af_key *fkey; {
  short itisus;
  Af_attrs thisattrs;
  char thishost[MAXHOSTNAMELEN];

  if (!fkey) return FALSE;

  if (fail(af_gattrs (fkey, &thisattrs))) {
    af_perror ("af_gattrs (access determination failed).");
    return FALSE;
  }
  (void)gethostname (thishost, MAXHOSTNAMELEN);
  if (!strcmp (thishost, thisattrs.af_owner.af_userhost)) {
    itisus = !strcmp (getpwuid((int)geteuid())->pw_name, 
		      thisattrs.af_owner.af_username);
  if ((thisattrs.af_state != AF_BUSY) && (perm & W_OK)) return FALSE;
  if (itisus) {
    return TRUE; /* there's no chmod for archived files. always grant acc. */
  }
  return thisattrs.af_mode & world(perm);
  }
  else return TRUE;
}

/*ARGSUSED*/
myproject (proj) Project *proj; {
  /*
   * returns TRUE if we are project administrator
   */
  return TRUE; /* until project support is implemented ... */
}

mkvstring (version, key) char *version; Af_key *key; {
  int g;
  char buf[16];
  register char *t;

  t = af_rtype (key);
  t = t ? t : "";
  (void)sprintf (version, "%s%s%s[",
	   af_rname (key),
	   t[0] ? "." : "", t);
  if ((g=af_rgen (key)) < 0) {
    (void)strcat (version, "busy]");
  }
  else {
    (void)sprintf (buf, "%d.%d]", g, af_rrev (key));
    (void)strcat (version, buf);
  }
}

char *vnum (key) Af_key *key; {
  int _gen, _rev;
  static char vstr[20];

  _gen = af_rgen (key);
  _rev = af_rrev (key);
  
  if (af_rstate (key) == AF_BUSY)
    (void)strcpy (vstr, "busy");
  else
    (void)sprintf (vstr, "%d.%d", _gen, _rev);
  return vstr;
}

udafree (attrbuf) Af_attrs *attrbuf; {

  if (attrbuf->af_udattrs[0])
    free (attrbuf->af_udattrs[0]);
}
