/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * citeattr.c
 *
 * $Header: citeattr.c[1.26] Wed Feb  5 18:10:39 1992 axel@cs.tu-berlin.de accessed $
 */

/*LINTLIBRARY*/
#ifndef lint
static char *ATFSid = "$Header: citeattr.c[1.26] Wed Feb  5 18:10:39 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include <sys/param.h>
#include <grp.h>
#include <stdio.h>
#include <atfs.h>
#include "atfsapp.h"
#include "anames.h"

#define RDEPTH 10

char *st_table[] = {
  "busy", "save", "proposed", 
  "published", "accessed", "frozen", 
  (char *)0 
  };

static int doXPand = TRUE;
static int destIsFile = TRUE; 
/* this variable controls, whether dest is a FILE-pointer or a
 * string-pointer -- urgh!
 */

WriteXPand (buf, bufcnt, dest, curkey) 
     char *buf; int bufcnt; FILE *dest; Af_key *curkey; {
/*
 *  WriteXPand scans the char buffer 'buf' to the extent of bufcnt
 *  for strings of the form '$__attribute_name'. If such a string
 *  is found, the buffer contents up to the character preceding the
 *  first '$' will be sent to the destination output 'dest'.
 *  If an attribute with name 'atttribute_name' is set for the current
 *  attribute file, the citation-string will be substituted by the value
 *  of that attribute. Output of 'buf' contents resumes with the first 
 *  character after the blank delimiting the 'attribute_name'.
 *  There are two built-in pseudo-attributes, 'Header' and 'Log' which
 *  are substituted by a version header in RCS style or a log-history
 *  respectively. Lines of the log-history are preceded by a 'comment
 *  leader' symbol, defined as user-defined attribute CLEAD.
 *  Header and Log are ended by newline characters.
 */
       short stat=0, incite=0, gotattrs=0;
       int string_end;
       char attrcitebuf[128];
       Af_attrs allattrs;
       register int i;
       char *attrname = attrcitebuf+3,
       *spt, *ept;

       i = 0;

       spt = ept = buf;

       while (i < bufcnt) {

	 switch (buf[i]) {
	 /* scan attribute citation marker */
	 case '$':
	   if (stat) ept = &(buf[i]);
	   stat = 1;
	   attrcitebuf[0] = '$';
	   break;
	 case '_':
	   switch (stat) {
	   case 0:
	     ept++;
	     break;
	   case 1: 
	   case 2:
	     attrcitebuf[stat++] = '_';
	     break;
	   }
	   break;
	 default:
	   if (stat) 
	     ept = &(buf[i+1]);
	   else 
	     ept++;
	   stat = 0;
	   break;
	 }

	 if (stat == 3) { /* lets see if there's an attribute citation */
	   /* assertion: i is index of 2nd '_' */
	   if ((i < bufcnt-1) && (buf[i+1] != ' ')) { 
	     stat = 0; 
	     /* ... yes, there seems to be one */
	     i++; incite = 0;
	     if (af_gattrs (curkey, &allattrs) < 0) {
	       af_perror ("af_gattrs");
	       return;
	     }
	     gotattrs = 1;
	     while ((!index (" \n\t$", buf[i])) && (i < bufcnt))
	       attrname[incite++] = buf[i++];
	     if (i < bufcnt) {
	       /* i points to first char after attribute name */
	       if (buf[i] == '$') { /* consider '$' part of attr-name */
		 attrname[incite++] = '$'; i++;
	       }
	       attrname[incite] = '\0';
	       /* write out everything up to beginning of cite_mark */
	       if (destIsFile)
		 (void) fwrite (spt, sizeof (*buf), ept - spt, dest);
	       else {
		 string_end = strlen ((char *)dest);
		 (void) strncat ((char *)dest, spt, ept - spt);
		 if (ept - spt) ((char *)dest)[string_end+(ept-spt)] = '\0';
	       }
	       spt = ept = &(buf[i]);
	       if (!substitute (attrname, curkey, &allattrs, dest))
		 if (destIsFile)
		   fputs (attrcitebuf, dest);
		 else
		   (void)strcat ((char *)dest, attrcitebuf);
	       incite = 0;
	     }
	     else {
	       attrname[incite] = '\0';
	       if (destIsFile)
		 (void) fwrite (spt, sizeof (*buf), ept - spt, dest);
	       else {
		 string_end = strlen ((char *)dest);
		 (void) strncat ((char *)dest, spt, ept - spt);
		 if (ept - spt) ((char *)dest)[string_end+(ept-spt)] = '\0';
	       }
	       spt = ept = &(buf[i]);
	       if (!substitute (attrname, curkey, &allattrs, dest))
		 if (destIsFile)
		   fputs (attrcitebuf, dest);
		 else
		   (void)strcat ((char *)dest, attrcitebuf);
	     }
	   }
	   else { /* blank after citemark or buffer exceeded */
	     if (destIsFile)
	       fputs ("$__", dest);
	     else
	       (void)strcat ((char *)dest, "$__");
	   }
	   i--;
	 }
	 i++;
       }
       /* Ok, we've had it -- send remaining chars to dest */
       if (destIsFile)
	 (void) fwrite (spt, sizeof (*buf), ept - spt, dest);
       else {
	 string_end = strlen ((char *)dest);
	 (void) strncat ((char *)dest, spt, ept - spt);
	 if (ept - spt) ((char *)dest)[string_end + (ept - spt)] = '\0';
       }
       if (gotattrs && allattrs.af_udattrs[0]) {
	 free (allattrs.af_udattrs[0]);
       }
     }


substitute (attrstr, afkey, afattrs, dest) 
     char *attrstr; Af_key *afkey; Af_attrs *afattrs; FILE *dest; {
       /* 
	* This procedure tries to substitute the occurrence of the 
	* given attribute name by the corresponding value stored with the 
	* attribute file version denoted by afkey. The substituted 
	* value is printed on dest. If 'attrname' actually is the name
	* of an attribute and the last character in the name is '$'
	* it will be deleted. In case that attrname is not a known
	* attributename, nothing happens and a value of 0, indicating
	* that no substitution took place, will be returned. Nonzero
	* return means successful substitution.
	*/
       char *ap, *p, attrname[128], clead[32], *note, *IsAStdAttr(), *cp,
            *getenv();
       register char *lp, *ep, *l;
       Af_attrs retbuf;
       Af_set kset;
       Af_key thiskey;
       int cgen, crev, tgen, setsz, title_printed = FALSE;
       register int k;

       static int rdepth = 0;

       if (! (attrstr && afkey && afattrs && dest))
	 return FALSE;

       (void) strcpy (attrname, attrstr);
       if (l = index (attrname, '$')) *l = '\0';
       if (ap = IsAStdAttr (attrname, afkey)) {
	 if (doXPand) {
	   if (strcmp (ap, "xpon")) {
	     if (destIsFile) {
	       fputs (ap, dest);
	       fflush (dest);
	     }
	     else
	       (void)strcat ((char *)dest, ap);
	     return TRUE;
	   }
	   else
	     return FALSE;  /* xpon will be preserved as full citation x-pr. */
	 }
	 else 
	  return FALSE;
       }
       if (!doXPand) return FALSE;

       if (strcmp (attrname, HEADER)) {
	 if (strcmp (attrname, LOG)) {
	   ap = af_rudattr (afkey, attrname);
	   if (ap > 0) {
	     if ((ap[0] == '^') || (ap[0] == '!')) {
	       char sbuf[NCARGS];
	       int old_dest;

	       sbuf[0] = '\0'; /* turn it into an initialized string */
	       old_dest = destIsFile;
	       destIsFile = FALSE;
	       WriteXPand (ap+1, strlen (ap+1), sbuf, afkey);
	       destIsFile = old_dest;
	       if ((ap[0] == '^') && (strlen (sbuf) < MAXPATHLEN) &&
		   ++rdepth < RDEPTH ? 
		   (try_substitute_file (sbuf, afkey, dest) || (--rdepth,0)) : 
		   (--rdepth,0)) --rdepth;
	       else if ((ap[0] == '!') && (strlen (sbuf) < NCARGS) &&
			++rdepth < RDEPTH ?
			(try_substitute_execution (sbuf, dest, afkey) || 
			 (--rdepth,0)) : (--rdepth,0)) --rdepth;
	     }
	     else {
	       if (++rdepth < RDEPTH) {
		 WriteXPand (ap, strlen(ap), dest, afkey);
		 --rdepth;
	       }
	       else {
		 --rdepth;
		 fputs (ap, dest);
	       }
	     }
	     free (ap);
	     return TRUE;
	   }
	   else {
	     ap = getenv (attrname);
	     if (ap > 0) {
	       if ((ap[0] == '^') || (ap[0] == '!')) {
		 char sbuf[NCARGS];
		 int old_dest;

		 old_dest = destIsFile;
		 destIsFile = FALSE;
		 WriteXPand (ap+1, strlen (ap+1), sbuf, afkey);
		 destIsFile = old_dest;
		 if ((ap[0] == '^') && (strlen (sbuf) < MAXPATHLEN) &&
		     ++rdepth < RDEPTH ? 
		     (try_substitute_file (sbuf, afkey, dest) || (--rdepth,0)):
		     (--rdepth,0)) --rdepth;
		 else if ((ap[0] == '!') && (strlen (sbuf) < NCARGS) &&
			  ++rdepth < RDEPTH ?
			  (try_substitute_execution (sbuf, dest, afkey) || 
			   (--rdepth,0)) : (--rdepth,0)) --rdepth;
	       }
	       else {
		 if (++rdepth < RDEPTH) {
		   WriteXPand (ap, strlen(ap), dest, afkey);
		   --rdepth;
		 }
		 else {
		   --rdepth;
		   fputs (ap, dest);
		 }
	       }
	       return TRUE;
	     }
	   }
	   if (l) *l = '$'; /* restore '$' if 'attrname' unknown */
	   return FALSE;
	 }
	 else { /* fill in the logs */
	   /* we've got to find all preceding versions */
	   
	   af_initattrs (&retbuf);    
	   (void) strcpy (retbuf.af_syspath, af_rsyspath (afkey));
	   cp = af_rname(afkey); (void) strcpy (retbuf.af_name, cp ? cp : "");
	   cp = af_rtype(afkey); (void) strcpy (retbuf.af_type, cp ? cp : "");
	   af_find (&retbuf, &kset);
	   af_sortset (&kset, AF_ATTVERSION);
	   cgen = af_rgen (afkey);
	   crev = af_rrev (afkey);
	   setsz = af_nrofkeys (&kset);
	   
	   /* determine comment leader sym to prepend it to loglines */
	   p = af_rudattr (afkey, CLEAD);
	   if (p) {
	     (void) strcpy (clead, p);
	     free (p);
	   }
	   else clead[0] = '\0';
	   
	   /* write log for each version up to current on dest file */
	   for (k = 0 ; k < setsz; k++) {
	     af_setgkey (&kset, k, &thiskey);
	     if (af_rstate (&thiskey) == AF_BUSY)
	       continue; /* don't consider busy version */
	     if ((tgen = af_rgen (&thiskey)) > cgen)
	       break;
	     if ((tgen == cgen) && (af_rrev(&thiskey) > crev))
	       break;
	     if (!title_printed) {
	       if (destIsFile)
		 fprintf (dest, "Log for ");
	       else
		 (void) strcat ((char *)dest, "Log for ");
	       putlongheader (&thiskey, dest, clead);
	       title_printed = TRUE;
	     }
	     else {    /* each log preceded by version header */
	       if (destIsFile)
		 fprintf (dest, "%s%s", (clead && clead[0]) ? clead : "",
			  (clead && clead[0]) ? " " : "");
	       else {
		 (void)strcat ((char *)dest, (clead && clead[0]) ? clead : "");
		 (void)strcat ((char *)dest, (clead && clead[0]) ? " " : "");
	       }
	       putshortheader (&thiskey, dest, TRUE);

	     }
	     note = af_rnote (&thiskey);
	     if (note && !strcmp(note, EMPTYNOTE))
	       lp = "";
	     else
	       lp = note; 
	     /* break log text into separate strings */
	     /* assertion: lp == 0 if no log or log is printed */
	     while (lp) {
	       ep = lp;
	       while ((*ep != '\n') && (*ep != '\0'))
		 ep++;
	       if (*ep == '\n') {
		 *ep++ = '\0'; /* make it end of an ordinary string */
		 if (destIsFile)
		   fprintf (dest, "%s %s\n", clead, lp);
		 else {
		   (void) strcat ((char *)dest, clead);
		   (void) strcat ((char *)dest, " ");
		   (void) strcat ((char *)dest, lp);
		   (void) strcat ((char *)dest, "\n");
		 }
		 /* ...and let it point to next string segment */
	       }
	       else {
		 ep = NULL; /* we're ready */
		 if (k < setsz-1) /* handle 'last-newline' problem */
		   if (destIsFile)
		     fprintf (dest, "%s %s\n", clead, lp);
		 else {
		   (void) strcat ((char *)dest, clead);
		   (void) strcat ((char *)dest, " ");
		   (void) strcat ((char *)dest, lp);
		   (void) strcat ((char *)dest, "\n");
		 }
		 else
		   if (destIsFile)
		     fprintf (dest, "%s %s", clead, lp);
		 else {
		   (void) strcat ((char *)dest, clead);
		   (void) strcat ((char *)dest, " ");
		   (void) strcat ((char *)dest, lp);
		 }
	       }
	       lp = ep;
	     }
	     if (note) free (note);
	     /* aw rite --- lets go for the next log entry */
	   }
	   af_dropset (&kset);
	 }
       }
       else { /* print standard version header -- do it RCS-style */
	 if (destIsFile) {
	   fprintf (dest, "%cHeader: ", '$');
	 }
	 else {
	   (void) strcat ((char *)dest, "$");
	   (void) strcat ((char *)dest, "Header: ");
	 }
	 putshortheader (afkey, dest, FALSE);
       }
       return TRUE;
     }

#define FAILURE 0
#define SUCCESS 1

static try_substitute_file (fn, afkey, dest) 
     char *fn; Af_key *afkey; FILE *dest; {

       int vid, g, r, nbytes, result = FAILURE, got_aso = FALSE,
           got_attrs = FALSE;
       char version[16], real_fn[MAXPATHLEN], *contents, *p, *f, *t,
           *malloc();
       FILE *fp = (FILE *)NULL;
       Af_key aso;
       Af_attrs attrs;

#define failed goto outahere

  /* first, lets digest the filename-argument */
  if (index (fn, ' ')) failed;
  if (BoundVersion (fn, real_fn, version)) {
    vid = mkvno (version);
    g = gen(vid);
    r = rev(vid);
  }
  else {
    g = AF_BUSYVERS;
    r = AF_BUSYVERS;
    strcpy (real_fn, fn);
  }

  p = real_fn;
  f = rindex (real_fn, '/');
  if (f) {
    *f++ = '\0';
  }
  else {
    p = (char *)NULL;
    f = real_fn;
  }
  t = rindex (f, '.');
  if (t) *t++ = '\0';

  /* ok, now try to get our fingers at the meat */
  if (fail(af_getkey (p, f, t, g, r, &aso))) {
    failed;
  }
  got_aso = TRUE;
  af_initattrs (&attrs);
  if (fail(af_gattrs (&aso, &attrs))) {
    failed;
  }
  got_attrs = TRUE;
  if ((fp = af_open (&aso, "r")) == (FILE *)NULL) {
    failed;

  }
  if ((contents = malloc ((unsigned)attrs.af_size+1)) == (char *)NULL) {
    failed;
  }
  nbytes=fread (contents, sizeof (*contents), (Size_t)attrs.af_size, fp);
  af_close (fp);
  fp = (FILE *)NULL;
  WriteXPand (contents, nbytes, dest, afkey);
  free (contents);
  result = SUCCESS;

 outahere:
  /* free resources */
  if (fp) af_close (fp); 
  if (got_aso) af_dropkey (&aso);
  if (got_attrs) udafree (&attrs);
  return result;
}

static try_substitute_execution (command, dest, afkey) 
     char *command; 
     FILE *dest;
     Af_key *afkey;
{
#define BUFLEN 1024

  FILE *is;
  char buf[BUFLEN], xcmd[MAXPATHLEN];
  int nbytes, cmdlen, olddest;

  xcmd[0] = '\0'; /* reset string */
  olddest = destIsFile;
  destIsFile = FALSE;
  WriteXPand (command, strlen (command), xcmd, afkey);
  destIsFile = olddest;

  if ((is = popen (xcmd, "r")) == (FILE *)NULL)
    return FAILURE;
  do {
    nbytes = fread (buf, sizeof (*buf), BUFLEN, is);
    WriteXPand (buf, nbytes, dest, afkey);
  } while (nbytes == BUFLEN);
  pclose (is);
  return SUCCESS;
}

static char *vnum (key) Af_key *key; {
  int _gen, _rev;
  static char vstr[20];

  _gen = af_rgen (key);
  _rev = af_rrev (key);
  
  if (af_rstate (key) == AF_BUSY)
    (void) strcpy (vstr, "busy");
  else
    (void) sprintf (vstr, "%d.%d", _gen, _rev);
  return vstr;
}


static putlongheader (afkey, dest, clead) 
     Af_key *afkey; FILE *dest; char *clead; {
  char *spath, *name, *type, *systime(), *UidString(), *csym;
  char fmtstr[256];
  extern char *st_table[];
  Af_attrs allattrs;

  spath = af_rsyspath (afkey);
  name = af_rname  (afkey); name = name ? name : "";
  type = af_rtype (afkey); type = type ? type : "";
  af_gattrs (afkey, &allattrs);
  csym = (clead && clead[0]) ? clead : "";
  if (allattrs.af_udattrs[0])
    free (allattrs.af_udattrs[0]);

  (void) sprintf (fmtstr, "%s/%s%s%s[%s]\n%s\t%s %s %s $\n", spath, name, 
	   type[0] ? "." : "", type, vnum(afkey), csym,
	   systime(&allattrs), UidString (&(allattrs.af_author)),
	   st_table[af_rstate(afkey)]);
  if (destIsFile)
    fprintf (dest, "%s", fmtstr);
  else
    (void) strcat ((char *)dest, fmtstr);
}

static putshortheader (afkey, dest, nl) 
     Af_key *afkey; FILE *dest; int nl; {
  char *name, *type, *systime(), *UidString();
  char fmtstr[256];
  extern char *st_table[];
  Af_attrs allattrs;

  name = af_rname  (afkey); name = name ? name : "";
  type = af_rtype (afkey); type = type ? type : "";
  af_gattrs (afkey, &allattrs);
  if (allattrs.af_udattrs[0])
    free (allattrs.af_udattrs[0]);

  (void) sprintf (fmtstr, "%s%s%s[%s] %s %s %s $%s", name, 
		  type[0] ? "." : "",type, vnum(afkey),
		  systime(&allattrs), UidString (&(allattrs.af_author)),
		  st_table[af_rstate(afkey)], nl ? "\n" : "");
  if (destIsFile)
    fprintf (dest, "%s", fmtstr);
  else
    (void)strcat ((char *)dest, fmtstr);
}

static struct {
  char *name;
  short code;
} an_tab[] = {
  { "atime", ATIME },
  { "author", AUTHOR },
  { "ctime", CTIME },
  { "dsize", DSIZE },
  { "generation", GEN },
  { "host", HOST },
  { "lock",  LOCKER },
  { "ltime", LTIME },
  { "mode", MODE },
  { "mtime", MTIME },
  { "name",  NAME },
  { "note", NOTE },
  { "owner", OWNER },
  { "pred", PRED },
  { "revision", REV },
  { "self", SELF },
  { "size", SIZE },
  { "stime", STIME },
  { "succ", SUCC },
  { "syspath", SYSPATH },
  { "type", TYPE },
  { "variant", VAR },
  { "version", VERSION },
  { "state", STATE },
  { "xpon", XPON },
  { "xpoff", XPOFF },
  { (char *)0x0, NULL }
};

static char *IsAStdAttr (attrname, curkey) 
     char *attrname; Af_key *curkey; {
  extern char *st_table[];
  Af_attrs *afattrs, afattrbuf;
  char messg[MAXPATHLEN+80], *UidString();
  static char rets[MAXPATHLEN];
  register int i;
  int anc = 0;

  for (i = 0; an_tab[i].name; i++) {
    if (!(strcmp (attrname, an_tab[i].name))) {
      anc = an_tab[i].code;
      break;
    }
  }

  if (af_gattrs (curkey, &afattrbuf) < 0) {
    af_perror ("IsAStdAttrs:af_gattrs");
    return NULL;
  }
  (void) udafree (&afattrbuf);
  afattrs = &afattrbuf;

  if (anc) {
    switch (anc) {
    case HOST:
      return afattrs->af_host;
      break;
    case SYSPATH:
      return afattrs->af_syspath;
      break;
    case NAME:
      return afattrs->af_name;
      break;
    case TYPE:
      return afattrs->af_type;
      break;
    case GEN:
      if (afattrs->af_state == AF_BUSY) return "nogen";
      else {
	(void) sprintf (rets, "%d", afattrs->af_gen);
	return rets;
      }
      break;
    case REV:
      if (afattrs->af_state == AF_BUSY) return "nogen";
      else {
	(void) sprintf (rets, "%d", afattrs->af_rev);
	return rets;
      }
      break;
    case SELF:
      {
	char vstring[32];
	if (afattrs->af_state == AF_BUSY)
	  vstring[0] = '\0';
	else
	  (void) sprintf (vstring, "[%d.%d]", afattrs->af_gen, 
			  afattrs->af_rev);
	(void) sprintf (rets, "%s%s%s%s", afattrs->af_name, 
			afattrs->af_type[0] ? "." : "", 
			afattrs->af_type[0] ? afattrs->af_type : "",
			vstring);
      };
      return rets;
      break;
    case PRED:
      {
	int rc;
	char *predstring;
	Af_key pred;

	if (0 > (rc = af_predsucc (curkey, AF_PHYSICAL_PRED, &pred))) {
	  af_perror ("IsAStdAttr:af_predsucc");
	  return NULL;
	}
	if (rc && (predstring = IsAStdAttr ("self", &pred))) {
	  (void) strcpy (rets, predstring);
	}
	else {
	  (void) strcpy (rets, "n/a");
	}
      }   
      return rets;
      break;
    case SUCC:
      {
	int rc;
	char *succstring;
	Af_key succ;

	if (0 > (rc = af_predsucc (curkey, AF_PHYSICAL_SUCC, &succ))) {
	  af_perror ("IsAStdAttr:af_predsucc");
	  return NULL;
	}
	if (rc && (succstring = IsAStdAttr ("self", &succ))) {
	  (void) strcpy (rets, succstring);
	}
	else {
	  (void) strcpy (rets, "n/a");
	}
      }   
      return rets;
      break;
    case DSIZE:
      if (afattrs->af_state == AF_BUSY) return "n/a";
      else {
	int ds = af_rdsize (curkey);
	if (ds < 0) 
	  return "n/a";
	else 
	  (void) sprintf (rets, "%d", ds);
	return rets;
      }
      break;
    case VERSION:
      if (afattrs->af_state == AF_BUSY) return "busy";
      else {
	(void) sprintf (rets, "%d.%d", afattrs->af_gen, afattrs->af_rev);
	return rets;
      }
      break;
    case VAR:
      return "";
      break;
    case STATE:
      return st_table[afattrs->af_state];
      break;
    case OWNER:
      if (strcmp (afattrs->af_owner.af_username, "")) {
	(void) sprintf (rets, "%s@%s", afattrs->af_owner.af_username, 
		 afattrs->af_owner.af_userdomain);
	return rets;
      }
      return "nobody";
      break;
    case AUTHOR:
      if (strcmp (afattrs->af_author.af_username, "")) {
	(void) sprintf (rets, "%s@%s", afattrs->af_author.af_username, 
		 afattrs->af_author.af_userdomain);
	return rets;
      }
      return "nobody";
      break;
    case SIZE:
      (void) sprintf (rets, "%d", afattrs->af_size);
      return rets;
      break;
    case MODE:
      return at_getmode(afattrs);
      break;
    case LOCKER:
      if (strcmp (afattrs->af_locker.af_username, "")) {
	(void) sprintf (rets, "%s@%s", afattrs->af_locker.af_username, 
		 afattrs->af_locker.af_userdomain);
	return rets;
      }
      return "nobody";
      break;
    case MTIME:
      (void) strcpy (rets, asctime(localtime(&afattrs->af_mtime)));
      rets[strlen(rets) - 1] = '\0';
      return rets;
      break;
    case ATIME:
      (void) strcpy (rets, asctime(localtime(&afattrs->af_atime)));
      rets[strlen(rets) - 1] = '\0';
      return rets;
      break;
    case CTIME:
      (void) strcpy (rets, asctime(localtime(&afattrs->af_ctime)));
      rets[strlen(rets) - 1] = '\0';
      return rets;
      break;
    case STIME:
      if (afattrs->af_state == AF_BUSY) return "no_date";
      else {
	(void) strcpy (rets, asctime(localtime(&afattrs->af_stime)));
	rets[strlen(rets) - 1] = '\0';
	return rets;
      }
      break;
    case LTIME:
      (void) strcpy (rets, asctime(localtime(&afattrs->af_ltime)));
      rets[strlen(rets) - 1] = '\0';
      return rets;
      break;
    case NOTE:
      {
	char *ap = af_rnote (curkey);
	if (ap) free (ap);
	return ap;
	break;
      }
    case XPON:
      doXPand = TRUE;
      return "xpon";
      break;
    case XPOFF:
      doXPand = FALSE;
      return "xpoff";
      break;
    default: /* shouldn't happen ! */
      (void) sprintf (messg, "illegal standard attribute code %d.", anc);
      logerr (messg);
      return NULL;
    }
  }
  else return NULL; /* no standard attribute */
}

int at_is_stdattr (attrname) char *attrname; {
  register int i;

  for (i = 0; an_tab[i].name; i++) {
    if (!(strcmp (attrname, an_tab[i].name))) {
      return TRUE;
    }
  }
  return FALSE;
}

char *UidString (user) Af_user *user; {
  static char rst[256];

  rst[0] = '\0';
  if (user) {
    (void) sprintf (rst, "%s@%s", user->af_username, user->af_userdomain);
  }
  return rst;
}

static char *systime (attrs)
     Af_attrs *attrs;
{
  char *asctime();  
  char *ts;
  
  ts = asctime(localtime((attrs->af_state == AF_BUSY)
			 ? &attrs->af_mtime : &attrs->af_stime));
  ts[strlen(ts)-1] = '\0';
  return ts;
}
