/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * ParseArgs.h
 */
/*
 * $Header: ParseArgs.h[1.7] Wed Dec 20 10:35:05 1989 uli@cs.tu-berlin.de frozen $
 */

#define PSWITCH 0		/* argument is a switch (default) */
#define PARG 01			/* argument has argument */
#define POARG 02		/* argument hat optional argument */
#define PKIND 07

/* option attribute */
#define PHIDDEN (01 << 4)	/* not in usage */
#define PATTRS (07 << 4)

/* action to be performed */
#define PCALL	0		/* call function (default) */
#define PSET (01 << 8)		/* set variable to 1 */
#define PCLEAR	(02 << 8)	/* set variable to 0 */
#define PTOGGLE (04 << 8)	/* toggle variable */
#define PUSAGE (010 << 8)	/* call usage */
#define PFAIL (020 << 8)	/* call usage and return 1 */
#define PACTION (077 << 8)

typedef struct __optdesc {
  char *OptName;
  int OptKind;
  int (*OptFunc)();
  int *OptVar;
  char *OptStr;
} OptDesc;

/*
 * This should really be 
 *  typedef struct __optdesc {
 *    char *OptName;
 *    int OptKind;
 *    union {
 *      int (*OptFunc)();
 *      int *OptVar;
 *      char *OptStr;
 *    } OptAction;
 *  } OptDesc;
 *
 * but we can't declare a init-declaration 'cause C can only initialize the
 * first member of the function (yet). If we use ``caddr_t OptAction'' instead
 * and cast a function into caddr_t, lint conplains.
 */

extern int ParseArgs();
extern int ParseEnv();
extern char *ParseArgs_version();
