/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

*/
/*
 * Shape/AtFS
 *
 * s-ultrix_4/config.h -- general definitions for ULTRIX 4.0
 *
 * $Header: config.h[1.7] Mon Mar 30 20:05:23 1992 nickel@cs.tu-berlin.de accessed $
 */

/* do only once */
#ifndef _defs_
#define _defs_

/* identify operating system flavor */
#define ULTRIX_4

/* general includes */
#include <sys/types.h>
#include <sys/stat.h>
#ifndef MAXNAMLEN
#include <sys/dir.h>
#endif
#include <sys/param.h>
#include <string.h>
#include <pwd.h>
#include <time.h>
#include <utime.h>

#include <sys/wait.h>

/* general type definitions */
#define Sfunc_t void        /* type of function argument to signal call */
#define Sigret_t void       /* return type of signal system call */
#define Size_t  unsigned    /* used for args to fread() etc. */
#define Uid_t   int         /* used for user-id types */
#define Gid_t   int         /* used for group-id types */
#define Wait_t  union wait
#define Pid_t   pid_t

/* Which dbm should be used ? (default ndbm) */

/* Constants */
#define MAXDOMAIN 255
#define MAXTYPLEN 256

#endif /* _defs_ */
