/*LINTLIBRARY*/
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Shape/AtFS
 *
 *	aflib.c -- Miscellaneous functions
 *
 *	Author: Andreas Lampen, TU-Berlin (andy@coma.UUCP)
 *					  (andy@db0tui62.BITNET)
 *
 *	$Header: aflib.c[1.14] Fri Jan 31 18:05:05 1992 andy@cs.tu-berlin.de accessed $
 *
 *	EXPORT:
 *      af_retfsize -- return file size
 *      af_cpfile -- copy files
 *      af_bsearch -- binary search on ordered list of strings
 *
 */

#include <stdio.h>

#include "afsys.h"
#include "atfs.h"

/*================================================================
 *	af_retfsize
 *
 *================================================================*/

EXPORT off_t af_retfsize (file)
     char *file;
{
  struct stat ibuf;
  
  if (stat (file, &ibuf) == -1)
    return ((off_t) 0);
  return (ibuf.st_size);
} /* af_retfsize */ 


/*=========================================================================
 *     af_cpfile -- copy files
 *
 *=========================================================================*/

EXPORT af_cpfile (source, size, dest)
     char *source;
     off_t size;
     char *dest;
{
  char            cont[BUFSIZ];
  register int    bufsiz = BUFSIZ;
  register FILE   *sfile, *dfile;
  
  if ((sfile = fopen (source, "r")) == (FILE *)0)
    return (ERROR);
  if ((dfile = fopen (dest, "w")) == (FILE *) 0)
    {
      (void) fclose (sfile);
      return (ERROR);
    }

  while (size > 0)
    {
      if (size >= BUFSIZ)
	size -= BUFSIZ;
      else
	{
	  bufsiz = size;
	  size = 0;
	}
      if (!fread (cont, sizeof(char), bufsiz, sfile))
	{
	  (void) fclose (sfile);
	  (void) fclose (dfile);
	  return (ERROR);
	}
      if (!fwrite (cont, sizeof(char), bufsiz, dfile))
	{
	  (void) fclose (sfile);
	  (void) fclose (dfile);
	  return (ERROR);
	}
    }

  (void) fclose (sfile);
  (void) fclose (dfile);
  return (AF_OK);
}

/*========================================================================
 * af_bsearch -- do binary search on ordered list of strings
 *               returns position (-1 if target not found)
 *
 *========================================================================*/

EXPORT af_bsearch (list, size, target)
     char **list;
     int  size;
     char *target;
{
  register int hi = size-1, lo=0, pos, res;

  pos = (hi+lo)/2;
  while (hi >= lo)
    {
      if ((res = strcmp (target, list[pos])) == 0)
	return (pos);
      else
	{	  
	  if (res < 0)
	    hi = pos - 1;
	  else /* res > 0 */
	    lo = pos + 1;
	  pos = (hi+lo)/2;
	}
    }
  /* the target string was not found */
  return (ERROR);
}

