/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/tools/SCCS/s.unfunny.c
 * Vers: 5.2    Time: 92/08/05, 14:47:15
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)unfunny.c	5.2 92/08/05";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#include <stdio.h>
#include <ctype.h>

/*********************************************************
*  NAME:
*	unfunny - strip funny (cntrl) chars out of a file.
*
*  USAGE:
*	unfunny [filename] hex_ascii_char. 
*       Example:
*	$ unfunny demo2.log 0x00 > new.log
*	$ cat demo2.log | unfunny 0x00 | lpr -Pline
*
*	Use 'funny' to find funny chars and unfunny to strip them.
*
**************************************************************/

struct cntrl {
	int count;
	char* name;
};

void
strip (fp, what) /* copy file fp to standard output */

FILE *fp;
int what;

{
	int c;

	while ((c = getc(fp)) != EOF) {
		if (c != what)
			putchar ((char) c);
	}
}




main (argc, argv) /* cat: concatenate file */

int argc;
char *argv[];

{
	FILE *fp, *fopen();
	long stripMe = 0;

	if (argc == 1 || argc > 3) { /* no args, copy standard input */
		/* ascii code is a hex number */
		printf ("Usage: %s [filename] hex_ascii_code \n", argv[0]);
		exit (1);
	}
	else if (argc ==2) {	/* use stdin file */
		stripMe = strtol (argv[1], NULL, 16);
		strip(stdin, (int)stripMe);
	}
	else if (argc == 3 ){
		if ((fp = fopen (argv[1], "r")) == NULL) {
			printf ("%s: can't open %s\n", argv[0], argv[1]);
			exit (1);
		}
		else {
			stripMe = strtol (argv[2], NULL, 16);
			strip(fp, (int)stripMe);
			fclose (fp);
		}
	}
}

	
