/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/tools/SCCS/s.otsogrep.cxx
 * Vers: 5.2    Time: 92/08/05, 14:47:18
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)otsogrep.cxx	5.2 92/08/05";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
FILE otsogrep.cxx
**********************************************************************/

/**********************************************************************
Documented in otsogrep.n
**********************************************************************/

#include "matches.inc"

class Option {
public:
  boolean	isOn;
  char*		text;
  Option(): isOn(false) {}
};

enum OtsoGrepOptions {running, sendingOutput, receivingInput,
		      inputParameters, outputParameters,
		      actions, variablesBefore, variablesAfter,
		      optionCount
		      };


main(int argc, char* argv[]) {

  Option options[optionCount];

  /********** compare to tracing in runner.cxx ***************/
  options[running].text = "*NOW RUNNING*";
  options[sendingOutput].text = "*SENDING MESSAGE*";
  options[receivingInput].text = "*RECEIVED MESSAGE*";
  options[inputParameters].text = "*INPUT PARAMETERS*";
  options[outputParameters].text = "*OUTPUT PARAMETERS*";
  options[actions].text = "*ACTIONS WHEN*";
  options[variablesBefore].text = "*VARIABLES BEFORE*";
  options[variablesAfter].text = "*VARIABLES AFTER*";

  if (argc < 3) {
    cerr << "Usage: otsogrep -riopp+p-avv+v- objectNamePattern [filename]\n";
    return(1);
  }

  /*********** 1st argument: options ******************/
  if (argc >= 2) {
    char* o;
    for (o = argv[1]; *o; o++) {
      if (*o == 'r') options[running].isOn = true;
      if (*o == 'i') options[receivingInput].isOn = true;
      if (*o == 'o') options[sendingOutput].isOn = true;
      if (*o == 'p') {if (o[1]=='-') options[inputParameters].isOn = true;
		      else if (o[1]=='+') options[outputParameters].isOn = true;
		      else {
			options[inputParameters].isOn = true;
			options[outputParameters].isOn = true;
		      }
		     }
      if (*o == 'a') options[actions].isOn = true;
      if (*o == 'v') {if (o[1]=='-') options[variablesBefore].isOn = true;
		      else if (o[1]=='+') options[variablesAfter].isOn = true;
		      else {
			options[variablesBefore].isOn = true;
			options[variablesAfter].isOn = true;
		      }
		     }
    }
  }

  /********* 2nd argument: pattern for object name **********/
  //copy '*', argv[1], '*', and 0 to regex
  char regex[999];
  char* regexp = regex;
  *regexp++ = '*';
  while (*regexp++ = *argv[2]++);
  regexp--;			//overwrite 0
  *regexp++ = '*';
  *regexp = 0;

  /********** read cin or open files ***************/ 
  MyIstream is;

    for (int i = 3; i==3 && argc==3 || argv[i] && *argv[i]; i++) {

      filebuf fb;
      istream isFile(&fb);
      if (argc==3) {
	is = cin;
      }
      else {
	if (!fb.open(argv[i], ios::in)) 
	  cerr << "Could not open file " << argv[i] << "\n";
	is = isFile;
      }

      /********* print matching blocks ***************/
      while (is) {
	is.getline(line, maxLineLen);
	if (!is) break; 		//next file
	if (matches(regex, line)) {	//object name
	  for (int i = 0; i < optionCount; i++)
	    if (options[i].isOn) {
	      if (matches(options[i].text, line)) {
		is.printBlock(line);
		cout << "\n";
		break;			//no next option but next line
	      }
	    }
	}
      }
    }  
}
