/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/tools/SCCS/s.matches.inc
 * Vers: 5.1    Time: 92/07/09, 10:02:27
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
FILE matches.inc

PURPOSE

This file is #included at least in bgrep.cxx and otsogrep.cxx.


MODIFICATIONS

23.10.91 Juha: cout.flush() to make "run-time" bgrepping of logfile convenient.

BUGS

Quoted or commented braces are also counted.
**********************************************************************/

#include "stream.h"
#include "fstream.h"

typedef int boolean;
const boolean false = 0;
const boolean true = 1;

const int maxLineLen = 1024;
char line[maxLineLen+1];

/*********************************************************************
Returns true if rp is equal to sp.  rp may contain the wild card '*' 
which is equal to any string of 0 or more characters.
**********************************************************************/
boolean matches(const char* rp, const char* sp) {
  boolean wild = false;
  const char* tmpRp;
  const char* tmpSp;

  while (*rp && *sp) {
    tmpRp = rp; tmpSp = sp;
    while (*tmpRp && *tmpSp && *tmpRp==*tmpSp && *tmpSp!='*') {
      tmpRp++; tmpSp++;
    }
    if (*tmpRp==0 && *tmpSp==0 || *tmpRp=='*') {
      rp = tmpRp; sp = tmpSp;
      wild = false;
    }
    else if (!wild) break;
    else {/*cout << *sp;*/ sp++;}

    while (*rp && *rp=='*') {rp++; wild = true; /*cout << " ";*/}
    while (*sp && *rp!=*sp) {/*cout << *sp;*/ sp++;}
  }
  while (*rp && *rp=='*') rp++;
  return (*rp==0 && *sp==0);
}

/**********************************************************************
istream_withassign plus brace counting and block printing.
Input must be read via getline().

BUGS
istream_withassign is obsolete (?)
**********************************************************************/

class MyIstream: public istream_withassign {
public:
  MyIstream(): braceLevel(0), previousBraceLevel(0) {}
  void getline(char* line, int len);
  //operator boolean() {return *(istream*)this;}
  void printBlock(char* line);
  MyIstream& operator=(istream& r) {istream_withassign::operator=(r);
				    return *this;}
private:
  void countBraces(char* line);
  int braceLevel;
  int previousBraceLevel;
};

void MyIstream::countBraces(char* line) {
  char c;
  while (c = *line++)
    if (c == '{') braceLevel++;
    else if (c == '}') braceLevel--;
}

void MyIstream::getline(char* line, int len) {
  previousBraceLevel = braceLevel;
  istream_withassign::getline(line, len);
  if (*this) countBraces(line);
}

void MyIstream::printBlock(char* line) {
  int store = previousBraceLevel;
  cout << line << "\n"; 
  cout.flush();
  while (braceLevel > store && *this) {
    getline(line, maxLineLen);
    cout << line << "\n";
    cout.flush();
  }
}

/*********
boolean contains(const char* rp, const char* line) {
  //copy '*', rp, '*', 0 to regex
  char regex[999];
  char* regexp = regex;
  *regexp++ = '*';
  while (*regexp++ = *rp++);
  regexp--;			//overwrite 0
  *regexp++ = '*';
  *regexp = 0;

  return matches(regex, line);  
}
*********/

