/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/tools/SCCS/s.gnoop.c
 * Vers: 5.2    Time: 92/08/05, 14:47:13
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)gnoop.c	5.2 92/08/05";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#include <stdio.h>
#include <strings.h>


/* big char buffer for gnoop */
#define BIGBUFSIZ	4048
static char buffer [BIGBUFSIZ];


/* strindex:
*   	return index of first occurence of substring 
*	inside of a string, or if substring isn't
*	found, return NULL
*/

char * strindex (str, sub)
    char * sub, * str;
{
    char *s = index (str, *sub);

    if (s) {
      if (!strncmp (sub, s, strlen(sub)))
	return s;
      else return strindex (++s, sub);
    }
    else
      return NULL;
}




/* 
* G++   output tends to run together and it's difficult to tell
* 	where one error message starts and another ends.
* 
*	Insert linefeeds before lines containing certain patterns.
*	to make output easier to read.
*/
void gnoop (fp)
    FILE * fp;
{
	FILE * out = stdout;
	char * pattern = "In method";
	
	/* unbuffered in/output */
	setbuf (fp, NULL);
	setbuf (out, NULL);

	while (fgets (buffer, BIGBUFSIZ-1, fp)) {
		if (strindex (buffer, pattern)) {
			fputs("\n", out);
			fputs(buffer, out);
		}
		else {
			fputs(buffer, out);
		}
	}
}




 /* gnoop: pretty print g++ compiler output */

main (argc, argv)
    int argc;
    char *argv[];
{
    FILE *fp, *fopen();

    if (argc == 1)	/* no args, copy standard input */
	gnoop (stdin);
    else
	while (--argc > 0) {
	    if ((fp = fopen (*++argv, "r")) == NULL) {
		printf ("cat: can't open %s\n", *argv);
		break;
	    }
	    else {
		gnoop (fp);
		fclose (fp);
	    }
	}
}
