/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/protocols/4/tran0/SCCS/s.tran0.hx
 *  Version:	1.8
 *  Time:	92/08/14, 15:09:33
 *
 **************************************************************/


//////////////////////////////////////////////////////////////////////////
// NAME: Tran0
//
// PURPOSE:
//   A simple OSI Transport Class 0 object.  Transport Class 0
// is the simplest 'transport' service provided by OSI.  It assumes
// that a type 'A' network (flawless, error-free transmission 
// with no N-RESETs occuring) is used beneath the Transport layer.
// Error detection, Error recovery, and multiplexing ARE NOT supported
// in Transport Class 0.
//   The underlying Network layer in this OTSO implementation is
// OTSO's Connection Oriented Network Service (CONS).  The CONS network
// layer may be physically implemented as a virtual subnetwork, or an actual
// network layer such as X.25, RFC-1006, etc.
//
// INHERITS:
//   Tran0 inherits properties from several base classes.  They provide
// functionally distinct views of the Tran0 object to different types of
// objects (entities) in the final OTSO system.  This separation of
// functionality by use of Inheritance makes Tran0 easier to maintain, modify,
// and use in the final configuration.  It also simplifies its interface to
// other objects.
//   The inherited base classes provide only interfaces or "signatures", 
// tran0.cx supplies many of the specific methods (e.g. run() function, etc).
// needed to im-plement each interface.
//
//   TranPeer:
//     Tran0 will be exchanging Transport PDUs (TPDUs) with
//     peer transport layer entities.  Therefore, it must be able
//     to handle peer PDUs (provide an interface for them).  A Tran0
//     entity views its peer only via the PDUs exchanged using
//     the services of lower layers. 
//
//   TranSP:
//     Transport Service Provider interface, the services that
//     Tran0 provides to upper layers (t_cr, t_cresp, t_dtr, t_dr).
//     Allows Tran0 to be physically connected below some upper
//     layer (via a TranSP* pointer), the upper layer views Tran0
//     only as a transport service provider.
//
//   NetSU:
//     Since Tran0 will be physically connected on top of a Network
//     layer, it must understand handle potential Network Service
//     user primitives (n_ci, n_cc, n_dti, n_di).  Lower layer views
//     Tran0 only as a Network Service User.
//
//   Runner:
//     Tran0 will be scheduled for execution by OTSO (to process
//     service primitives and PDUs, run the state machine, etc), 
//     so it must be a Runner.  OTSO views Tran0 only as a Runner.
//
//////////////////////////////////////////////////////////////////////////

implementation class Tran0
  : public TranPeer, public TranSP, public NetSU, public Runner
{

public:

  enum TranState {
    t0_closed,		/* wait for CR or t_cr */
    t0_wfCC,		/* wait for CC */
    t0_wfcresp,		/* wait for t_cresp */
    t0_open,		/* data transfer phase */

    /* Class 4 specific */
    t0_wfAK,		/* wait for AK */
    t0_closing,		/* wait for DC */

    /* Class 0 specific */
    t0_wfncc, t0_wfCR, t0_reject,

    t0_stubs		//Stub primitives and PDUs (from Transport class 4)
			//go here, but they are never executed. 
  }; /* */
  TranState state;
	//The current 'state' of the Tran0 EFSA


  /*The physical connections of the Tran0 object,
    i.e. other protocol objects it is connected to.
  */
  TranSUPtr	up;             //Ptr to transport service user.
  NetSPPtr	down;		//Ptr to CONS Netwk serv provider.

	/*
	  Declare interfaces that are implemented here
	*/ 
  redefined TranSP_interface;	//transport service provider primitives
  redefined TranPeer_interface;	//transport peer entity PDUs
  redefined NetSU_interface;	//network service user primitives
	//Tran0's interfaces are a way of controlling distinct "views"
	//of Tran0.  It can have a completely different "look" 
	//depending on how it is physically connected to other objects.
	//This is a way of controlling the visibility of Tran0 and
	//how other objects may use it.
	//
	//For example, the underlying Network layer object has a physical
	//connection to some NetSU object (Tran0 in our case).  But the
	//Network layer ONLY cares that the NetSU object can handle the NetSU
	//primitives that it generates.  It does not and should not need
	//any other knowledge of the NetSU object above it.  The
	//NetSU_interface of Tran0 provides the separate/distinct interface
	//to the underlying Network object.
	//
	//  NOTE: each XXX_interface is a #define macro, defined in the
	//appropriate header file (e.g. NetSU_interface is defined in 
	//cons_serv.hx, TranSP_interface is defined in tran_serv.hxx, etc).



  Tran0 (TSAPaddr *addr, Group *n=0);
  ~Tran0 ();
	//The constructor and destructor of Tran0.
	//Tran0 must know it's own TSAP address (TSAP+NSAP+Network address).

  void		init();		//Initializes Tran0's input queue and 
                                //own address.
  void		DEFAULT();	//OTSO generates code for this

  /**** EFSA methods ****/
  void		tranDisc();	//transport disconnect
  void		tranError();	//transport error

private:
  /*$OTSO_OFF*/
  TranEnc*	enc;		//enc:  Tran0`s pdu encoder
  TranDec*	dec;		//dec:  Tran0`s pdu decoder
  /*$OTSO_ON*/

  TSAPaddr	ownAddr;	//our TSAP addr
  TSAPaddr	remoteAddr;	//other side's TSAP addr

  slong		ownRef;		//this entity's connection reference
  slong		remoteRef;	//peer entity's connection reference

  slong		qos;		//quality of service
  boolean	useExtFormat;	//use of extended formats ?
  boolean	useExpData;	//use of expedited data ?
  uint16	pduSize;	//maximum size of PDU

  Frame		splitter;	//temporary frame for use in EFSA
  Frame		accumulator;	//temporary frame for use in EFSA
  Frame		user_data;	//spdu frame (upper layer PDUs)

};

