/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/protocols/4/all/SCCS/s.tran_peer.hx
 *  Version:	1.4
 *  Time:	92/08/14, 15:06:23
 *
 **************************************************************/

/**********************************************************************
* NAME: tran_peer.hxx
*
* PURPOSE: Connection Oriented Transport Service (TRAN)
*	Peer protocol PDU definitions.
**********************************************************************/

enum dr_reason {
      unknown_, SE_unavailable_t, SE_unavailable_p, address_unknown,
      user_invoked, remote_TE_congestion, conn_negotiation_failed,
      duplicate_src_ref, mismatched_ref, protocol_error, ref_overflow,
      cr_refused_on_NC, header_or_LI_invalid
};

///////////////////////////////////////////////////////////////
// TranPeer contains Transport PDUs that can be received.
// These PDUs appear as inputs to the EFSA.
///////////////////////////////////////////////////////////////

interface class TranPeer {

public:

  virtual async T_CR (
    slong	credit,
    slong	trclass,
    slong	extFormats,
    TSAPaddr	calling,
    TSAPaddr	called,
    slong	tpduSize,
    slong	checksum,
    slong	expData,
    Frame	data
  ) = 0;

  virtual async T_CC (
    slong	credit,
    slong	trclass,
    slong	extFormats,
    TSAPaddr	responding,
    slong	tpduSize, 
    slong	checksum, 
    slong	expData, 
    Frame	data
  ) = 0;

  virtual async T_DR (
    slong	drReason,	//Someday: type dr_reason
    Bytes	clearInfo,
    Frame	data
  ) = 0;

  virtual async T_DT (slong pduNr, slong eot, Frame data) = 0;

  virtual async T_DC () = 0;
  virtual async T_ED (slong pduNr, Frame data) = 0;
  virtual async T_AK (slong ackNr, slong credit) = 0;
  virtual async T_EA (slong ackNr) = 0;
  virtual async T_ER (slong cause, Bytes invTPDU) = 0;
  virtual async T_RJ (slong pduNr, slong credit) = 0;
  virtual async T_INVALID () = 0;
  virtual async T_CORRUPTED () = 0;
};

