/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/protocols/3/cons/all/SCCS/s.nettcp.hx
 *  Version:	1.2
 *  Time:	92/02/13, 13:45:56
 *
 **************************************************************/

/////////////////////////////////////////////////////////////////
// NAME:
//	nettcp.hx
//
// PURPOSE:
//
/////////////////////////////////////////////////////////////////


//
//TCP/IP connection oriented network service based on
//RFC-1006.  Implemented in BSD Unix using TCP/IP sockets.
//
implementation class NetTCP : public Net {

public:
  enum ConnectRole { CON_FREE, CON_INITIATOR, CON_RESPONDER };
  enum Accumulate  { ACCUM_START, ACCUM_HDR, ACCUM_PDU };

protected:

  uint16 connectRole;	//ConnectRole

  uint16 portnum;	//server's portnum, set in ctor.

  //
  //Needed for an RFC-1006 BSD subnetwork
  //
  ClientSocket		*soClient;	//Initiator
  ServerSocket		*soServer;	//Server
  ServiceSocket		*soService;	//Responder


public:

  ////////////////////////////////////
  //// Network Layer's Interfaces ////
  ////////////////////////////////////
  redefined NetSP_interface;	//Net service provider primitives
  redefined NetPeer_interface;  //Net peer NPDUs

  NetTCP (NSAPaddr* addr, Group* n=0, uint16 portnum=3102);
	//ctor initializes object's input queue and own address.

  void	DEFAULT();		//OTSO generates code for this

  virtual void	run();		//listens for incoming connections,
				//incoming data transfers

protected:

  /////////////////////////////
  //// EFSA Data + methods ////
  /////////////////////////////

  uint16 	accumulating;	//net layer entity acc'ing NPDU ?

  slong		desiredNPDUsize;

  Frame 	npdu;	//Current network pdu used in EFSA ...
			//Net::run() may be accumulating data into npdu

  void resetAccumulator();


public:

  NETaddr*	goodNetwkAddr (NSAPaddr& n);
  boolean	activeOpen (NSAPaddr&, NSAPaddr&, slong, Frame&);
  void    	transmit (Frame&);
  void    	disconnect ();
};

