/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/protocols/3/cons/all/SCCS/s.cons_serv.hx
 *  Version:	1.1
 *  Time:	91/07/17, 14:13:55
 *
 **************************************************************/


/**********************************************************************
* NAME: cons_serv.hxx
*
* PURPOSE: Connection Oriented Network Service (CONS)
*	Service (user and provider) primitive definitions.
**********************************************************************/

/**********************************************************************
Connectionless network service provider interface.
**********************************************************************/

/* Hack - I would prefer to use enums inside a class scope - jfr */
/*	- look up real values in ISO standard someday - jfr */

/* originator */
#define ORIG_LOCAL_PPM	0
#define ORIG_REMOTE_PPM	1

/* reason */
#define DISC_RSN_BAD_ADDR	0
#define DISC_RSN_OTHER		1

/* quality of service */
#define QOS_DEFAULT	0
#define QOS_EXCELLENT	1
#define QOS_GOOD	2
#define QOS_FAIR	3


interface class NetSP {
public:
  /* Connection establishment */
  virtual async n_cr (
    NSAPaddr source_addr, NSAPaddr dest_addr, slong qos, Frame data
  ) = 0;

  virtual async n_cresp (
    NSAPaddr resp_addr, slong qos, Frame data
  ) = 0;


  /* Connection dis-establishment */
  virtual async n_dr (
    slong originator, slong reason, Frame data, NSAPaddr resp_addr
  ) = 0;


  /* Data transfer */
  virtual async n_dtr (Frame data) = 0;
};


/**********************************************************************
Connectionless network service user interface.
**********************************************************************/

interface class NetSU {
public:

  /* Connection establishment */
  virtual async n_ci (
    NSAPaddr source_addr, NSAPaddr dest_addr, slong qos, Frame data
  ) = 0;

  virtual async n_cc (
    NSAPaddr resp_addr, slong qos, Frame data
  ) = 0;


  /* Connection dis-establishment */
  virtual async n_di (
    slong originator, slong reason, Frame data, NSAPaddr resp_addr
  ) = 0;


  /* Data Transfer */
  virtual async n_dti (Frame data) = 0;
};


