/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/protocols/3/cons/all/SCCS/s.cons.hx
 *  Version:	1.4
 *  Time:	92/08/17, 09:19:41
 *
 **************************************************************/

/////////////////////////////////////////////////////////////////
// NAME:
//	cons.hxx
//
// PURPOSE:
//	Connections Oriented Network Service (CONS)
//	CONS Network Layer Entity Class definition.
//
// MODIFICATIONS:
//	looks the same as in cons-tcpip directory
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Network Implementation: Connection Oriented Network Service (CONS) 
//
// Physically, it may be implemented as a virtual network (using pointers
// to peer layer entities), or a real network layer entity (using X.25, LAPB,
// etc), or as an RFC-1006 Network (using BSD sockets).
/////////////////////////////////////////////////////////////////////////////

implementation class Net
  : public NetPeer, public NetSP, public Runner
{

public:

  /*
  State variables
  */
  enum NetState	   { net_idle, net_wfcresp, net_wfcc, net_connected };
  enum NetSubtype  { NTYPE_VIRTUAL, NTYPE_TCP /*, NTYPE_X25, NTYPE_ISDN */ };

  /*
  OTSO Physical Layer Entity connections 
  */
  NetSUPtr	up;             //up: Pointer to network service user.
  NetPeerPtr	peer;           //peer: used for implementing virtual 
				//network layers.

protected:
  NetState	netState;	//Network Protocol EFSA's state.
  NetSubtype	netSubtype;	//The type of Physical Subnetwork available.

  /*
  Network addresses
  */
  NSAPaddr	localAddr;      //Node's own network address (Initiator).
  NSAPaddr	remoteAddr;     //Other Node's network address (Responder).


public:

  /*
  Network Layer's Interfaces
  */
  redefined NetSP_interface;	//Net service provider primitives
  redefined NetPeer_interface;  //Net peer NPDUs


  Net(NSAPaddr* addr, Group* n=0);
	  //ctor initializes object's input queue and own address.

  void		DEFAULT();	//OTSO generates code for this

};


