/**************************************************************
 *
 *  VALTION TEKNILLINEN TUTKIMUSKESKUS (VTT/TEL/TIV)
 *  Otakaari 7 B
 *  02150 Espoo
 *  FINLAND
 *
 *  OTSO Source Code Control System, 12.7.89
 *
 *  Name:	/home/users/otso/official/otso/protocols/3/clns/SCCS/s.clns.hx
 *  Version:	1.4
 *  Time:	92/02/13, 13:46:56
 *
 **************************************************************/

/****************************************************************
* NAME: clns.hx
*
* PURPOSE: Connections Less Network Service (CLNS)
*	CLNS Network Layer Entity Class definition.
****************************************************************/

/*
*   Net class is a virtual network layer object. It simulates an 
* ethernet type of subnet. Net nodes are connected to each other as
* is they would form an ethernet bus. n_udtr Data request is allways passed 
* on to both left and right neighbours. Data pdus (N_RDT, N_LDT) coming
* from neighbouring nodes are allways passed on to the other side even if
* the destination address was recognized to be node's own address. 
*/

implementation class Net
  : public NetPeer, public NetSP, public Runner
{
public:
  enum NetState	{ net_idle, net_wfcresp, net_wfcc, net_connected };
  NetState	state;

  // Physical connections
  NetSUPtr	up;             // up: Pointer to network service user.
  NetPeerPtr	peer;

  // Network addresses
  NSAPaddr	ownAddr;        // Node's own network address.
  NSAPaddr	broadAddr;	// Broadcast addr is recognized by all nodes.

  // Current network pdu used in EFSA 
  Frame 	npdu;

  // Network Layer's Interfaces
  redefined NetSP_interface;
	// Connectionless net service provider primitive.
  redefined NetPeer_interface;
	// Virtual connectionless net pdu input.

  // ctor 
  Net (NSAPaddr* addr, Group* n=0);
       // Initializes object's input queue and own address.

  void		DEFAULT();
	// OTSO generates code for this
};

