%{

/**************************************************************
  test.l
**************************************************************/

/* ---- LEX DEFINITIONS SECTION ---- */
#include "stdio.h"

/****************
\/\*$OTSO_ON[ \t\f\n]*\*\/	
\/\*$OTSO_OFF[ \t\f\n]*\*\/ 
[a-zA-Z_][a-zA-Z0-9_]*_interface
operator[ \t]*[^( \t]+
#INCLUDE[ \t]+[\"\<][^\">\n]+[\"\>]
.			{echo;}

\"[^\\\"\n]*\\\"	{return 2;}
\"[^\"\n]*\"		{return 1;}
[^\"\n]*\"		{return 3;}
******************/
%}

/* ---- LEX RULES/ACTIONS SECTION ---- */

%%
"*"			{return '*';}
"&"			{return '&';}
^#[^\n]*		{return 'X';}
"//".*			{if (yytext[2]=='*') printf("//*...is bad...\n");
                         return '/';}
.			{return 0;}
%%



/* ---- LEX PROGRAMMER ROUTINES SECTIONS ---- */

int yywrap() {return 0;}

main() {
  while (1) {
    int l = yylex();
    if (l) printf("(%c) %s\n", l, yytext);
  }
}

