


TextTerminal(3)        C LIBRARY FUNCTIONS        TextTerminal(3)



CLASS
     TextTerminal

PUBLIC BASE CLASSES
     VirtualTerminal



DESCRIPTION
     TextTerminal is an implementation of a Virtual Terminal.  It
     basically  uses the standard input, output and error streams
     that should be available with any C++ system.

     - Terminal operator >> uses standard input as with cin.

     - Terminal operator << uses standard output as with cout.

     - error(var arg list)     is for user errors
         e.g.  cterm.error("this is a user's error %d", errno);
         produces: *** Program Error : this is a user's error 34 ***

     - dverror(int derrno, var arg list) is for dvops errors (with DVOPS error
       numbers).
         e.g.  cterm.dverror(int my_errno=1, "%d bad inputs occurred", nbad);
         produces: *** DVOPS Error : 3 bad inputs occurred[Unkown Error] ***

     - perror(var arg list) is for system errors using global
       variable ::errno.
         e.g.
         ::errno = ENOTWRITE;
         cterm.perror("no write on fd = %d ", fd);
         produces: *** System Error : no write on fd=4[Couldn't Write] ***

     - xerror(var arg list) is for fatal system errors using global
       variable ::errno.
         e.g.
         ::errno = ENOTWRITE;
         cterm.perror("no write on fd = %d, Can't continue, goodbye.", fd);
         produces: *** Fatal Error : no write on fd=4, Can't continue, goodbye.
                   [Couldn't Write] ***
                   *** Bye ***
                   <exit to system command level>

       DVOPS Error numbers for dverror are defined in dverror.cxx :
          0    No Error
          1    Unknown Error
          2    Not Implemented Yet
       Please add new DVOPS errors there.


BUGS
     Unformatted IO to the error or log streams must be done thru



Sun Release 4.0          Last change: -                         1






TextTerminal(3)        C LIBRARY FUNCTIONS        TextTerminal(3)



     member  ostreams  -  otherwise  use error(), perror(), dver-
     ror(), and xerror().


PUBLIC MEMBERS
      output stream

     VirtualTerminal& form
           user error   dvops error - errno  syst error  -  errno
          fatal error  log to logfile


PUBLIC CONSTRUCTORS AND CONVERSIONS
      TextTerminal(istream& is =cin, ostream& os =cout,  ostream&
     error =cerr, ostream& logger =cout)


      TextTerminal(TextTerminal& ui)




FILE
     text_term.hxx































Sun Release 4.0          Last change: -                         2



