.TH String 3 - 
.SH CLASS
String
.SH PUBLIC BASE CLASSES
.in 4
.B
Object
.in 7
.fi


.SH DESCRIPTION
.fi

Implements a OTSO "string" class for printable strings.
NULL character terminates a string.
Nonprintable characters are not recommended for esthetic reasons.

.SH BUGS
operator[]: no range checking. 

Do not append a char to a string!

.SH MODIFICATIONS
 
.SH PUBLIC MEMBERS

.in 4
.B

char& operator [](sint32 i) const
.in 7
.fi
i'th character. 0 is first. No range checking.  
.in 4
.B

String& operator =(const String& r)
.in 7
.fi
Deletes old value of this, copies r here, returns *this. 
.in 4
.B

String& operator +=(const String& r)
.in 7
.fi
Appends r to this, returns *this. 
.in 4
.B

sint32 length() const
.in 7
.fi
Current length of this  String object (strlen). 
.in 4
.B

boolean isEmpty()
.in 7
.fi
True if uninitialized or 0 length. 
.in 4
.B

String withoutWhite()
.in 7
.fi
Returns a copy with white space characters deleted.  The result is as long as or shorter than *this. 
.SH FRIEND FUNCTIONS

.in 4
.B

friend String operator +(const String& l, const String& r)
.in 7
.fi
Returns a new String which is a copy l appended by r. 
.in 4
.B

friend boolean operator ==(const String& l, const String& r)
.in 7
.fi
True if equal lengths and all  characters equal. 
.in 4
.B

friend boolean operator !=(const String& l, const String& r)
.in 7
.fi
 
.in 4
.B

friend boolean operator ==(const String& l, char* r)
.in 7
.fi

.in 4
.B

friend boolean operator !=(const String& l, char* r)
.in 7
.fi

.in 4
.B

friend boolean operator ==(const String& l, char r)
.in 7
.fi

.in 4
.B

friend boolean operator !=(const String& l, char r)
.in 7
.fi


.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 operator char*() const
.in 7
.fi
type conversion from String to char* 
.in 4
.B

 String(char* i)
.in 7
.fi
Copy a null-terminated string to this. 
.in 4
.B

 String(const String& i)
.in 7
.fi
Copy i to this. 
.in 4
.B

 String(sint32 length = 24)
.in 7
.fi
Construct an empty string. Size of the allocated char table is given optionally. Useful when you roughly know the  maximum length of the String but  build the String little by little starting from a short String. 

.SH FILE
string.hxx
