.TH Message 3 - 
.SH CLASS
Message (abstract base class, only derived classes can be instantiated)
.SH PUBLIC BASE CLASSES
.in 4
.B
Runner
.in 7
.fi


.SH DESCRIPTION
.fi

Messages are packaged service requests (function calls) 
carrying the parameters of the call along with a service provider
pointer and a service user pointer.
Messages can be put into a queue to be handled later or
sent to a remote service provider (sp).
Messages can be created explicitly,
but usually they are created implicitly by agents.
Derived message classes are generated automatically by the OTSO prepro
for all the functions in interface classes.

Running a message invokes the packaged function call.
Message should be run only in the receiver's memory space.

.SH Priorities
Runner::priority() has an effect only in certain Group types 
such as (Fair)PriorVec, but not Fifo or Ring.  
Priorities, however, could be used also in
derived implementations of Runner::runOrQueue and Runner::sendOrQueue().

By default, messages have the priority Runner::defaultRunnerPriority.
If you wish to have a different priority for all instances of 
a Message class M, define a otsoRunnerPriority() function:
.nf

  //file iface.hx
  interface class IFace {
  public:
    virtual void slowMsg() = 0;
    virtual void fastMsg() = 0;
  };


  //file IFACE.cx
  #include "iface.hxx"
  Runner::RunnerPriority otsoRunnerPriority(IFace_fastMsg*) {
    return Runner::highRunnerPriority; //or some other priority value
  }
  //...
  //generated code goes here ...

.fi
IFace_fastMsg constructors call an otsoRunnerPriority function.
Often there is no need to define a special priority,
so the message constructor gets the priority by calling 
otsoRunnerPriority(Runner*) that returns defaultRunnerPriority.
Another example can be found in /otso/demo/gamble/casinoSP.cx.
The priority of a single Runner instance can be changed by calling
setPriority(), but this is clumsy with messages.

.SH BUGS
Some of publics mbs should be protected/private.

Delay timeLeft for deadline scheduling (?)

 
.SH PUBLIC MEMBERS

.in 4
.B

Object* source()
.in 7
.fi
 
.in 4
.B

Process* sourceProcess()
.in 7
.fi
 
.in 4
.B

String sourceName() const
.in 7
.fi
 
.in 4
.B

void setSourceName(const String& n)
.in 7
.fi
 
.in 4
.B

Object* dest()
.in 7
.fi
 
.in 4
.B

Process* destProcess()
.in 7
.fi
 
.in 4
.B

void setSource(Object* o, Process* p =thisProcess, ConnectionId c =0)
.in 7
.fi
 
.in 4
.B

void setDest(Object* o, Process* p =thisProcess, ConnectionId c =0)
.in 7
.fi
Sets the receiver of the message (spObject) that can receive this.  o must be a Runner (?). 
.in 4
.B

virtual void setHandlerPart(void* )
.in 7
.fi
Sets the pointer to an instance that can run a message to a particular interface  (spInterface).  spInterface != spObject Derived Messages have a <interface>Ptr 
.in 4
.B

MsgId& id()
.in 7
.fi
to get return value to the correct place 

.SH Sending
 
.in 4
.B

virtual Message* send()
.in 7
.fi
Deliver this message.  Return  objectify(returnValue_), or 0 if void or  async message. 
.in 4
.B

ReturnValue sendAndReturnAValue()
.in 7
.fi
Deliver this and wait for a return value. 
.in 4
.B

void sendReturnValue(ReturnValue returnValue)
.in 7
.fi
Deliver return value from the server to the service user. 
.in 4
.B

void sendViaChannel()
.in 7
.fi
 

.SH Return values
 
.in 4
.B

boolean isReturnMsg
.in 7
.fi
true if carries a return value  
.in 4
.B

virtual ReturnValue returnValue()
.in 7
.fi
Points to return value if isReturnMsg. Redefined by derived messages that return sg else than "void" or "async". 

.SH Time and Simulation
 
.in 4
.B

Time time()
.in 7
.fi
simulation; not used so far 
.in 4
.B

Delay wait
.in 7
.fi
time still to wait in sender's futureQ 
.in 4
.B

void printNameFromTo(Ostream& os)
.in 7
.fi
Prints the message name, source, and  destination, but not the parameters. 
.in 4
.B

void printAndDelete(Ostream& os)
.in 7
.fi
Called when there is no receiver 
.SH PROTECTED MEMBERS

.in 4
.B

virtual MultiPtr* multiPtr()
.in 7
.fi
XXXPtr of a derived message. Used when sending a return value. 
.in 4
.B

Type* returnValueType_
.in 7
.fi
The type of the return value 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Message()
.in 7
.fi


.SH FILE
message.hxx
