.TH ISOservices 3 - 
.SH CLASS
ISOservices
.SH PUBLIC BASE CLASSES
.IP Object 10


.SH DESCRIPTION
.fi

The class "ISOservices" provides table services that allow a OTSO
"provider/entity" string to be mapped to a "selector" and/or an
application entity title (aet) string.

It can be constructed from the "dvopservices" (5) file.

An example of a provider/entity string would be: "tsap/session"

A selector may be a 2 byte GOSIP selector (e.g. #02) , or some 
other type of implementation dependent string (e.g. "pres").

An application entity title (aet) is defined in some OSI standard (ACSE maybe ?)
as an ASN.1 OBJECT IDENTIFIER which looks like a "dotted" numeric string
(e.g 17.1.14.0.1).    AET's are defined in various OSI standards for
application specific objects and purposes.

Here are some specific examples from a sample "dvopservices" (5) file
that may clear up what information mapping is provided in ISOservice:
.nf





"tsap/session"	"#01"
"tsap/echo"	"#128"


"psap/ftam"	"#259"	"1.17.4.0.16"
"psap/dtam"	"#259"	"1.17.4.0.17"
"psap/x500"	"#257"	"1.17.4.0.14"
.fi

The basic idea of ISOservices is to provide a mapping from a 
"provider/entity" pair to an "aet" or "selector", and vice versa.

.SH SYNOPSIS
.nf
 #include "isoservices.hxx"
.fi

.SH EXAMPLES
.nf
 #include "isoservices.hxx"

 ISOservices service_table;

 -- create service table from file "dvopservices"
 if (service_table.read_servents())
 {
     cout << "OTSO service table : " << service_table << "\\n";

     char *selector = NULL;
     char *service = "psap/ftam";

     if (selector = service_table.entity2selector (service))
     {
         ...
     }
     ...
 }
 }
.fi

.SH SEE ALSO
.nf
dvopservices (5)  dvopshosts (5)  ISOhosts(3)
.fi

.SH BUGS
.nf
Hopefully, we can replace this with a real x500 Directory 
implementation someday.

All entries in the "dvopservices" table should be unique.
.fi

.SH AUTHOR
.nf
Largely based on work done by Marshall Rose and the Wollongong group for
ISODE.
.fi
 
.SH PUBLIC MEMBERS

.in 5
.B

char* entity2aet(char* , char* )
.in 10
.fi
 Convert entity string to aet string 
.in 5
.B

char* entity2selector(char* , char* )
.in 10
.fi
 Convert entity string to   selector string 
.in 5
.B

char* aet2entity(char* , char* )
.in 10
.fi
 Convert aet to entity string. 
.in 5
.B

char* aet2selector(char* , char* )
.in 10
.fi
 Convert aet to selector string. 
.in 5
.B

char* selector2entity(char* , char* )
.in 10
.fi
 Convert selector to entity   string. 
.in 5
.B

char* selector2aet(char* , char* )
.in 10
.fi
 Convert selector to aet string. 
.in 5
.B

int read_servents()
.in 10
.fi
 Create servent table from file  "dvopservices". 
.in 5
.B

void print(ostream& )
.in 10
.fi
 cout << ISOservices; 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 ISOservices()
.in 10
.fi



.SH FILE
isoservices.hxx
