.TH ISOhosts 3 - 
.SH CLASS
ISOhosts
.SH PUBLIC BASE CLASSES
.IP Object 10


.SH DESCRIPTION
.fi

The class "ISOhosts" performs a mapping between "hostname" strings 
(or aliases) to their ISO addresses (psap+ssap+tsap+nsap+naddr)
strings.  The ISO address strings are stored in the "String Encoding
of Presentation Addresses" proposed by Steven Kille.

Used together with the file dvophosts (5n)

Remember to set the OTSO global pointer:
	extern ISOhosts *global_iso_hosts;	
if you wish to change to the default host table used by OTSO.

.SH SEE ALSO
.nf
isomacros(3) isoaddrs(3) isoservices (3)
dvopmacros(5) dvopaddrs(5) dvopservices (5)
.fi

.SH SYNOPSIS
.nf
 #include "isohosts.hxx"
.fi

.SH EXAMPLES
.nf
 #include "isoaddrs.hxx"
 #include "isohosts.hxx"

 ISOhosts host_table;

 -- Create host table from config file "dvophosts"
 if (host_table.read_hosts()) 
 {
     --  print out all hostname mappings
     cout << "Possible hosts : " << host_table;

     char *hostname = "bullwinkle.moose.tel.fi";
     char *killeStr=NULL;
     PSAPaddr *paddr=NULL;

     -- convert "hostname" to a PSAP address.
     if (killeStr = host_table.hostname2value (hostname))
     {
         paddr = new PSAPaddr(killeStr);
         ...
     } else {
         cerr << "Error: Unknown OTSO host " << hostname << "\\n";
         ...
     }
     ...
 }
.fi
 
.SH PUBLIC MEMBERS

.in 5
.B

char* hostname2value(char* )
.in 10
.fi
 Convert a hostname string  to a steven kille format  presentation address string. 
.in 5
.B

int read_hosts()
.in 10
.fi
 Create a ISOhosts table from  a configuration file such as  "dvophosts". 
.in 5
.B

void print(ostream& )
.in 10
.fi
 cout << ISOhosts; 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 5
.B

 ISOhosts()
.in 10
.fi



.SH FILE
isohosts.hxx
