.TH FrameBlock 3 - 
.SH CLASS
FrameBlock

.SH DESCRIPTION
.fi

Class FrameBlock is used for efficient I/O between files and Frames
without copying.

.SH EXAMPLES
Reading from file to Frame f at most n bytes without copying:
.nf

  FrameBlock fb(n);
  int nRead = ::read(fd, fb, i);
  Frame f(fb, nRead);

  oldFrame.putPrefix(f);

.fi

.SH BUGS 
 
.SH PUBLIC MEMBERS

.in 4
.B

sint32 size() const
.in 7
.fi
max size, i.e. 'n' given in constructor. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 operator Byte*() const
.in 7
.fi
Returns a pointer to an array of 'n' bytes. 'n' is given in constructor. 
.in 4
.B

 FrameBlock(sint32 n)
.in 7
.fi
Create a CVOPS DATA_BLOCK of 'n' bytes. 

.SH FILE
frame.hxx
.TH Frame 3 - 
.SH CLASS
Frame
.SH PUBLIC BASE CLASSES
.in 4
.B
Object
.in 7
.fi


.SH DESCRIPTION
.fi

A Frame is a byte string of arbitrary length.
It hides the memory allocation problems from the user.
Frames are used for carrying binary data, usually encoded user and
protocol data, within the local system.  Most often,
Frames carry data from one protocol layer to another.

Frame is a OTSO object but closely related to the CVOPS FRAME.
Actually, a OTSO Frame object encapsulates a
CVOPS "FRAME struct".

This was necessary to re-use CVOPS/(Nokia CASN) source code 
in OTSO.  Please, don't ever use the fptr variable (CVOPS frame)
directly, it will be made into a "private" variable someday.

Efficient I/O from/to files: see class FrameBlock.

.SH WARNING 
Frame::operator= is not a true assignment operator.  It moves the
the FRAME, it doesn't copy it.  The same is true for Frame
constructors. This is to prevent multiple copies of Frames from
profiliferating like crazy.
The same is also true of the Frame constructor Frame(Frame&):
.nf

  Frame a(20);          -- 20 byte frame
  a.putPrefix('a');     -- add byte to Frame
  Frame b(a);           -- Constructs Frame b from Frame a, 
                        -- by MOVING Frame a to Frame b.

If you want to copy a into b, you need to say so explicitly.

  Frame b(a.copy());	-- Construct Frame b from Frame a, no move.
.fi

.SH BUGS

FRAME* fptr (the CVOPS FRAME) should be private

Juha: operator<< functions could be defined as an alternative (?) syntax
for putSuffix functions.  And each protocol with its own encoding
functions might define its own operator<< functions.
operator>> functions in the same way for decoding.
Therefore Frame should be an IOstream.

.SH MODIFICATIONS
Used to be derived from Ostream, 
but it was inefficient and somewhat misleading.
Actually Frame should inherit from IOstreamSP, but there is no such class.
 
.SH PUBLIC MEMBERS


.SH Inserting bytes
 
.in 4
.B

Frame& putPrefix(Bytes& prefix)
.in 7
.fi
Puts Byte string onto front of this Frame. Moves bytes, does not copy. Warning: DESTRUCTIVE to argument! 
.in 4
.B

Frame& putPrefix(Frame& prefix)
.in 7
.fi
Put Frame (f) onto front of this frame, i.e. combine frames, and empties Frame f. Moves bytes, does not copy. Warning: DESTRUCTIVE to argument! 
.in 4
.B

Frame& putPrefix(Byte prefix)
.in 7
.fi
Put one byte onto front of this Frame.  Use the other two putPrefix() functions rather than this whenever possible. 
.in 4
.B

Frame& putSuffix(Byte )
.in 7
.fi
Put a byte onto end of this Frame -- Not Implemented. 
.in 4
.B

Frame& putSuffix(Bytes& )
.in 7
.fi
Put Byte string onto end of this Frame -- Not Implemented. 
.in 4
.B

Frame& putSuffix(Frame& f)
.in 7
.fi
Put Frame f onto end of this Frame, i.e. combine Frames, empties Frame f. Warning: DESTRUCTIVE to argument f! 

.SH Extracting and deleting bytes
 
.in 4
.B

Bytes getBytes(sint sz)
.in 7
.fi
Removes sz bytes from front of this Frame and returns the bytes. The resulting Bytes is 'sz' bytes long even if this had not that many bytes. 
.in 4
.B

Frame getFrame(sint sz)
.in 7
.fi
Returns a split of sz bytes  from front of this Frame. Inefficient. 
.in 4
.B

void deleteBytes(sint sz)
.in 7
.fi
Remove sz bytes from front of this Frame. 
.in 4
.B

void reset()
.in 7
.fi
Remove all bytes from this frame. 
.in 4
.B

FRAME* chop()
.in 7
.fi
Returns a pointer to the CVOPS FRAME, and  removes the CVOPS FRAME from this Frame. 

.SH Assignment
 
.in 4
.B

Frame& operator =(Frame& f)
.in 7
.fi
Takes bytes away from rhs and gives them to this.  No copying.   Previous value of this Frame is deleted. Warning: rhs will get empty! 
.in 4
.B

Frame& operator =(Bytes& rhs)
.in 7
.fi
Takes bytes away from rhs and gives them to this.  No copying.   Previous value of this Frame is deleted. Warning: rhs will get empty! 

.SH Copying bytes
 
.in 4
.B

Frame copy()
.in 7
.fi
Return a copy of this frame. 
.in 4
.B

Bytes copyBytes(sint sz)
.in 7
.fi
sz bytes copied from the front of this Frame. 

.SH Miscellaneous
 
.in 4
.B

sint32 length()
.in 7
.fi
Number of bytes in this Frame. 
.in 4
.B

Byte& operator [](sint32 i)
.in 7
.fi
Treat Frame as an array of bytes, an index of 0 gives first byte. Inefficient 

.SH Printing, asking
 
.in 4
.B

void setAsn(boolean i)
.in 7
.fi
Says if this is ASN.1 structured Frame. Affects printing format. 
.in 4
.B

void asnPrint(Ostream& os)
.in 7
.fi
pretty-printing for ASN.1 structured Frames. 
.in 4
.B

void print(Ostream& os)
.in 7
.fi
Prints out this Frame in hex/ascii by default.  Special pretty-printing of ASN.1 structured frames, see setAsn(). 
.in 4
.B

void ask(Istream& is)
.in 7
.fi
User input of Frame. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Frame(sint32 dbSize = DB_SIZE)
.in 7
.fi
Creates an empty Frame.  Data block size is determined here, allowing the application programmer to make a choice between  time efficiency (big dbSize) and space efficiency (small dbSize). 
.in 4
.B

 Frame(Frame& f)
.in 7
.fi
Removes data from f, puts it to this  without copying. Warning: this is NOT a copy-constructor,  DESTRUCTIVE to argument f! 
.in 4
.B

 Frame(FRAME** cFrame)
.in 7
.fi
Removes data from cFrame, puts it to this  without copying. Sets *cFrame = 0. Warning: DESTRUCTIVE to argument f! 
.in 4
.B

 Frame(FrameBlock& fb, sint32 realSize)
.in 7
.fi
Used for efficient I/O. See example above. 

.SH MORE ABOUT CLASS Frame
.in 4
See also class Bytes. 

.SH FILE
frame.hxx
