.TH DynDir 3 - 
.SH CLASS
DynDir
.SH PUBLIC BASE CLASSES
.in 4
.B
VoidFifo
.in 7
.fi
Implementation reuse only; public because conversion from this to Object* needed. 

.SH DESCRIPTION
.fi

DynDir is a list of Named Objects, instances of class NamedObj.
NamedObjs can be inserted here, and the pointer can be gained by
giving a name.

The external pointer 'namedObjs' is OTSO's pointer to a 
directory of NamedObjs with names.  
There is one namedObjs in each operating system process.
It is used to find a pointer to
a NamedObj, when the name is known. 'namedObjs' is defined in dyndir.cxx

A name is given to an namedObj by NamedObj::setName(...).
It causes the NamedObj instance to be inserted to namedObjs.
dout << *::namedObjs;  can be used to print out the current list of
named objects OTSO knows about.

.SH BUGS
Awfully slow.

.SH MODIFICATIONS
 
.SH PUBLIC MEMBERS

.in 4
.B

NamedObj* pointer(String& name)
.in 7
.fi
Returns pointer to a NamedObj  that has the given name;  dummyNamedObj if not found. 
.in 4
.B

void* servicePointer(String spName, String serviceName, Object*& sp)
.in 7
.fi
Returns a pointer to the  'serviceName' part of 'spName'  object.  Class of 'spName' should be  derived from the interface class 'serviceName'.  At exit, sp will point to the Object part of 'spName'. If 'spName' does not exist, or if it does not provide 'serviceName', 0 is returned. Wildcards not ok in arguments. 
.in 4
.B

void insert(NamedObj* o)
.in 7
.fi
Inserts o into this so that pointer(o->name()) will return o. If this already has an object with the same name as o, the old one will be removed from this. 
.in 4
.B

virtual void selectElementsWithMember(String memberName, Group& q)
.in 7
.fi
Iterates through the elements of this and puts those elements that have a member with the name 'memberName' into q.  In general, memberName is a name of an interface class.  *this is not changed. Wildcards not ok in 'memberName'. 

Should be declared in Group?? 
.in 4
.B

void print(Ostream& )
.in 7
.fi
print out '(', list of NamedObj Names separated by space, and ')'. 

.SH FILE
dyndir.hxx
