.TH File_Device 3 - 
.SH CLASS
File_Device
.SH PUBLIC BASE CLASSES
.in 4
.B
Device
.in 7
.fi


.SH DESCRIPTION
.fi

A File_Device is used to create a OTSO Device from a
simple file.  Some examples of the type of files
it can be used for are :
  - real files (that reside on disk)
  - named pipes
  - stdin/stdout/stderr

Basically, it is possible to create a File_Device from any
OS object with an integer file descriptor:
  int fd;

.SH SYNOPSIS
  #ifndef DEVXFILE_HXX
  #include "/otso/include/devxfile.hxx"
  #endif

  File_Device	ascii_Dev ("otso.log");
  File_Device	ipipe_Dev ("input_pipe", namedPipe);
  File_Device	stdin_Dev (int fd=0);	

.SH SEE ALSO
.nf
 device.hxx devbsd.hxx
 init2.inc - An important place in OTSO, where a File_Device 
             is used is for the OTSO "userInputDevice".
.fi
 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 File_Device()
.in 7
.fi
 You can create a OTSO device from an ordinary file or a named pipe,  by specifying a "filename" string to the constructor.    If the named file doesn't exist, an attempt will be made to create it. 
 stub default ctor  
.in 4
.B

 File_Device(char* , NamedFileType typ =ordinary, Event e =ev_none)
.in 7
.fi
 Alternately, you can create a OTSO device by specifying an  integer file descriptor of an existing Unix file to the constructor.  Event Handlers for asynchronous events can also be specified for  the constructor (see class Device for more details). 
.in 4
.B

 File_Device(int d, Event e =ev_none, char* t ="BSD file")
.in 7
.fi


.SH FILE
devxfile.hxx
