.TH Device 3 - 
.SH CLASS
Device
.SH PUBLIC BASE CLASSES
.in 4
.B
Object
.in 7
.fi


.SH DESCRIPTION
.fi

"Device" is the base class for all OTSO devices.  In general, the
OTSO user will probably use derived OTSO devices such as File_Device,
Socket_Device, etc.   The OTSO Device Table however, is a table
of base class "Device"s.

.SH SYNOPSIS
.nf
Although, Device and DeviceTable are defined in OS specific
header files such as devbsd.hxx, you should include them by :

  #ifndef  DEVICE_HXX
  #include "/otso/include/device.hxx"	
  #endif
.fi

.SH SEE ALSO
devxfile.hxx devsock.hxx device.hxx
 
.SH PUBLIC MEMBERS

.in 4
.B

char* deviceName
.in 7
.fi
 An optional name, allocation via "new". 
.in 4
.B

static DeviceTable* pdeviceTable
.in 7
.fi
 The device table we are entered in. 
.in 4
.B

Event event
.in 7
.fi
 The host OS should "watch for" the occurance of   certain events on this Device.  When an event   occurs, the appropriate event handler may be called. 
.in 4
.B

Event pending
.in 7
.fi
 Events which are currently outstanding on this  Device and are awaiting service. 
.in 4
.B

int& fd()
.in 7
.fi
 Give a copy of Device's real file descriptor. 
.in 4
.B

virtual int Read(Frame& , int i =1024)
.in 7
.fi
 Default Device Reader (not used). 
.in 4
.B

virtual int Write(Frame& )
.in 7
.fi
 Default Device Writer (not used). 
.in 4
.B

void print(Ostream& )
.in 7
.fi
 Redefined Object print, for  os << Device; 
.SH PROTECTED MEMBERS

.in 4
.B

int fDescr
.in 7
.fi
 Our physical Unix file descriptor  from open (2v) & close (2). 
.in 4
.B

virtual boolean eventHandler()
.in 7
.fi
 Event Handler: false - event wasn't handled,  true - event was handled. 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS

  Devices can only be constructed from 
.nf
	- other Devices
	- Device pointers
  	- physical Unix File Descriptors.
.fi

  When constructing a OTSO device from a File Descriptor,
  you can also specify (optionally):
.nf
	- an event to be watched on the Device by a
	  Device Table (such as an asych read).
	- an event handler to handle any events that occur.
	- A name for the device (for DeviceTable print() ).
	- A pointer to a DeviceTable where this Device should
	  be entered, the default being the default DeviceTable
	  for OTSO (pGlobalDevices).
.fi
 
.in 4
.B

 Device(int fd, Event  =ev_none, char*  =NULL, DeviceTable* d =::pGlobalDevices)
.in 7
.fi

.in 4
.B

 Device(Device& )
.in 7
.fi

.in 4
.B

 Device()
.in 7
.fi

.in 4
.B

 Device(Device* pdev)
.in 7
.fi


.SH FILE
devbsd.hxx
.TH DeviceTable 3 - 
.SH CLASS
DeviceTable
.SH PUBLIC BASE CLASSES
.in 4
.B
Runner
.in 7
.fi


.SH DESCRIPTION
.fi

A "DeviceTable" is a table of OTSO Devices.  
It is currently implemented as a simple static array of Devices.  

The following DeviceTable description is valid for Berkley Unix ONLY.

.nf
fd_set (see man select(2)):
 Besides having a table of OTSO devices, the DeviceTable also maintains
 Berkley fd_set's for monitoring read/write file descriptors.
 New fd's are added to the proper fd_set, when a new OTSO device is
 added (depending on the Event to be watched for the Device) to the
 DeviceTable.
.fi

A DeviceTable is also a Runner.  When  OTSO schedules the DeviceTable
to "run", it does the following:
.nf
  - Use Berkley select(2) call to check the fd_sets.
  - For each event that has occurred in an fd_set :
        - Find the corresponding OTSO Device.
        - Call the Device's event_handler if one exists,
          or set the flag "pending" in the Device.  Hopefully
          some other OTSO object's run() function will check the
          pending flag of the Device and handle it when they
          are scheduled (e.g. the OTSO userInputDevice is checked by 
          when the corresponding OTSO Istream is scheduled).
.fi

.SH NOTE
The use of an array in the OTSO DeviceTable was originally intended 
to allow static OTSO Device id's to uniquely identify OTSO Devices.
Also the DeviceTable in reality will usually contain a small
number of Devices that must be accessed quickly, and array seemed best
for this.

An implementation note: pdeviceArray[0] ... pdeviceArray[nactive-1]
are in use, the other elements are 0 pointers and free.

.SH BUGS
The time that the select() uses to wait is hardcoded right now.
When a global OTSO timer manager is available, the time select()
waits should be the least timer time in OTSO or some default if
no timers are available.
 
.SH PUBLIC MEMBERS

.in 4
.B

int active()
.in 7
.fi
 Number of active OTSO devices. 
.in 4
.B

boolean add(Device* )
.in 7
.fi
Add a user Device to OTSO Device table. Returns true iff successful. 
.in 4
.B

void remove(Device* )
.in 7
.fi
 Remove Device from OTSO Device table. 
.in 4
.B

virtual void run()
.in 7
.fi
 Check fd's via select, call appropriate  Device event handler for fd, or set  flag "pending" in Device. 
.in 4
.B

virtual void print(Ostream& )
.in 7
.fi
 os << DeviceTable;  

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 DeviceTable()
.in 7
.fi


.SH FILE
devbsd.hxx
