.TH Bytes 3 - 
.SH CLASS
Bytes
.SH PUBLIC BASE CLASSES
.in 4
.B
Object
.in 7
.fi


.SH DESCRIPTION
.fi

String is a class for null-terminated printable string manipulation.
Bytes is used to provide a
more general purpose byte-oriented class for use in 
Bytes is not necessarily null-terminated or printable, and may contain NULLs.

The length of a Bytes instance is determined at construction,
so it does not grow or shrink (except in assignment).
Use Frames if you don't know the limit of the size.
If you do know the limit, Bytes should be more efficient than Frame.

Notice that assignment and the "copy" constructor
changes the right hand side argument.  Bytes are moved, not copied!

The number of the first byte is 0.

If the char* used to construct the Bytes class is string of
hex digits ending in 'h/H/x/X' (e.g. "1234567890H"), it is assumed
that it is not an Ascii string, but a hex string and is stored
as the corresponding hex sequence. A string of binary digits '1' '0'
ending in a 'b/B' is assumed to be a bit string and is stored as
a hex byte seqence.  All other strings are assumed to be null-terminated
Ascii strings.

WARNING: The Bytes pointer 'st' points to the least significant byte.
The least significant byte is different for an Ascii string and a
hex/binary string.

.SH EXAMPLES
.nf
    Bytes ascii ("hello");     -- stored as: 68 65 6c 6c 6f 00
    Bytes hex ("1112345x");    -- stored as: 45 23 11 01
    Bytes bin ("0100010101b"); -- stored as: 15 01
                                              ^
                                    Bytes.st -^
.fi

.SH BUGS
Input data argument treated inconsistently in constructors.
 
.SH PUBLIC MEMBERS

.in 4
.B

char* st
.in 7
.fi
Byte string lives here. NOTE: asncodec.cxx needs this  to be public; please do not use. 

.SH Manipulating bytes
 
.in 4
.B

Bytes& operator =(Bytes& r)
.in 7
.fi
Remove bytes from r and put them to this without copying. Warning: not normal assignment. 
.in 4
.B

Byte& operator [](sint32 i) const
.in 7
.fi
Returns i'th byte, or dummyByte if i is out of range. 0 gives the first byte. 
.in 4
.B

Byte& elem(sint32 i) const
.in 7
.fi
Like [i] but faster because  no range check. 
.in 4
.B

Bytes copy()
.in 7
.fi
make a brand new copy of Bytes. 
.in 4
.B

void reset()
.in 7
.fi
make object empty. 

.SH Conversions
 
.in 4
.B

sint32 hex2str(char* acsii, uint8* hex, sint32 hexLen)
.in 7
.fi
bytes to hex Ascii string 
.in 4
.B

sint32 str2hex(uint8* hex, char* ascii, sint32 asciiLen)
.in 7
.fi
hex Ascii string to bytes 
.in 4
.B

sint32 bin2str(char* ascii, uint8* bin, sint32 binLen)
.in 7
.fi
bytes to binary Ascii string 
.in 4
.B

sint32 str2bin(uint8* bin, char* ascii, sint32 asciiLen)
.in 7
.fi
binary Ascii string to bytes 

.SH Miscellaneous
 
.in 4
.B

sint32 length() const
.in 7
.fi
Number of bytes. 
.in 4
.B

boolean operator ==(const Bytes& r) const
.in 7
.fi
True iff all bytes are equal. Compared byte by byte, eqyal address is not required. 
.in 4
.B

boolean operator !=(const Bytes& r) const
.in 7
.fi
False iff all bytes are equal. 
.in 4
.B

Byte* bytep() const
.in 7
.fi
Returns a pointer to the beginning of the byte array. 

.SH Printing, asking
 
.in 4
.B

void print(Ostream& os)
.in 7
.fi
dout << Bytes; 
.in 4
.B

void ask(Istream& is)
.in 7
.fi
user input of Bytes. 
.in 4
.B

void to(ODump& od)
.in 7
.fi
Channel encoder. 
.in 4
.B

void from(IDump& id)
.in 7
.fi
Channel decoder. 
.SH PROTECTED MEMBERS

.in 4
.B

sint32 sz
.in 7
.fi
length of byte string 
.in 4
.B

Bytes_type btype
.in 7
.fi
Type of string  (BYT_OCT, BYT_BIN, BYT_ASCII). 

.SH PUBLIC CONSTRUCTORS AND CONVERSIONS
.in 4
.B

 Bytes(sint32 size = 32)
.in 7
.fi
The size is determined here. The default is more or less arbitrary. 
.in 4
.B

 Bytes(Bytes& i)
.in 7
.fi
Takes the bytes away from i and gives them to this.  No copying. Warning: i is changed. 


.in 4
.B

 Bytes(const Bytes& bs, sint32 first = 0, sint32 length = 0x0FFFFFFF)
.in 7
.fi
Construct from bs, or a part of it: 'length' bytes starting from  'first'.  Bytes are copied! 
.in 4
.B

 Bytes(char* string)
.in 7
.fi
Construct from a NULL terminated string.  Strings ending in  'x', 'X', 'h', 'H', 'b, or 'B' have a special interpretation: see the class description above. 

.SH MORE ABOUT CLASS Bytes
.in 4
See also class Frame. 

.SH FILE
bytes.hxx
