.TH otsogrep 1 - 

.SH NAME
otsogrep \- search an OTSO trace file for a string or regular expression

.SH SYNOPSIS
otsogrep -riopp+p-avv+v- objectNamePattern [filename]

.SH DESCRIPTION
otsogrep is a grep-like tool tailored for filtering OTSO trace output.
otsogrep is closely related to bgrep.  

otsogrep compares input lines to patterns given in command arguments and, 
when the input line matches the given pattern,
prints the block that begins on the matching line
(in contrast to just the line printed by grep).
A block is a piece of text enclosed in braces 
(opened by '{' and closed by '}').
If the line matching the pattern opens more
braces than it closes, the subsequent lines are printed
until the block opened in the matching line has been closed.
An extra newline is printed after each match.

The first argument is one or more of the following:
.nf

	r      bgrep "*RUNNING*"
	o      bgrep "*SENDING MESSAGE*"
	i      bgrep "*RECEIVED MESSAGE*"
	p-     bgrep "*INPUT PARAMETERS*"
	p+     bgrep "*OUTPUT PARAMETERS*"
	p      bgrep "*INPUT PARAMETERS*" and "*OUTPUT PARAMETERS*"
	a      bgrep "*ACTIONS WHEN*"
	v-     bgrep "*VARIABLES BEFORE*"
	v+     bgrep "*VARIABLES AFTER*"
	v      bgrep "*VARIABLES BEFORE*" and "*VARIABLES AFTER*"
.fi

The second argument is object name pattern, a string that is searched for
on those lines that were matched by the first argument.
The only special character in the patterns (regular expressions) is
asterisk '*'.  It matches 0 or more instances of any characters.
The operating system command interpreter may interpret the '*' on the
command line, so it often is necessary to enclose the pattern in 
double quotes.

The third argument is an input filename or a list of them.
Standard input is read if no third argument is given. 

.SH EXAMPLES
.nf
otsogrep rp-ov+ monaco otso.log
tail -f otso.log | otsogrep r "tran*" 
.fi

.SH BUGS
Quoted or commented braces are also counted.

.SH SEE ALSO
OTSO bgrep, OTSO dingrep
