.TH bgrep 1 - 

.SH NAME
bgrep \- search a file for a string or regular expression

.SH SYNOPSIS
bgrep pattern [filename]

.SH DESCRIPTION
bgrep does the same thing as grep, but instead of printing one line 
for each match, this prints a block of lines.  
A block is a piece of text enclosed in braces 
(opened by '{' and closed by '}').
If the line matching the pattern opens more
braces than it closes, the subsequent lines are printed
until the block opened in the matching line has been closed.
An extra newline is printed after each match.

The only special character in the patterns (regular expressions) is
asterisk '*'.  It matches 0 or more instances of any characters.
The operating system command interpreter may interpret the '*' on the
command line, so it often is necessary to enclose the pattern in 
double quotes.

The second argument is an input filename or a list of them.  
Standard input is read if no second argument is given. 

.SH EXAMPLES
.nf
bgrep "tran*" logfile
tail -f logfile | bgrep tran_a
bgrep Fifo::put *.cxx
.fi

.SH BUGS
Quoted or commented braces are also counted.

No input file name printed (grep prints when more than one input file).

.SH SEE ALSO
Unix grep, OTSO otsogrep, OTSO dingrep
