##############################################################
# Name: /home/users/otso/official/otso/makes/SCCS/s.root.Makefile
# Vers: 5.17    Time: 92/09/14, 10:26:34
#
# Copyright (c) 1992      Technical Research Centre of Finland (VTT)
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that this notice and the reference to this notice appearing in each software
# module be retained unaltered, and that the name of any contributors shall not
# be used in advertising or publicity pertaining to distribution of the software
# without specific written prior permission.  No contributor makes any
# representations about the suitability of this software for any purpose.
# It is provided "as is" without any express or limited warranty.
#
#			NO WARRANTY
#
# ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
# EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
# DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
# TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
# OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
# SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
# COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
#
# As used above, "contributor" includes, but is not limited to :
#        The Technical Research Centre of Finland
#############################################################################


#######################################################################
#		Root Makefile for OTSO
#######################################################################


#######################################################################
# 		Make variables
#######################################################################

# There is a local make script in each directory
MAKE	= ./make
SHELL	= /bin/sh


DLIBS	=	enviros dvops enviros/device/bsd isoaddrs \
		$(SIMUDIR) $(AWESIMEDIR) 


# libclasn #casnsupport

GEND	=	dvops/gend
PLIBS	=	$(NETLIB) $(TRANLIB) appli/simpleFileTransfer
#$(SESSLIB) $(PRESLIB) $(APPLLIB)

TUTORIALS = 	tutorial/tut1 tutorial/tut2 
EXES	=	tools $(TUTORIALS) 
# demo/Examples/timerdemo demo/Examples/isoaddr 
# demo/Telephone/otso-self-phone demo/Telephone/otso-tcp-phone  

#
# protocols should be built from lowest to highest layer,
# to make sure lower layer .hxx's are installed properly.
# Many upper layers must use lower layer .hxx's.
#
NETLIB  = protocols/3/cons/all protocols/3/cons/demo protocols/3/clns
TRANLIB = protocols/4/all protocols/4/tran0
SESSLIB = protocols/5.vtt/simple_sess
PRESLIB = protocols/6.vtt
APPLLIB = protocols/7.vtt/acse protocols/7.vtt/simple


DIRS	=	$(DLIBS) $(PLIBS) $(EXES)

OTHERS	=


#######################################################################
# 		OTSO Compilation Targets
#######################################################################

#
# The order of 'all' is somewhat important (e.g. dlib must be made 
# before protocols, demos):
#	1st: dvops + device libs
#	2nd: gend
#	     prepro
#	3rd: protocol libs
#	4th: demos
#	5th: documents
# 	6th: your stuff
#

all:	dlib gend prepro-all plib exe-all documents
	@-echo "*****************************************************"
	@-echo "	 Congratulations! OTSO Build Completed."
	@-echo "*****************************************************"

inst-all: all


dlib:;		@echo "-------- make target: dvops lib -------------"
		@for i in $(DLIBS); \
		    do (echo "cd $$i; $(MAKE) all"; \
			cd $$i; $(MAKE) all; \
			echo "$(MAKE) inst-all"; \
			$(MAKE) inst-all); \
		    done

gend:;		@echo "-------- make target: dvops/gend -------------"
		@for i in $(GEND); \
		    do (echo "cd $$i; $(MAKE) all"; \
			cd $$i; $(MAKE) all; \
			echo "$(MAKE) inst-all"; \
			$(MAKE) inst-all); \
		    done

plib:;		@echo "-------- make target: protocol lib -------------"
		@for i in $(PLIBS); \
		    do (echo "cd $$i; $(MAKE) all"; \
			cd $$i; $(MAKE) all; \
			echo "$(MAKE) inst-all"; \
			$(MAKE) inst-all); \
		    done

prepro-all:;	@echo "-------- make target: OTSO mini-compiler ----------"
		@for i in prepro; \
		    do (echo "cd $$i; $(MAKE) all"; \
			cd $$i; $(MAKE) all; \
			echo "$(MAKE) inst-all"; \
			$(MAKE) inst-all); \
		    done

exe-all:;	@echo "-------- make target: executables -------------"
		@for i in $(EXES); \
		    do (echo "cd $$i; $(MAKE) all"; \
			cd $$i; $(MAKE) all; \
			echo "$(MAKE) inst-all"; \
			$(MAKE) inst-all); \
		    done

install:	all clean





lint:;		@for i in $(DIRS); \
		    do (echo "cd $$i; $(MAKE) lint"; \
			      cd $$i; $(MAKE) lint); \
		    done


#########################################################################
#			CLEANING UP DIRECTORIES
#########################################################################

# clean leaves ./lib/*.a ./bin/* and other executables;
# 	it removes .o's and other local clutter.

clean:;		@echo "----------- make target clean ------------"
		-rm -f lib*.a *.tmp *.old master.doc
		-find . -type f -name \*.[oa] -exec rm -f {} \;
		@for i in $(DIRS) $(OTHERS); \
		    do (echo "cd $$i; $(MAKE) clean"; \
			      cd $$i; $(MAKE) clean); \
		    done

protocol-clean:;	@echo "----------- make target clean ------------"
		@for i in $(PLIBS); \
		    do (echo "cd $$i; $(MAKE) clean"; \
			      cd $$i; $(MAKE) clean); \
		    done

# tar-clean tries to remove everything that can be recompiled
# from source code.   This will make 'tar' files smaller, and
# more useful for moving OTSO to new machines.  Make sure
# to run 'make look-opend' and close open deltas first.

tar-clean:	clean
		-rm -f ./bin/*
		-rm -f ./lib/*.a
		-rm -f ./include/protocols/*.hxx
		@for i in prepro tools appli/simpleFileTransfer $(TUTORIALS); \
		    do (echo "cd $$i; $(MAKE) tar-clean"; \
			      cd $$i; $(MAKE) tar-clean); \
		    done


#########################################################################
#		BACKUPS and RELEASES
#########################################################################

#
# Minimal release : Openly Available OTSO version released to anyone
#
public-release:		otso-public.tar.Z

# 
# OTSO version release to VTT related companies and institutions.
# Includes some extra "clutter"
#
protected-release:	otso-protected.tar.Z

#
# OTSO version used internally at VTT/TEL.  Includes some extra "clutter".
#
backup:			otso-private.tar.Z
private-release:	otso-private.tar.Z


#
# OTSO backed up using tel3's remote tape drive.
#
tel3.tar:	otso-private.exclude
	-@echo "*** Writing OTSO tarfile to tel3 cartridge ***"
	tar cvFFXfb otso-private.exclude - 126 . | rsh tel3 dd of=/dev/rst8 obs=126b

tel3.untar:;	rsh tel3 dd if=/dev/rst8 ibs=126b | tar xvBfb - 126



otso-private.tar.Z:	otso-private.tar
	-rm -f otso-private.tar.Z
	compress otso-private.tar

otso-protected.tar.Z:	otso-protected.tar
	-rm -f otso-protected.tar.Z
	compress otso-protected.tar

otso-public.tar.Z:	otso-public.tar
	-rm -f otso-public.tar.Z
	compress otso-public.tar


#
# Private Exclude file:
#  - These files/directories are excluded from private release and backup! 
#  - Don't tar any executable file bigger than 50*512 bytes (50 blocks)
#  - Don't tar SCCS dirs, .o .a *~ #*# tar.* *.tar     etc.
#  - Don't tar any files in a directory called "copyright", these
#    directories contain copyrighted header files.
#  - Juha 12.8.92: removed "otso-protected|otso-private" from exclude list
#
#  - KEEP THESE LISTS OF FILE NAME PATTERNS UP TO DATE WITH 
#    docs/file.names.and.access !
#
private_exclude:;	
	-@echo ""
	-@echo "*** Making otso-private.exclude ***
#	-@echo "*** This is " $(SIMULATING_OR_NOT_RELEASE) " , edit enviros/envOTSO.h and Makefile if this is not what you want to compile ***"
	-@echo "*** WARNING : Some files are not included in this backup/private release : ***"
#	-cd dvops/gend 
#	-make memdbgSP.cxx memdbg.cxx timerSP.cxx timer.cxx
#	-cd ../..
	@for i in dvops/gend ; \
	  do (cd $$i; $(MAKE) memdbgSP.cxx memdbg.cxx timerSP.cxx timer.cxx); \
	  done
	-rm -f ./otso-private.tar ./otso-private.tar.Z
	-rm -f ./otso-protected.tar ./otso-protected.tar.Z
	-rm -f ./otso-public.tar ./otso-public.tar.Z
	-@echo "./otso-private.tar" > otso-private.exclude 
	-@echo "./otso-private.tar.Z" >> otso-private.exclude 
	-@echo "./otso-protected.tar" >> otso-private.exclude 
	-@echo "./otso-protected.tar.Z" >> otso-private.exclude 
	-@echo "./otso-public.tar" >> otso-private.exclude 
	-@echo "./otso-public.tar.Z" >> otso-private.exclude 
	-find . -type f -perm -100 -size +50 -print >> otso-private.exclude
	-find . -print | egrep "\.[oazZ]$$|\.tar$$|/core$$|tmp$$|temp$$|/tmpa\.|\.exclude$$|\.log$$|generated|/SCCS$$|~$$|/\#*\#$$|/version.local$$|/version.major$$|/version.minor$$|" >> otso-private.exclude

#
# Protected Exclude file:
#  - These files/directories are excluded from protected release!
#  - Basically same as Private Exclude file
#  - In addition, don't take the "clutter" that clutters up OTSO
#    directories.  The "clutter" quite often needs to be backedup since
#    it represents work in progress, but it shouldn't clutter up
#    a relase to the outside world.
#
protected_exclude:	private_exclude
	-@echo ""
	-@echo "*** Making otso-protected.exclude ***
	-@echo "*** Warning : some "clutter" excluded from protected release : ***"
#	-mv
	-cp otso-private.exclude otso.exclude.tmp
	-find . -print | egrep "vtt$$|copyright|exp$$|tst$$|test$$|jfr$$|juha|old$$|save$$|keep$$|" >> otso.exclude.tmp
	-sort otso.exclude.tmp > otso-protected.exclude
	-rm otso.exclude.tmp

#
#  - Files/directories excluded from public release:
#
public_exclude:	protected_exclude
	-@echo ""
	-@echo "*** Making otso-public.exclude ***
	-@echo "*** Did you remember to switch simulation code off (/on) ? ***"
#	-mv
	-cp otso-protected.exclude otso.exclude.tmp
	-find . -print | egrep "\.protected$$|lut$$" >> otso.exclude.tmp
	-sort otso.exclude.tmp > otso-public.exclude
	-rm otso.exclude.tmp


otso-private.tar:	private_exclude
	-@echo "*** Creating OTSO backup tarfile: otso-private.tar ***"
	-@rm -f ./otso-private.log ./otso-private.tar*
	-@echo "Last OTSO backup started by"  $$LOGNAME " on : " `date` >> ./otso-private.log
	tar cvFFXf otso-private.exclude otso-private.tar .
	-@echo "Last OTSO backup finished : " `date` >> ./otso-private.log

otso-protected.tar:	protected_exclude
	-@echo "*** Creating OTSO release tarfile: otso-protected.tar ***"
	-@rm -f ./otso-protected.log ./otso-protected.tar*
	-@echo "Last OTSO release started by : " > ./otso-protected.log
	-@echo "	" $$LOGNAME " on: " `date` >> ./otso-protected.log
	tar cvFFXf otso-protected.exclude otso-protected.tar .
	-@echo "Last OTSO release finished : " `date` >> ./otso-protected.log
		
otso-public.tar:       public_exclude
	-@echo "*** Creating OTSO public tarfile: otso-public.tar ***"
	-@rm -f ./otso-public.log ./otso-public.tar*
	-@echo "Last OTSO public started : " > ./otso-public.log
	-@echo "        " $$LOGNAME " on: " `date` >> ./otso-public.log
	tar cvFFXf otso-public.exclude otso-public.tar .
	-@echo "Last OTSO public finished : " `date` >> ./otso-public.log

look-opend:;	-@echo "OPEN DELTAS :"
	-@ls -l */SCCS/p* */*/SCCS/p* */*/*/SCCS/p*



#######################################################################
# 		Generating OTSO documentation
#######################################################################

documents:;	-@echo "Creating OTSO documentation." 
	@for i in include enviros/device/include ; \
	do (echo "cd $$i; $(MAKE) documents"; \
	  cd $$i; $(MAKE) documents); \
	done


#######################################################################
# Configuring OTSO
#	New and improved method to configure OTSO.
#	Fun and excitement for the whole family !  Try it !
#######################################################################

config-help:; -@echo "****************************"
	-@echo "*** You may have to edit the following files (on supported"
	-@echo "*** configurations) to suit your own LOCAL needs"
	-@echo "*** (directory /otso/enviros):"
	-@echo "*** 	env_sel.h, envCC.h, envOS.h, envOTSO.h,"
	-@echo "***     makes/env_simu.make, makes/system.make"
	-@echo "***"
	-@echo "*** To add new platforms/compilers, you might need to write"
	-@echo "*** your own :"
	-@echo "***	otso/enviros/env*.[ch]*"
	-@echo "***	otso/enviros/makes/<arch>.make"
	-@echo "*** See these files for more details."
	-@echo "***"
	-@echo "*** Supported configurations :"
	-@echo "***   config-sun-owc	- Sun with ObjectWorks C++ 2.1"
	-@echo "***   config-hpux	- HPUX with HP C++"
	-@echo "****************************"
	-@echo ""


config-sun:	config-help 
	-mv  ./enviros/makes/system.make     ./enviros/makes/system.make.old

# Sun with ObjectWorks C++ 2.1 (or any other 2.1 or later should try this)
config-sun-owc:		config-sun
	echo  "ENVFLAGS = -D__OWCCPP__" > ./enviros/makes/system.make
	cat   ./enviros/makes/env_simu.make >> ./enviros/makes/system.make
	cat   ./enviros/makes/sun.make >> ./enviros/makes/system.make
	make tar-clean

# Sun with Sun C++ 2.0 (or any other C++ 2.0 compiler should try this)
config-sun-suncc:	config-sun
	echo "ENVFLAGS = -D__SUNCPP__" > ./enviros/makes/system.make
	cat   ./enviros/makes/env_simu.make >> ./enviros/makes/system.make
	cat   ./enviros/makes/sun.make >> ./enviros/makes/system.make
	make tar-clean

config-hpux:	config-help
	-mv  ./enviros/makes/system.make     ./enviros/makes/system.make.old
	cat   ./enviros/makes/env_simu.make >> ./enviros/makes/system.make
	cp  ./enviros/makes/hpux.make     ./enviros/makes/system.make
	make tar-clean

config-gra.vtt.fi:	config-help 
	mv    ./enviros/makes/system.make     ./enviros/makes/old.system.make
	ln -s gra.make ./enviros/makes/system.make
	make tar-clean

#
# Add new configurations above !
#

help:;	-@cat ./docs/help/make-targets.hlp
