/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/include/SCCS/s.time.hxx
 * Vers: 5.1    Time: 92/08/03, 15:51:51
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/*********************************************************
* FILE
*       time.hxx
**********************************************************/

/********************************************************
Class Time is a generic timekeeping class that should
be used as an interface to host operating system's time 
system calls.

BUGS
*********************************************************/

class Time: public Object {
private:
	uint32	sec;	// seconds since Jan. 1, 1970
	uint32	usec;	// and microseconds
	boolean	set;
public:
	Time();
	Time(const Time& t);
	Time(uint32 s, uint32 us = 0) { sec = s; usec = us; set = true; }
	Time(double d)	// in seconds 
        {
	  if (d != 0) { sec = (uint32)d; usec = (uint32)((d - sec) * 1000000);}
          else        { sec = 0; usec = 0; }
	  set = true;
	}
//#if COMPILER_OWC	/*all C++ >= 2.1 compilers need this (?)*/
	Time (int s) {
		// !! NONPORTABLE !! - int is not a safe portable type 

		// HACK: without this: Time fn() { return 0; } is ambiguous
		// because retval could be double or unsigned long
		// and compiler doesn't know which ctor to use.
		// Time::operators can also be ambiguous for CC without it.
		sec = (uint32)s; usec = 0; set = true;
	}
//#endif
	uint32	secs()		{ return sec; }
	uint32	usecs()		{ return usec; }
	void	setTime(const Time& t)
				{ sec = t.sec; usec = t.usec; set = true; }
	void	setTime(uint32 s, uint32 us = 0)
				{ sec = s; usec = us; set = true; }
	boolean	isSet()		{ return set; }
	void	reset()		{ set = false; }
	boolean	operator==(const Time& t);
	boolean	operator!=(const Time& t);
	boolean	operator<(const Time& t);
	boolean	operator>(const Time& t);
	boolean	operator<=(const Time& t);
	boolean	operator>=(const Time& t);
	Time	operator+(const Time& t);
	Time	operator-(const Time& t);
	Time	operator+=(const Time& t);
	Time	operator-=(const Time& t);
	Time	operator*(const long c);
	operator double();	// in seconds
	char*	asctime();
	char*	hmstime();	// in format "XX:XX:XX.XX"
	redefined void		print(Ostream&);
	redefined void		ask(Istream&);
	redefined String	className() const
					{ return "Time"; }
};

extern Time	dummyTime;

inline Time	min(Time t1, Time t2)
			{ return (t1 < t2) ? t1 : t2; }

DECLARE_OTSO_RETURN_TYPE(Time);
